/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.data.Parameter;
import org.geotools.feature.NameImpl;
import org.geotools.filter.FunctionFactory;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.process.Process;
import org.geotools.process.ProcessFactory;
import org.geotools.process.Processors;
import org.geotools.process.RenderingProcess;
import org.geotools.process.function.ParameterFunction;
import org.geotools.process.function.ProcessFunction;
import org.geotools.process.function.RenderingProcessFunction;
import org.opengis.feature.type.Name;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public class ProcessFunctionFactory
implements FunctionFactory {
    public static final String PRIMARY_OUTPUT = "PRIMARY";
    static final Comparator<ProcessFactory> FACTORY_COMPARATOR = new Comparator<ProcessFactory>(){

        @Override
        public int compare(ProcessFactory pf1, ProcessFactory pf2) {
            if (pf1.getTitle() == null) {
                if (pf2.getTitle() == null) {
                    return 0;
                }
                return -1;
            }
            if (pf2.getTitle() == null) {
                return 1;
            }
            return pf1.getTitle().compareTo((Object)pf2.getTitle());
        }
    };
    HashMap<Name, FunctionName> processToFunction;
    private ArrayList<FunctionName> functionNames;

    @Override
    public Function function(String name, List<Expression> args, Literal fallback) {
        return this.function(new NameImpl(name), args, fallback);
    }

    @Override
    public Function function(Name processName, List<Expression> args, Literal fallback) {
        if (processName.equals(new NameImpl("parameter"))) {
            return new ParameterFunction(fallback, args);
        }
        if (this.functionNames == null) {
            this.init();
        }
        if (!this.processToFunction.containsKey(processName)) {
            return null;
        }
        Process process = Processors.createProcess(processName);
        Map<String, Parameter<?>> parameters = Processors.getParameterInfo(processName);
        if (process instanceof RenderingProcess) {
            return new RenderingProcessFunction(processName.getLocalPart(), processName, args, parameters, (RenderingProcess)process, fallback);
        }
        return new ProcessFunction(processName.getLocalPart(), processName, args, parameters, process, fallback);
    }

    @Override
    public List<FunctionName> getFunctionNames() {
        if (this.functionNames == null) {
            this.init();
        }
        return this.functionNames;
    }

    private synchronized void init() {
        if (this.functionNames == null) {
            ArrayList<ProcessFactory> factories = new ArrayList<ProcessFactory>(Processors.getProcessFactories());
            Collections.sort(factories, FACTORY_COMPARATOR);
            this.processToFunction = new HashMap();
            this.functionNames = new ArrayList();
            for (ProcessFactory factory : factories) {
                for (Name processName : factory.getNames()) {
                    Map<String, Parameter<?>> resultInfo = factory.getResultInfo(processName, null);
                    if (this.getPrimary(resultInfo) == null) continue;
                    Map<String, Parameter<?>> parameterInfo = factory.getParameterInfo(processName);
                    ArrayList<String> argumentNames = new ArrayList<String>(parameterInfo.keySet());
                    FunctionNameImpl functionName = new FunctionNameImpl(processName, argumentNames);
                    this.functionNames.add((FunctionName)functionName);
                    this.processToFunction.put(processName, (FunctionName)functionName);
                }
            }
            this.functionNames.add((FunctionName)new FunctionNameImpl("parameter", -1));
        }
    }

    private String getPrimary(Map<String, Parameter<?>> resultInfo) {
        if (resultInfo.size() == 1) {
            return resultInfo.values().iterator().next().getName();
        }
        for (Parameter<?> param : resultInfo.values()) {
            if (!param.isRequired().booleanValue()) continue;
            return param.getName();
        }
        return null;
    }

    public void clear() {
        this.functionNames = null;
        this.processToFunction = null;
    }
}

