/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.geotools.data.shapefile.FileReader;
import org.geotools.data.shapefile.ShpFiles;

public class ReadableByteChannelDecorator
implements ReadableByteChannel {
    private final ReadableByteChannel wrapped;
    private final ShpFiles shapefileFiles;
    private final URL url;
    private final FileReader requestor;
    private boolean closed;

    public ReadableByteChannelDecorator(ReadableByteChannel newChannel, ShpFiles shapefileFiles, URL url, FileReader requestor) {
        this.wrapped = newChannel;
        this.shapefileFiles = shapefileFiles;
        this.url = url;
        this.requestor = requestor;
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.wrapped.close();
        }
        finally {
            if (!this.closed) {
                this.closed = true;
                this.shapefileFiles.unlockRead(this.url, this.requestor);
            }
        }
    }

    @Override
    public boolean isOpen() {
        return this.wrapped.isOpen();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.wrapped.read(dst);
    }
}

