/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.arcsde;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.refractions.udig.catalog.AbstractDataStoreServiceExtension;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.ServiceExtension;
import net.refractions.udig.catalog.arcsde.internal.Messages;
import net.refractions.udig.catalog.internal.arcsde.ArcServiceImpl;
import org.geotools.arcsde.ArcSDEDataStoreFactory;
import org.geotools.data.DataStoreFactorySpi;

public class ArcServiceExtension
extends AbstractDataStoreServiceExtension
implements ServiceExtension {
    private static ArcSDEDataStoreFactory factory = null;

    public IService createService(URL id, Map<String, Serializable> params) {
        ArcSDEDataStoreFactory factory = ArcServiceExtension.getFactory();
        if (params != null && params.containsKey(ArcSDEDataStoreFactory.PORT_PARAM.key) && params.get(ArcSDEDataStoreFactory.PORT_PARAM.key) instanceof String) {
            String val = (String)((Object)params.get(ArcSDEDataStoreFactory.PORT_PARAM.key));
            params.put(ArcSDEDataStoreFactory.PORT_PARAM.key, Integer.valueOf(val));
        }
        if (!factory.canProcess(params)) {
            return null;
        }
        if (id == null) {
            String host = (String)((Object)params.get(ArcSDEDataStoreFactory.SERVER_PARAM.key));
            String port = params.get(ArcSDEDataStoreFactory.PORT_PARAM.key).toString();
            String db = (String)((Object)params.get(ArcSDEDataStoreFactory.INSTANCE_PARAM.key));
            if (db == null) {
                db = "";
            }
            try {
                URL serviceId = new URL("http://" + host + ":" + port + "/arcsde/" + db);
                return new ArcServiceImpl(serviceId, params);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return null;
            }
        }
        return new ArcServiceImpl(id, params);
    }

    public Map<String, Serializable> createParams(URL url) {
        if (!ArcServiceExtension.isArcSDE(url)) {
            return null;
        }
        AbstractDataStoreServiceExtension.ParamInfo info = this.parseParamInfo(url);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put(ArcSDEDataStoreFactory.DBTYPE_PARAM.key, (Serializable)ArcSDEDataStoreFactory.DBTYPE_PARAM.sample);
        params.put(ArcSDEDataStoreFactory.SERVER_PARAM.key, (Serializable)((Object)info.host));
        params.put(ArcSDEDataStoreFactory.PORT_PARAM.key, info.the_port);
        params.put(ArcSDEDataStoreFactory.INSTANCE_PARAM.key, (Serializable)((Object)info.the_database));
        params.put(ArcSDEDataStoreFactory.USER_PARAM.key, (Serializable)((Object)info.username));
        params.put(ArcSDEDataStoreFactory.PASSWORD_PARAM.key, (Serializable)((Object)info.password));
        if (ArcServiceExtension.getFactory().canProcess(params)) {
            return params;
        }
        return null;
    }

    public static final boolean isArcSDE(URL url) {
        if (url == null) {
            return false;
        }
        return url.getProtocol().toLowerCase().equals("arcsde");
    }

    protected static ArcSDEDataStoreFactory getFactory() {
        if (factory == null) {
            factory = new ArcSDEDataStoreFactory();
        }
        return factory;
    }

    protected String doOtherChecks(Map<String, Serializable> params) {
        return null;
    }

    protected DataStoreFactorySpi getDataStoreFactory() {
        return ArcServiceExtension.getFactory();
    }

    public String reasonForFailure(URL url) {
        if (url == null) {
            return Messages.ArcServiceExtension_urlNull;
        }
        if (!ArcServiceExtension.isArcSDE(url)) {
            return Messages.ArcServiceExtension_notSDEURL;
        }
        return this.reasonForFailure(this.createParams(url));
    }
}

