/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.arcsde;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.internal.arcsde.ArcSDEVectorService;
import net.refractions.udig.catalog.internal.arcsde.ArcServiceImpl;
import net.refractions.udig.catalog.util.GeotoolsResourceInfoAdapter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.data.DataStore;
import org.geotools.data.ResourceInfo;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;

class ArcSDEVectorGeoResource
extends IGeoResource {
    String typename = null;

    public ArcSDEVectorGeoResource(ArcServiceImpl service, String typename) {
        this.service = service;
        this.typename = typename;
    }

    public URL getIdentifier() {
        try {
            return new URL(String.valueOf(this.service.getIdentifier().toString()) + "#" + this.typename);
        }
        catch (MalformedURLException malformedURLException) {
            return this.service.getIdentifier();
        }
    }

    public IResolve.Status getStatus() {
        return this.service.getStatus();
    }

    public Throwable getMessage() {
        return this.service.getMessage();
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (adaptee == null) {
            return null;
        }
        if (adaptee.isAssignableFrom(IService.class)) {
            return adaptee.cast((Object)this.service(monitor));
        }
        if (adaptee.isAssignableFrom(IGeoResource.class)) {
            return adaptee.cast((Object)this);
        }
        if (adaptee.isAssignableFrom(IGeoResourceInfo.class)) {
            return adaptee.cast(this.createInfo(monitor));
        }
        if (adaptee.isAssignableFrom(SimpleFeatureStore.class)) {
            DataStore dataStore = this.getDataStore(monitor);
            SimpleFeatureSource fs = dataStore.getFeatureSource(this.typename);
            if (fs instanceof SimpleFeatureStore) {
                return adaptee.cast(fs);
            }
            if (adaptee.isAssignableFrom(SimpleFeatureSource.class)) {
                return adaptee.cast(fs);
            }
        }
        return (T)super.resolve(adaptee, monitor);
    }

    public DataStore getDataStore(IProgressMonitor monitor) throws IOException {
        ArcServiceImpl service = this.service(monitor);
        ArcSDEVectorService vectorService = service.getVectorService();
        DataStore dataStore = vectorService.getDataStore(monitor);
        return dataStore;
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(IGeoResourceInfo.class) || adaptee.isAssignableFrom(SimpleFeatureStore.class) || adaptee.isAssignableFrom(SimpleFeatureSource.class) || super.canResolve(adaptee);
    }

    protected IGeoResourceInfo createInfo(IProgressMonitor monitor) throws IOException {
        DataStore dataStore = this.getDataStore(monitor);
        SimpleFeatureSource fs = dataStore.getFeatureSource(this.typename);
        ResourceInfo gtinfo = fs.getInfo();
        GeotoolsResourceInfoAdapter vectorInfo = new GeotoolsResourceInfoAdapter(gtinfo);
        return vectorInfo;
    }

    public ArcServiceImpl service(IProgressMonitor monitor) throws IOException {
        return (ArcServiceImpl)super.service(monitor);
    }
}

