/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.internal;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.internal.command.navigation.ZoomCommand;
import net.refractions.udig.project.render.IViewportModel;
import net.refractions.udig.project.ui.commands.DrawCommandFactory;
import net.refractions.udig.project.ui.commands.SelectionBoxCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import net.refractions.udig.project.ui.tool.AbstractModalTool;
import net.refractions.udig.project.ui.tool.ModalTool;
import net.refractions.udig.tools.internal.NavigationUpdateThread;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class Zoom
extends AbstractModalTool
implements ModalTool {
    public static final int ZOOMFACTOR = 2;
    private boolean zooming;
    private Point start;
    DrawCommandFactory dfactory = DrawCommandFactory.getInstance();
    SelectionBoxCommand shapeCommand = new SelectionBoxCommand();
    boolean showContextOnRightClick = false;

    public Zoom() {
        super(3);
    }

    public void mouseDragged(MapMouseEvent e) {
        if (this.start == null) {
            this.mousePressed(e);
            return;
        }
        this.shapeCommand.setShape((Shape)new Rectangle(Math.min(this.start.x, e.x), Math.min(this.start.y, e.y), Math.abs(e.x - this.start.x), Math.abs(this.start.y - e.y)));
        this.context.getViewportPane().repaint();
    }

    Rectangle calculateOriginRectImproved(MapMouseEvent e) {
        int height;
        int width;
        if (this.start == null) {
            this.mousePressed(e);
        }
        int x1 = this.start.x;
        int x2 = e.x;
        int y1 = this.start.y;
        int y2 = e.y;
        int height1 = Math.abs(y2 - y1);
        int width1 = (int)((double)height1 * this.context.getViewportModel().getAspectRatio());
        int width2 = Math.abs(x2 - x1);
        int height2 = (int)((double)width2 / this.context.getViewportModel().getAspectRatio());
        if (height1 > height2) {
            width = width1;
            height = height1;
        } else {
            width = width2;
            height = height2;
        }
        int x = x1;
        int y = y1;
        x = x1 > x2 ? x1 - width + (width - Math.abs(x2 - x1)) / 2 : (x -= (width - Math.abs(x2 - x1)) / 2);
        y = y1 > y2 ? y1 - height + (height - Math.abs(y2 - y1)) / 2 : (y -= (height - Math.abs(y2 - y1)) / 2);
        return new Rectangle(x, y, width, height);
    }

    public void mousePressed(MapMouseEvent e) {
        if (e.button == 32 && this.showContextOnRightClick) {
            ((ViewportPane)e.source).getMapEditor().openContextMenu();
            return;
        }
        if (!e.isAltDown() && !e.isShiftDown() && (e.button == 8 || e.button == 32 || e.button == 8 && e.isControlDown())) {
            this.zooming = true;
            this.start = e.getPoint();
            this.shapeCommand.setValid(true);
            this.shapeCommand.setShape((Shape)new Rectangle(this.start.x, this.start.y, 0, 0));
            this.getContext().sendASyncCommand((Command)this.shapeCommand);
        }
    }

    public void mouseReleased(MapMouseEvent e) {
        if (e.button == 32 && this.showContextOnRightClick) {
            ((ViewportPane)e.source).getMapEditor().openContextMenu();
            return;
        }
        if (this.zooming) {
            IViewportModel m = this.getContext().getViewportModel();
            if (Math.abs(this.start.x - e.x) < 5 && Math.abs(this.start.y - e.y) < 5) {
                switch (e.button) {
                    case 8: {
                        if (e.isControlDown()) {
                            this.zoomout(m);
                            break;
                        }
                        this.zoomIn(m);
                        break;
                    }
                    case 32: {
                        this.zoomout(m);
                    }
                }
                this.shapeCommand.setValid(false);
                return;
            }
            Rectangle r = this.calculateOriginRectImproved(e);
            switch (e.button) {
                case 8: {
                    if (e.isControlDown()) {
                        this.zoomout(m, r);
                        break;
                    }
                    this.zoomin(m, r);
                    break;
                }
                case 32: {
                    this.zoomout(m, r);
                    break;
                }
            }
            this.zooming = false;
            this.shapeCommand.setValid(false);
        }
    }

    private void zoomout(IViewportModel m) {
        NavigationUpdateThread.getUpdater().zoomWithFixedPoint(-2, this.context, 500, this.start);
    }

    private void zoomIn(IViewportModel m) {
        NavigationUpdateThread.getUpdater().zoomWithFixedPoint(2, this.context, 500, this.start);
    }

    private void zoomin(IViewportModel m, Rectangle r) {
        ReferencedEnvelope worldBounds = this.getContext().worldBounds(r);
        ZoomCommand cmd = new ZoomCommand((Envelope)worldBounds);
        this.getContext().sendASyncCommand((Command)cmd);
    }

    private void zoomout(IViewportModel m, Rectangle r) {
        try {
            Coordinate center = m.pixelToWorld((int)r.getCenterX(), (int)r.getCenterY());
            double zoomFactor = (double)r.width / (double)this.getContext().getMapDisplay().getWidth();
            ZoomCommand cmd = new ZoomCommand(zoomFactor);
            cmd.setFixedPoint(center);
            this.getContext().sendASyncCommand((Command)cmd);
        }
        catch (Exception exception) {
            return;
        }
    }

    public boolean isShowContextOnRightClick() {
        return this.showContextOnRightClick;
    }

    public void setShowContextOnRightClick(boolean showContextOnRightClick) {
        this.showContextOnRightClick = showContextOnRightClick;
    }
}

