/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.internal;

import com.vividsolutions.jts.geom.Coordinate;
import net.refractions.udig.project.internal.render.ViewportModel;
import net.refractions.udig.project.internal.render.impl.ViewportModelImpl;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import net.refractions.udig.project.ui.tool.AbstractModalTool;
import net.refractions.udig.project.ui.tool.ModalTool;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class ScrollPanTool
extends AbstractModalTool
implements ModalTool {
    private boolean dragging = false;
    private Point start = null;

    public ScrollPanTool() {
        super(3);
    }

    public void mouseDragged(MapMouseEvent e) {
        if (this.dragging) {
            Point p = Display.getCurrent().map((Control)((Canvas)this.context.getViewportPane()), null, e.x, e.y);
            int xdiff = p.x - this.start.x;
            int ydiff = p.y - this.start.y;
            ReferencedEnvelope bounds = this.context.getViewportModel().getBounds();
            Coordinate oldc = this.context.pixelToWorld(this.start.x, this.start.y);
            Coordinate newc = this.context.pixelToWorld(p.x, p.y);
            double xoffset = newc.x - oldc.x;
            double yoffset = newc.y - oldc.y;
            ReferencedEnvelope newbounds = new ReferencedEnvelope(bounds.getMinX() - xoffset, bounds.getMaxX() - xoffset, bounds.getMinY() - yoffset, bounds.getMaxY() - yoffset, bounds.getCoordinateReferenceSystem());
            ((Canvas)this.context.getViewportPane()).scroll(xdiff, ydiff, 0, 0, this.context.getMapDisplay().getWidth(), this.context.getMapDisplay().getHeight(), true);
            ((ViewportModel)this.context.getViewportModel()).setBounds(newbounds);
            this.start = p;
        }
    }

    public void mousePressed(MapMouseEvent e) {
        if (this.validModifierButtonCombo(e)) {
            ((ViewportPane)this.context.getMapDisplay()).enableDrawCommands(false);
            ((ViewportModel)this.context.getViewportModel()).setIsBoundsChanging(true);
            this.dragging = true;
            this.start = Display.getCurrent().map((Control)((Canvas)this.context.getViewportPane()), null, e.x, e.y);
        }
    }

    protected boolean validModifierButtonCombo(MapMouseEvent e) {
        return e.buttons == 8 && !e.modifiersDown();
    }

    public void mouseReleased(MapMouseEvent e) {
        if (this.dragging) {
            ((ViewportModel)this.context.getViewportModel()).setIsBoundsChanging(false);
            ((ViewportPane)this.context.getMapDisplay()).enableDrawCommands(true);
            this.dragging = false;
            Point p = Display.getCurrent().map((Control)((Canvas)this.context.getViewportPane()), null, e.x, e.y);
            int xdiff = p.x - this.start.x;
            int ydiff = p.y - this.start.y;
            ReferencedEnvelope bounds = this.context.getViewportModel().getBounds();
            Coordinate oldc = this.context.pixelToWorld(this.start.x, this.start.y);
            Coordinate newc = this.context.pixelToWorld(p.x, p.y);
            double xoffset = newc.x - oldc.x;
            double yoffset = newc.y - oldc.y;
            ReferencedEnvelope newbounds = new ReferencedEnvelope(bounds.getMinX() - xoffset, bounds.getMaxX() - xoffset, bounds.getMinY() - yoffset, bounds.getMaxY() - yoffset, bounds.getCoordinateReferenceSystem());
            ((Canvas)this.context.getViewportPane()).scroll(xdiff, ydiff, 0, 0, this.context.getMapDisplay().getWidth(), this.context.getMapDisplay().getHeight(), true);
            this.start = p;
            ((ViewportModelImpl)this.context.getViewportModel()).setBounds(newbounds);
        }
    }

    public void dispose() {
        super.dispose();
    }
}

