/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.internal;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.command.NavCommand;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.command.navigation.AbstractNavCommand;
import net.refractions.udig.project.internal.command.navigation.PanCommand;
import net.refractions.udig.project.internal.render.ViewportModel;
import net.refractions.udig.project.internal.render.impl.ViewportModelImpl;
import net.refractions.udig.project.ui.internal.commands.draw.TranslateCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import net.refractions.udig.project.ui.tool.AbstractModalTool;
import net.refractions.udig.project.ui.tool.ModalTool;
import net.refractions.udig.project.ui.tool.options.ToolOptionContributionItem;
import net.refractions.udig.tools.internal.ToolsPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class PanTool
extends AbstractModalTool
implements ModalTool {
    private ScrollStrategy strategy;
    IPropertyChangeListener prefListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if ("scale".equals(property) || "titled".equals(property)) {
                PanTool.this.syncStrategy();
            }
        }
    };

    public PanTool() {
        super(3);
        IPreferenceStore preferenceStore = ToolsPlugin.getDefault().getPreferenceStore();
        preferenceStore.addPropertyChangeListener(this.prefListener);
        this.syncStrategy();
    }

    public void syncStrategy() {
        IPreferenceStore preferenceStore = ToolsPlugin.getDefault().getPreferenceStore();
        boolean scale = preferenceStore.getBoolean("scale");
        boolean tiled = preferenceStore.getBoolean("titled");
        this.strategy = scale ? new FixedScale() : (tiled ? new Scroll() : new Pan());
    }

    protected boolean validModifierButtonCombo(MapMouseEvent e) {
        return e.buttons == 8 && !e.modifiersDown();
    }

    public void mouseDragged(MapMouseEvent e) {
        this.strategy.mouseDragged(e);
    }

    public void mousePressed(MapMouseEvent e) {
        this.strategy.mousePressed(e);
    }

    public void mouseReleased(MapMouseEvent e) {
        this.strategy.mouseReleased(e);
    }

    public void dispose() {
        if (this.strategy != null) {
            this.strategy.dispose();
            this.strategy = null;
        }
        super.dispose();
    }

    class FixedScale
    extends ScrollStrategy {
        private boolean dragging;
        private java.awt.Point start;
        private ReferencedEnvelope startbounds;
        TranslateCommand command;

        FixedScale() {
            this.dragging = false;
            this.start = null;
            this.startbounds = null;
        }

        @Override
        public void mouseDragged(MapMouseEvent e) {
            if (this.dragging) {
                this.command.setTranslation(e.x - this.start.x, e.y - this.start.y);
                PanTool.this.context.getViewportPane().repaint();
            }
        }

        @Override
        public void mousePressed(MapMouseEvent e) {
            if (PanTool.this.validModifierButtonCombo(e)) {
                ((ViewportPane)PanTool.this.context.getMapDisplay()).enableDrawCommands(false);
                this.dragging = true;
                this.start = e.getPoint();
                this.startbounds = new ReferencedEnvelope(PanTool.this.context.getViewportModel().getBounds());
                this.command = PanTool.this.context.getDrawFactory().createTranslateCommand(0, 0);
                PanTool.this.context.sendASyncCommand((Command)this.command);
            }
        }

        @Override
        public void mouseReleased(MapMouseEvent e) {
            if (this.dragging) {
                ((ViewportPane)PanTool.this.context.getMapDisplay()).enableDrawCommands(true);
                this.command.setTranslation(e.x - this.start.x, e.y - this.start.y);
                PanTool.this.context.getViewportPane().repaint();
                java.awt.Point end = e.getPoint();
                int deltax = end.x - this.start.x;
                double deltaxworld = PanTool.this.getContext().getViewportModel().getWidth() / (double)PanTool.this.getContext().getMapDisplay().getWidth() * (double)deltax;
                int deltay = end.y - this.start.y;
                double deltayworld = PanTool.this.getContext().getViewportModel().getHeight() / (double)PanTool.this.getContext().getMapDisplay().getHeight() * (double)deltay;
                Coordinate center = this.startbounds.centre();
                Coordinate newc = new Coordinate(center.x - deltaxworld, center.y + deltayworld);
                double dw = PanTool.this.getContext().getViewportModel().getBounds().getWidth() / 2.0;
                double dh = PanTool.this.getContext().getViewportModel().getBounds().getHeight() / 2.0;
                final Envelope newbounds = new Envelope(newc.x - dw, newc.x + dw, newc.y - dh, newc.y + dh);
                AbstractNavCommand setFinal = new AbstractNavCommand(){

                    protected void runImpl(IProgressMonitor monitor) throws Exception {
                        this.model.setBounds(newbounds);
                    }

                    public Command copy() {
                        return null;
                    }

                    public String getName() {
                        return "Fixed Scale Pan";
                    }
                };
                ((ViewportPane)PanTool.this.getContext().getMapDisplay()).update();
                PanTool.this.context.sendASyncCommand((Command)new PanAndInvalidate((NavCommand)setFinal, this.command));
                this.dragging = false;
            }
        }

        @Override
        public void dispose() {
            super.dispose();
        }
    }

    public static class OptionContribtionItem
    extends ToolOptionContributionItem {
        public IPreferenceStore fillFields(Composite parent) {
            Button check = new Button(parent, 32);
            check.setText("Scale");
            this.addField("scale", check);
            Button tiled = new Button(parent, 32);
            tiled.setText("Tiled");
            this.addField("titled", tiled);
            return ToolsPlugin.getDefault().getPreferenceStore();
        }
    }

    public class Pan
    extends ScrollStrategy {
        private boolean dragging;
        private java.awt.Point start;
        private TranslateCommand command;

        public Pan() {
            this.dragging = false;
            this.start = null;
        }

        @Override
        public void mouseDragged(MapMouseEvent e) {
            if (this.dragging) {
                this.command.setTranslation(e.x - this.start.x, e.y - this.start.y);
                PanTool.this.context.getViewportPane().repaint();
            }
        }

        @Override
        public void mousePressed(MapMouseEvent e) {
            if (PanTool.this.validModifierButtonCombo(e)) {
                ((ViewportPane)PanTool.this.context.getMapDisplay()).enableDrawCommands(false);
                this.dragging = true;
                this.start = e.getPoint();
                this.command = PanTool.this.context.getDrawFactory().createTranslateCommand(0, 0);
                PanTool.this.context.sendASyncCommand((Command)this.command);
            }
        }

        @Override
        public void mouseReleased(MapMouseEvent e) {
            if (this.dragging) {
                ((ViewportPane)PanTool.this.context.getMapDisplay()).enableDrawCommands(true);
                java.awt.Point end = e.getPoint();
                PanCommand finalPan = new PanCommand(this.start.x - end.x, this.start.y - end.y);
                ((ViewportPane)PanTool.this.getContext().getMapDisplay()).update();
                PanTool.this.context.sendASyncCommand((Command)new PanAndInvalidate((NavCommand)finalPan, this.command));
                this.dragging = false;
            }
        }
    }

    private class PanAndInvalidate
    implements Command,
    NavCommand {
        private NavCommand command;
        private TranslateCommand expire;

        PanAndInvalidate(NavCommand command, TranslateCommand expire) {
            this.command = command;
            this.expire = expire;
        }

        public Command copy() {
            return new PanAndInvalidate(this.command, this.expire);
        }

        public String getName() {
            return "PanAndDiscard";
        }

        public void run(IProgressMonitor monitor) throws Exception {
            this.expire.setValid(false);
            this.command.run(monitor);
        }

        public void setViewportModel(ViewportModel model) {
            this.command.setViewportModel(model);
        }

        public Map getMap() {
            return this.command.getMap();
        }

        public void setMap(IMap map) {
            this.command.setMap(map);
        }

        public void rollback(IProgressMonitor monitor) throws Exception {
            this.command.rollback(monitor);
        }
    }

    class Scroll
    extends ScrollStrategy {
        private boolean dragging;
        private Point start;

        Scroll() {
            this.dragging = false;
            this.start = null;
        }

        @Override
        public void mouseDragged(MapMouseEvent e) {
            if (this.dragging) {
                Point p = Display.getCurrent().map((Control)((Canvas)PanTool.this.context.getViewportPane()), null, e.x, e.y);
                int xdiff = p.x - this.start.x;
                int ydiff = p.y - this.start.y;
                ReferencedEnvelope bounds = PanTool.this.context.getViewportModel().getBounds();
                Coordinate oldc = PanTool.this.context.pixelToWorld(this.start.x, this.start.y);
                Coordinate newc = PanTool.this.context.pixelToWorld(p.x, p.y);
                double xoffset = newc.x - oldc.x;
                double yoffset = newc.y - oldc.y;
                ReferencedEnvelope newbounds = new ReferencedEnvelope(bounds.getMinX() - xoffset, bounds.getMaxX() - xoffset, bounds.getMinY() - yoffset, bounds.getMaxY() - yoffset, bounds.getCoordinateReferenceSystem());
                ((Canvas)PanTool.this.context.getViewportPane()).scroll(xdiff, ydiff, 0, 0, PanTool.this.context.getMapDisplay().getWidth(), PanTool.this.context.getMapDisplay().getHeight(), true);
                ((ViewportModel)PanTool.this.context.getViewportModel()).setBounds(newbounds);
                this.start = p;
            }
        }

        @Override
        public void mousePressed(MapMouseEvent e) {
            if (PanTool.this.validModifierButtonCombo(e)) {
                ((ViewportPane)PanTool.this.context.getMapDisplay()).enableDrawCommands(false);
                ((ViewportModel)PanTool.this.context.getViewportModel()).setIsBoundsChanging(true);
                this.dragging = true;
                this.start = Display.getCurrent().map((Control)((Canvas)PanTool.this.context.getViewportPane()), null, e.x, e.y);
            }
        }

        @Override
        public void mouseReleased(MapMouseEvent e) {
            if (this.dragging) {
                ((ViewportModel)PanTool.this.context.getViewportModel()).setIsBoundsChanging(false);
                ((ViewportPane)PanTool.this.context.getMapDisplay()).enableDrawCommands(true);
                this.dragging = false;
                Point p = Display.getCurrent().map((Control)((Canvas)PanTool.this.context.getViewportPane()), null, e.x, e.y);
                int xdiff = p.x - this.start.x;
                int ydiff = p.y - this.start.y;
                ReferencedEnvelope bounds = PanTool.this.context.getViewportModel().getBounds();
                Coordinate oldc = PanTool.this.context.pixelToWorld(this.start.x, this.start.y);
                Coordinate newc = PanTool.this.context.pixelToWorld(p.x, p.y);
                double xoffset = newc.x - oldc.x;
                double yoffset = newc.y - oldc.y;
                ReferencedEnvelope newbounds = new ReferencedEnvelope(bounds.getMinX() - xoffset, bounds.getMaxX() - xoffset, bounds.getMinY() - yoffset, bounds.getMaxY() - yoffset, bounds.getCoordinateReferenceSystem());
                ((Canvas)PanTool.this.context.getViewportPane()).scroll(xdiff, ydiff, 0, 0, PanTool.this.context.getMapDisplay().getWidth(), PanTool.this.context.getMapDisplay().getHeight(), true);
                this.start = p;
                ((ViewportModelImpl)PanTool.this.context.getViewportModel()).setBounds(newbounds);
            }
        }

        @Override
        public void dispose() {
            super.dispose();
        }
    }

    abstract class ScrollStrategy {
        ScrollStrategy() {
        }

        public void mouseDragged(MapMouseEvent e) {
        }

        public void mousePressed(MapMouseEvent e) {
        }

        public void mouseReleased(MapMouseEvent e) {
        }

        public void dispose() {
        }
    }
}

