/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.internal;

import java.awt.Point;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.command.NavCommand;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.command.navigation.PanCommand;
import net.refractions.udig.project.internal.render.ViewportModel;
import net.refractions.udig.project.ui.internal.commands.draw.TranslateCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import net.refractions.udig.project.ui.tool.AbstractModalTool;
import net.refractions.udig.project.ui.tool.ModalTool;
import org.eclipse.core.runtime.IProgressMonitor;

public class Pan
extends AbstractModalTool
implements ModalTool {
    private boolean dragging = false;
    private Point start = null;
    private TranslateCommand command;

    public Pan() {
        super(3);
    }

    public void mouseDragged(MapMouseEvent e) {
        if (this.dragging) {
            this.command.setTranslation(e.x - this.start.x, e.y - this.start.y);
            this.context.getViewportPane().repaint();
        }
    }

    public void mousePressed(MapMouseEvent e) {
        if (this.validModifierButtonCombo(e)) {
            ((ViewportPane)this.context.getMapDisplay()).enableDrawCommands(false);
            this.dragging = true;
            this.start = e.getPoint();
            this.command = this.context.getDrawFactory().createTranslateCommand(0, 0);
            this.context.sendASyncCommand((Command)this.command);
        }
    }

    protected boolean validModifierButtonCombo(MapMouseEvent e) {
        return e.buttons == 8 && !e.modifiersDown();
    }

    public void mouseReleased(MapMouseEvent e) {
        if (this.dragging) {
            ((ViewportPane)this.context.getMapDisplay()).enableDrawCommands(true);
            Point end = e.getPoint();
            PanCommand finalPan = new PanCommand(this.start.x - end.x, this.start.y - end.y);
            ((ViewportPane)this.getContext().getMapDisplay()).update();
            this.context.sendASyncCommand((Command)new PanAndInvalidate((NavCommand)finalPan, this.command));
            this.dragging = false;
        }
    }

    public void dispose() {
        super.dispose();
    }

    private class PanAndInvalidate
    implements Command,
    NavCommand {
        private NavCommand command;
        private TranslateCommand expire;

        PanAndInvalidate(NavCommand command, TranslateCommand expire) {
            this.command = command;
            this.expire = expire;
        }

        public Command copy() {
            return new PanAndInvalidate(this.command, this.expire);
        }

        public String getName() {
            return "PanAndDiscard";
        }

        public void run(IProgressMonitor monitor) throws Exception {
            this.expire.setValid(false);
            this.command.run(monitor);
        }

        public void setViewportModel(ViewportModel model) {
            this.command.setViewportModel(model);
        }

        public Map getMap() {
            return this.command.getMap();
        }

        public void setMap(IMap map) {
            this.command.setMap(map);
        }

        public void rollback(IProgressMonitor monitor) throws Exception {
            this.command.rollback(monitor);
        }
    }
}

