/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.internal;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.Point;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.internal.command.navigation.SetViewportCenterCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.tool.AbstractTool;
import net.refractions.udig.project.ui.tool.IToolContext;
import net.refractions.udig.tools.internal.Messages;
import net.refractions.udig.tools.internal.ToolsPlugin;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class CursorPosition
extends AbstractTool {
    private static final String ID = "CURSOR_POSITION_LABEL";

    public CursorPosition() {
        super(2);
    }

    public void setContext(IToolContext tools) {
        super.setContext(tools);
        PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                CursorPosition.this.getLabel();
            }
        });
    }

    public void mouseMoved(MapMouseEvent e) {
        LineItem label = this.getLabel();
        if (label == null) {
            return;
        }
        Point screen = e.getPoint();
        Coordinate world = this.getContext().pixelToWorld(screen.x, screen.y);
        if (world == null) {
            return;
        }
        label.setPosition(world);
    }

    LineItem getLabel() {
        if (this.getContext().getActionBars() == null) {
            return null;
        }
        IStatusLineManager bar = this.getContext().getActionBars().getStatusLineManager();
        if (bar == null) {
            return null;
        }
        LineItem item = (LineItem)bar.find(ID);
        if (item == null) {
            item = new LineItem(ID);
            bar.appendToGroup("END_GROUP", (IContributionItem)item);
            bar.update(true);
        }
        return item;
    }

    public void mouseDragged(MapMouseEvent e) {
        this.mouseMoved(e);
    }

    public static Coordinate parse(String value, CoordinateReferenceSystem crs) {
        String[] components;
        String modifiedvalue = value.trim();
        boolean latlong = false;
        String upperCase = modifiedvalue.toUpperCase();
        String tmp = modifiedvalue;
        modifiedvalue = CursorPosition.stripCode(modifiedvalue, upperCase);
        if (tmp.length() != modifiedvalue.length()) {
            latlong = true;
        }
        if ((components = modifiedvalue.split(",")).length == 1) {
            components = modifiedvalue.split(" ");
        }
        if (components.length == 1) {
            return null;
        }
        if (components[0].startsWith("(") || components[0].startsWith("[")) {
            components[0] = components[0].substring(1);
        }
        if (components[1].endsWith(")") || components[1].endsWith("]")) {
            components[1] = components[1].substring(0, components[1].length() - 1);
        }
        try {
            double arg1 = Double.parseDouble(components[0]);
            double arg0 = Double.parseDouble(components[1]);
            Coordinate coord = new Coordinate(arg1, arg0);
            if (latlong && crs != null) {
                try {
                    JTS.transform((Coordinate)coord, (Coordinate)coord, (MathTransform)CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)crs, (boolean)true));
                }
                catch (Exception e) {
                    ToolsPlugin.log(Messages.CursorPosition_transformError, e);
                }
            }
            return coord;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static String stripCode(String modifiedvalue, String upperCase) {
        String code = "LL";
        if (upperCase.endsWith(code)) {
            return modifiedvalue.substring(0, modifiedvalue.length() - code.length());
        }
        code = "L L";
        if (upperCase.endsWith(code)) {
            return modifiedvalue.substring(0, modifiedvalue.length() - code.length());
        }
        code = "LATLONG";
        if (upperCase.endsWith(code)) {
            return modifiedvalue.substring(0, modifiedvalue.length() - code.length());
        }
        code = "LAT LONG";
        if (upperCase.endsWith(code)) {
            return modifiedvalue.substring(0, modifiedvalue.length() - code.length());
        }
        code = "LAT LON";
        if (upperCase.endsWith(code)) {
            return modifiedvalue.substring(0, modifiedvalue.length() - code.length());
        }
        return modifiedvalue;
    }

    private class LineItem
    extends ContributionItem
    implements KeyListener,
    FocusListener {
        private static final double ACCURACY = 1.0E-7;
        private Text textArea;
        Coordinate position;

        LineItem(String id) {
            super(id);
        }

        public boolean isDynamic() {
            return true;
        }

        public void setPosition(Coordinate coord) {
            if (this.position != null && Math.abs(this.position.x - coord.x) < 1.0E-7 && Math.abs(this.position.y - coord.y) < 1.0E-7) {
                return;
            }
            this.position = coord;
            if (this.textArea != null && !this.textArea.isDisposed()) {
                this.textArea.setText(this.getString(coord));
            }
        }

        private String getString(Coordinate coord) {
            String value = String.valueOf(this.getString(coord.x)) + ", " + this.getString(coord.y);
            return value;
        }

        private String getString(double value) {
            if (Double.isNaN(value)) {
                return Messages.CursorPosition_not_a_number;
            }
            if (Double.isInfinite(value)) {
                return Messages.CursorPosition_infinity;
            }
            DecimalFormat format = (DecimalFormat)NumberFormat.getNumberInstance();
            format.setMaximumFractionDigits(4);
            format.setMinimumIntegerDigits(1);
            format.setGroupingUsed(false);
            String string = format.format(value);
            String[] parts = string.split("\\.");
            if (parts[0].length() > 3) {
                string = parts[0];
            }
            return string;
        }

        public void fill(Composite parent) {
            Label separator = new Label(parent, 2);
            StatusLineLayoutData data = new StatusLineLayoutData();
            data.widthHint = 1;
            data.heightHint = 15;
            separator.setLayoutData((Object)data);
            this.textArea = new Text(parent, 0x1000800);
            this.textArea.addKeyListener((KeyListener)this);
            this.textArea.addFocusListener((FocusListener)this);
            if (this.position != null) {
                this.textArea.setText(this.getString(this.position));
            }
            this.textArea.setToolTipText(Messages.CursorPosition_tooltip);
            this.setFont((Control)this.textArea);
            data = new StatusLineLayoutData();
            data.widthHint = 200;
            data.heightHint = 15;
            this.textArea.setLayoutData((Object)data);
        }

        void setFont(Control textArea2) {
            Display display = textArea2.getDisplay();
            FontData[] data = display.getFontList("courier", true);
            if (data.length < 1) {
                data = textArea2.getFont().getFontData();
            }
            int i = 0;
            while (i < data.length) {
                if ("macosx" == Platform.getOS()) {
                    data[i].setHeight(12);
                } else {
                    data[i].setHeight(10);
                }
                ++i;
            }
            textArea2.setFont(new Font((Device)textArea2.getDisplay(), data));
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if (e.character == '\r') {
                this.go();
            } else if (e.character == '\u001b') {
                this.textArea.setText(this.getString(this.position));
            }
        }

        private void go() {
            Coordinate newpos = CursorPosition.parse(this.textArea.getText(), CursorPosition.this.getContext().getCRS());
            if (Math.abs(newpos.x - this.position.x) > 1.0E-7 || Math.abs(newpos.y - this.position.y) > 1.0E-7) {
                this.setPosition(newpos);
                SetViewportCenterCommand c = new SetViewportCenterCommand(newpos);
                CursorPosition.this.getContext().sendASyncCommand((Command)c);
            }
        }

        public void focusGained(FocusEvent e) {
            int end = this.textArea.getText().length();
            this.textArea.setSelection(0, end);
        }

        public void focusLost(FocusEvent e) {
        }
    }
}

