/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.mysql.ui;

import com.mysql.jdbc.jdbc2.optional.MysqlDataSource;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import net.refractions.udig.catalog.service.database.DatabaseConnectionRunnable;
import org.eclipse.core.runtime.IProgressMonitor;

public class MySqlDatabaseConnectionRunnable
implements DatabaseConnectionRunnable {
    private volatile boolean ran = false;
    private volatile String result = null;
    private final Set<String> databaseNames = new HashSet<String>();
    private final String host;
    private final int port;
    private final String username;
    private final String password;

    public MySqlDatabaseConnectionRunnable(String host2, int port2, String username2, String password2) {
        this.host = host2;
        this.port = port2;
        this.username = username2;
        this.password = password2;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        MysqlDataSource ds = new MysqlDataSource();
        ds.setServerName(this.host);
        ds.setPort(this.port);
        ds.setDatabaseName("mysql");
        ds.setUser(this.username);
        ds.setPassword(this.password);
        DriverManager.setLoginTimeout(3);
        try {
            Connection connection = ds.getConnection();
            try {
                ResultSet rs = connection.getMetaData().getCatalogs();
                while (rs.next()) {
                    this.databaseNames.add(rs.getString(1));
                }
            }
            finally {
                connection.close();
            }
        }
        catch (SQLException e) {
            this.result = "Unrecognized connection failure: " + e.getMessage() + "\nCheck parameters and database.";
        }
        this.ran = true;
    }

    public String canConnect() throws IllegalStateException {
        if (!this.ran) {
            throw new IllegalStateException("run must complete running before this method is called.");
        }
        return this.result;
    }

    public String[] getDatabaseNames() {
        return this.databaseNames.toArray(new String[0]);
    }
}

