/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.mysql.ui;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.MySQLGeoResource;
import net.refractions.udig.catalog.MySQLServiceExtension;
import net.refractions.udig.catalog.MySQLServiceImpl;
import net.refractions.udig.catalog.internal.mysql.MySQLPlugin;
import net.refractions.udig.catalog.ui.UDIGConnectionFactory;
import org.geotools.data.mysql.MySQLDataStoreFactory;
import org.geotools.jdbc.JDBCDataStoreFactory;

public class MySQLuDigConnectionFactory
extends UDIGConnectionFactory {
    public boolean canProcess(Object context) {
        return this.toCapabilitiesURL(context) != null;
    }

    public Map<String, Serializable> createConnectionParameters(Object context) {
        if (context instanceof MySQLServiceImpl) {
            MySQLServiceImpl mysql = (MySQLServiceImpl)((Object)context);
            return mysql.getConnectionParams();
        }
        URL url = this.toCapabilitiesURL(context);
        if (url == null) {
            url = CatalogPlugin.locateURL((Object)context);
        }
        if (url != null && MySQLServiceExtension.isMySQL(url)) {
            List list = CatalogPlugin.getDefault().getLocalCatalog().find(url, null);
            for (IResolve resolve : list) {
                if (resolve instanceof MySQLServiceImpl) {
                    MySQLServiceImpl mysqlService = (MySQLServiceImpl)((Object)context);
                    return mysqlService.getConnectionParams();
                }
                if (!(resolve instanceof MySQLGeoResource)) continue;
                MySQLGeoResource layer = (MySQLGeoResource)resolve;
                try {
                    MySQLServiceImpl mysql = (MySQLServiceImpl)layer.parent(null);
                    return mysql.getConnectionParams();
                }
                catch (IOException iOException) {
                    this.toCapabilitiesURL(layer.getIdentifier());
                }
            }
            return this.createParams(url);
        }
        return null;
    }

    public URL createConnectionURL(Object context) {
        if (context instanceof URL) {
            return (URL)context;
        }
        if (context instanceof Map) {
            Map params = (Map)context;
            try {
                return MySQLServiceExtension.toURL(params);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        if (context instanceof String) {
            return this.toCapabilitiesURL((String)context);
        }
        return null;
    }

    protected URL toCapabilitiesURL(Object data) {
        if (data instanceof IResolve) {
            return this.toCapabilitiesURL((IResolve)data);
        }
        if (data instanceof URL) {
            return this.toCapabilitiesURL((URL)data);
        }
        if (data instanceof String) {
            return this.toCapabilitiesURL((String)data);
        }
        if (CatalogPlugin.locateURL((Object)data) != null) {
            return this.toCapabilitiesURL(CatalogPlugin.locateURL((Object)data));
        }
        return null;
    }

    protected URL toCapabilitiesURL(IResolve resolve) {
        if (resolve instanceof IService) {
            return this.toCapabilitiesURL((IService)resolve);
        }
        return this.toCapabilitiesURL(resolve.getIdentifier());
    }

    protected URL toCapabilitiesURL(IService resolve) {
        if (resolve instanceof MySQLServiceImpl) {
            return this.toCapabilitiesURL((MySQLServiceImpl)resolve);
        }
        return this.toCapabilitiesURL(resolve.getIdentifier());
    }

    protected URL toCapabilitiesURL(MySQLServiceImpl postgis) {
        return postgis.getIdentifier();
    }

    protected URL toCapabilitiesURL(URL url) {
        String protocol;
        if (url == null) {
            return null;
        }
        String string = protocol = url.getProtocol() != null ? url.getProtocol().toLowerCase() : null;
        if (!"http".equals(protocol) && !"https".equals(protocol)) {
            return null;
        }
        if (url.toExternalForm().indexOf("mysql.jdbc") != -1) {
            return url;
        }
        return null;
    }

    protected URL toCapabilitiesURL(String string) {
        Integer intPort;
        String the_database;
        String the_port;
        if (string == null) {
            return null;
        }
        if (!(string.contains("mysql.jdbc") || string.contains("jdbc.mysql") || string.contains("mysql"))) {
            return null;
        }
        int startindex = string.indexOf("//") + 2;
        int usernameEnd = string.indexOf(":", startindex);
        int passwordEnd = string.indexOf("@", usernameEnd);
        int hostEnd = string.indexOf(":", passwordEnd);
        int portEnd = string.indexOf("/", hostEnd);
        int databaseEnd = string.indexOf("/", portEnd + 1);
        String the_host = string.substring(passwordEnd + 1, hostEnd);
        String the_username = string.substring(startindex, usernameEnd);
        String the_password = string.substring(usernameEnd + 1, passwordEnd);
        if (portEnd < 1) {
            the_port = string.substring(hostEnd + 1);
            the_database = "";
        } else {
            the_port = string.substring(hostEnd + 1, portEnd);
            the_database = string.substring(portEnd + 1, databaseEnd);
        }
        try {
            intPort = Integer.valueOf(the_port);
        }
        catch (NumberFormatException numberFormatException) {
            intPort = 3306;
        }
        URL url = null;
        try {
            url = MySQLServiceExtension.toURL(the_username, the_password, the_host, intPort, the_database);
        }
        catch (MalformedURLException e) {
            MySQLPlugin.log("bad url", e);
        }
        return url;
    }

    protected Map<String, Serializable> createParams(URL url) {
        MySQLServiceExtension serviceFactory = new MySQLServiceExtension();
        Map<String, Serializable> params = serviceFactory.createParams(url);
        if (params != null) {
            return params;
        }
        HashMap<String, Serializable> params2 = new HashMap<String, Serializable>();
        params2.put(MySQLDataStoreFactory.DBTYPE.key, (Serializable)MySQLDataStoreFactory.DBTYPE.sample);
        params2.put(JDBCDataStoreFactory.HOST.key, (Serializable)((Object)url.getHost()));
        params2.put(MySQLDataStoreFactory.PORT.key, Integer.valueOf(url.getPort() != -1 ? url.getPort() : 3306));
        String the_database = url.getPath() == null ? "" : url.getPath();
        params2.put(JDBCDataStoreFactory.DATABASE.key, (Serializable)((Object)the_database));
        String userInfo = url.getUserInfo() == null ? "" : url.getUserInfo();
        params2.put(JDBCDataStoreFactory.USER.key, (Serializable)((Object)userInfo));
        params2.put(JDBCDataStoreFactory.PASSWD.key, (Serializable)((Object)""));
        return params2;
    }
}

