/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Connection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveChangeEvent;
import net.refractions.udig.catalog.IResolveDelta;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceInfo;
import net.refractions.udig.catalog.MySQLGeoResource;
import net.refractions.udig.catalog.MySQLServiceExtension;
import net.refractions.udig.catalog.internal.CatalogImpl;
import net.refractions.udig.catalog.internal.ResolveChangeEvent;
import net.refractions.udig.catalog.internal.ResolveDelta;
import net.refractions.udig.catalog.internal.mysql.MySQLPlugin;
import net.refractions.udig.ui.UDIGDisplaySafeLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.geotools.data.mysql.MySQLDataStoreFactory;
import org.geotools.jdbc.JDBCDataStore;

public class MySQLServiceImpl
extends IService {
    private URL url = null;
    private Map<String, Serializable> params = null;
    protected Lock rLock = new UDIGDisplaySafeLock();
    private volatile List<MySQLGeoResource> members = null;
    private Throwable msg = null;
    private volatile JDBCDataStore ds = null;
    private Lock dsInstantiationLock = new UDIGDisplaySafeLock();

    public MySQLServiceImpl(URL arg1, Map<String, Serializable> arg2) {
        this.url = arg1;
        this.params = arg2;
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (adaptee == null) {
            throw new NullPointerException("No adaptor specified");
        }
        if (adaptee.isAssignableFrom(JDBCDataStore.class)) {
            return adaptee.cast(this.getDS());
        }
        return (T)super.resolve(adaptee, monitor);
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(JDBCDataStore.class) || adaptee.isAssignableFrom(Connection.class) || super.canResolve(adaptee);
    }

    public void dispose(IProgressMonitor monitor) {
        super.dispose(monitor);
        if (this.ds != null) {
            this.ds.dispose();
        }
        if (this.members != null) {
            this.members = null;
        }
    }

    public List<MySQLGeoResource> resources(IProgressMonitor monitor) throws IOException {
        JDBCDataStore ds = this.getDS();
        this.rLock.lock();
        try {
            if (this.members == null) {
                this.members = new LinkedList<MySQLGeoResource>();
                String[] typenames = ds.getTypeNames();
                if (typenames != null) {
                    int i = 0;
                    while (i < typenames.length) {
                        this.members.add(new MySQLGeoResource(this, typenames[i]));
                        ++i;
                    }
                }
            }
        }
        finally {
            this.rLock.unlock();
        }
        return this.members;
    }

    public IServiceMySQLInfo getInfo(IProgressMonitor monitor) throws IOException {
        return (IServiceMySQLInfo)super.getInfo(monitor);
    }

    protected IServiceMySQLInfo createInfo(IProgressMonitor monitor) throws IOException {
        JDBCDataStore dataStore = this.getDS();
        if (dataStore == null) {
            return null;
        }
        this.rLock.lock();
        try {
            IServiceMySQLInfo iServiceMySQLInfo = new IServiceMySQLInfo(dataStore);
            return iServiceMySQLInfo;
        }
        finally {
            this.rLock.unlock();
        }
    }

    public Map<String, Serializable> getConnectionParams() {
        return this.params;
    }

    JDBCDataStore getDS() throws IOException {
        boolean changed;
        block7: {
            changed = false;
            this.dsInstantiationLock.lock();
            try {
                if (this.ds != null) break block7;
                changed = true;
                MySQLDataStoreFactory dsf = MySQLServiceExtension.getFactory();
                if (!dsf.canProcess(this.params)) break block7;
                try {
                    this.ds = dsf.createDataStore(this.params);
                }
                catch (IOException e) {
                    this.msg = e;
                    throw e;
                }
            }
            finally {
                this.dsInstantiationLock.unlock();
            }
        }
        if (changed) {
            ResolveDelta delta = new ResolveDelta((IResolve)this, IResolveDelta.Kind.CHANGED);
            ((CatalogImpl)CatalogPlugin.getDefault().getLocalCatalog()).fire((IResolveChangeEvent)new ResolveChangeEvent((Object)this, IResolveChangeEvent.Type.POST_CHANGE, (IResolveDelta)delta));
        }
        if (this.ds != null) {
            MySQLPlugin.addDataStore(this.ds);
        }
        return this.ds;
    }

    public IResolve.Status getStatus() {
        if (this.ds == null) {
            return super.getStatus();
        }
        return IResolve.Status.CONNECTED;
    }

    public Throwable getMessage() {
        return this.msg;
    }

    public URL getIdentifier() {
        return this.url;
    }

    private class IServiceMySQLInfo
    extends IServiceInfo {
        IServiceMySQLInfo(JDBCDataStore resource) {
            String[] tns = null;
            try {
                tns = resource.getTypeNames();
            }
            catch (IOException e) {
                MySQLPlugin.log("Unable to read typenames", e);
                tns = new String[]{};
            }
            this.keywords = new String[tns.length + 1];
            System.arraycopy(tns, 0, this.keywords, 1, tns.length);
            this.keywords[0] = "mysql";
            try {
                this.schema = new URI("jdbc://mysql/gml");
            }
            catch (URISyntaxException e) {
                MySQLPlugin.log(null, e);
            }
        }

        public String getDescription() {
            return MySQLServiceImpl.this.getIdentifier().toString();
        }

        public URI getSource() {
            try {
                return MySQLServiceImpl.this.getIdentifier().toURI();
            }
            catch (URISyntaxException e) {
                throw (RuntimeException)new RuntimeException().initCause(e);
            }
        }

        public String getTitle() {
            return "MySQL " + MySQLServiceImpl.this.getIdentifier();
        }
    }
}

