/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.imageio.internal;

import it.geosolutions.imageio.gdalframework.GDALImageReaderSpi;
import it.geosolutions.imageio.gdalframework.GDALUtilities;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.spi.ImageReaderSpi;
import net.refractions.udig.catalog.imageio.Activator;
import net.refractions.udig.catalog.service.FormatProvider;
import org.gdal.gdal.Driver;
import org.gdal.gdal.gdal;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFactorySpi;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.coverageio.BaseGridFormatFactorySPI;
import org.geotools.coverageio.gdal.BaseGDALGridFormat;

public class GDALFormatProvider
implements FormatProvider {
    private static final String SPI_ATTRIBUTE_GRID_FORMAT = "spi";
    private static final String GDAL_METADATA_DMD_EXTENSION = "DMD_EXTENSION";
    public static final Map<String, GridFormatFactorySpi> factories = new HashMap<String, GridFormatFactorySpi>();
    public static final Set<String> supportedExtensions = new HashSet<String>();

    static {
        if (GDALUtilities.isGDALAvailable()) {
            if (GDALUtilities.isDriverAvailable((String)"ECW")) {
                supportedExtensions.add("ecw");
            }
            if (GDALUtilities.isDriverAvailable((String)"MrSID")) {
                supportedExtensions.add("sid");
            }
            if (GDALUtilities.isDriverAvailable((String)"DTED")) {
                supportedExtensions.addAll(Arrays.asList("dt0", "dt1", "dt2"));
            }
            if (GDALUtilities.isDriverAvailable((String)"HFA")) {
                supportedExtensions.add("img");
            }
            if (GDALUtilities.isDriverAvailable((String)"NITF")) {
                supportedExtensions.add("ntf");
                supportedExtensions.addAll(Arrays.asList("gn1", "gn2", "gn3", "gn4", "gn5", "gn6", "gn7", "gn8", "gn9"));
                supportedExtensions.addAll(Arrays.asList("on1", "on2", "on3", "on4", "on5", "on6", "on7", "on8", "on9"));
                supportedExtensions.addAll(Arrays.asList("ja1", "ja2", "ja3", "ja4", "ja5", "ja6", "ja7", "ja8", "ja9"));
                supportedExtensions.addAll(Arrays.asList("jg1", "jg2", "jg3", "jg4", "jg5", "jg6", "jg7", "jg8", "jg9"));
                supportedExtensions.addAll(Arrays.asList("jn1", "jn2", "jn3", "jn4", "jn5", "jn6", "jn7", "jn8", "jn9"));
                supportedExtensions.addAll(Arrays.asList("tl1", "tl2", "tl3", "tl4", "tl5", "tl6", "tl7", "tl8", "tl9"));
                supportedExtensions.addAll(Arrays.asList("tp1", "tp2", "tp3", "tp4", "tp5", "tp6", "tp7", "tp8", "tp9"));
            }
        }
        GDALFormatProvider.loadProvidedFormats();
    }

    private static void loadProvidedFormats() {
        if (GDALUtilities.isGDALAvailable()) {
            GridFormatFinder.scanForPlugins();
            Set availableFormats = GridFormatFinder.getAvailableFormats();
            for (GridFormatFactorySpi gridFormatFactorySpi : availableFormats) {
                AbstractGridFormat format;
                if (!(gridFormatFactorySpi instanceof BaseGridFormatFactorySPI) || !gridFormatFactorySpi.isAvailable() || (format = gridFormatFactorySpi.createFormat()) == null || !(format instanceof BaseGDALGridFormat)) continue;
                GDALFormatProvider.getExtensionsForFormat(gridFormatFactorySpi, (BaseGDALGridFormat)format);
            }
        }
    }

    public Set<String> getExtensions() {
        HashSet<String> fileExtentsions = new HashSet<String>();
        for (String fileExtension : supportedExtensions) {
            fileExtentsions.add("*." + fileExtension);
        }
        return Collections.unmodifiableSet(fileExtentsions);
    }

    private static void getExtensionsForFormat(GridFormatFactorySpi gridFormatFactorySpi, BaseGDALGridFormat format) {
        GDALImageReaderSpi gdalSPI = null;
        try {
            if (format.getClass().getSuperclass().equals(BaseGDALGridFormat.class)) {
                ImageReaderSpi spi;
                Class<?> baseGDALGridFormatClass = format.getClass().getSuperclass();
                Field field = baseGDALGridFormatClass.getDeclaredField(SPI_ATTRIBUTE_GRID_FORMAT);
                field.setAccessible(true);
                Class<?> type = field.getType();
                if (type != null && type.equals(ImageReaderSpi.class) && (spi = (ImageReaderSpi)field.get(format)) instanceof GDALImageReaderSpi) {
                    gdalSPI = (GDALImageReaderSpi)spi;
                }
            }
        }
        catch (Exception e) {
            Activator.log("unable to load Extensions for imageio-ext Format " + format.getName(), e);
            return;
        }
        if (gdalSPI != null) {
            HashSet<String> extensions = new HashSet<String>();
            List supportedFormats = gdalSPI.getSupportedFormats();
            for (String supportedFormat : supportedFormats) {
                String[] fileSuffixes;
                String dmdExtension;
                if (!GDALUtilities.isDriverAvailable((String)supportedFormat)) continue;
                Driver getDriverByName = gdal.GetDriverByName((String)supportedFormat);
                if (getDriverByName != null && (dmdExtension = getDriverByName.GetMetadataItem(GDAL_METADATA_DMD_EXTENSION)) != null && dmdExtension.length() > 0) {
                    extensions.add(dmdExtension.trim().toLowerCase());
                }
                if ((fileSuffixes = gdalSPI.getFileSuffixes()) != null) {
                    String[] stringArray = fileSuffixes;
                    int n = fileSuffixes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String fileSuffix = stringArray[n2];
                        if (fileSuffix != null && fileSuffix.trim().length() > 0) {
                            extensions.add(fileSuffix.trim().toLowerCase());
                        }
                        ++n2;
                    }
                }
                if (extensions == null || extensions.isEmpty()) continue;
                supportedExtensions.addAll(extensions);
                factories.put(supportedFormat, gridFormatFactorySpi);
            }
        }
    }
}

