/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.mapgraphic.scalebar;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.MessageFormat;
import java.util.Locale;
import net.refractions.udig.catalog.util.CRSUtil;
import net.refractions.udig.core.IProviderWithParam;
import net.refractions.udig.core.Pair;
import net.refractions.udig.mapgraphic.MapGraphic;
import net.refractions.udig.mapgraphic.MapGraphicContext;
import net.refractions.udig.mapgraphic.internal.Messages;
import net.refractions.udig.mapgraphic.scalebar.BarStyle;
import net.refractions.udig.mapgraphic.scalebar.NiceIntegers;
import net.refractions.udig.mapgraphic.scalebar.Unit;
import net.refractions.udig.mapgraphic.scalebar.UnitPolicy;
import net.refractions.udig.mapgraphic.style.FontStyle;
import net.refractions.udig.mapgraphic.style.LocationStyleContent;
import net.refractions.udig.project.IStyleBlackboard;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.ui.graphics.ViewportGraphics;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ScalebarMapGraphic
implements MapGraphic {
    private static final String NUMBER_PATTERN = "{0,number,integer} ";
    private static final int BAR_WIDTH = 1;
    private static final int BAR_HEIGHT = 8;

    static int closestInt(int idealDistance, IProviderWithParam<Integer, Integer> range) {
        if (range == null) {
            throw new NullPointerException("Range cannot be null");
        }
        int result = -1;
        Integer next = (Integer)range.get((Object)-1);
        Integer previous = -1;
        while (next != null) {
            if (next == idealDistance) {
                result = next;
                break;
            }
            if (idealDistance < next) {
                result = previous;
                break;
            }
            previous = next;
            next = (Integer)range.get((Object)next);
        }
        return result;
    }

    @Override
    public void draw(MapGraphicContext context) {
        this.drawScaleDenom(context);
    }

    private void drawScaleDenom(MapGraphicContext context) {
        double scaleDenom = context.getViewportModel().getScaleDenominator();
        IMapDisplay display = context.getMapDisplay();
        int dpi = display.getDPI();
        int displayHeight = display.getHeight();
        double i = 1.0 / (double)dpi;
        double pixelInMeters = i * 0.0254;
        double inMeters = scaleDenom * pixelInMeters;
        Rectangle location = this.getGraphicLocation(context);
        context.getLabelPainter().put((Rectangle2D)location);
        if (inMeters == 0.0) {
            this.drawWarning(context.getGraphics(), location, displayHeight);
        } else {
            BarStyle type = this.getBarStyle(context);
            UnitPolicy scalebarUnits = type.getUnits();
            if (scalebarUnits == UnitPolicy.AUTO && CRSUtil.isCoordinateReferenceSystemImperial((CoordinateReferenceSystem)context.getCRS())) {
                scalebarUnits = UnitPolicy.IMPERIAL;
            }
            Pair<Integer, Pair<Integer, Unit>> result2 = null;
            result2 = scalebarUnits == UnitPolicy.IMPERIAL ? ScalebarMapGraphic.calculateUnitAndLength(inMeters, location.width / type.getNumintervals(), Unit.MILE, Unit.FOOT, Unit.YARD, Unit.INCHES) : ScalebarMapGraphic.calculateUnitAndLength(inMeters, location.width / type.getNumintervals(), Unit.KILOMETER, Unit.METER, Unit.CENTIMETER);
            int trueBarLength2 = (Integer)result2.getLeft() * type.getNumintervals();
            Pair unitMeasure2 = (Pair)result2.getRight();
            int nice2 = (Integer)unitMeasure2.getLeft();
            Unit measurement2 = (Unit)((Object)unitMeasure2.getRight());
            this.doDraw(measurement2, context, trueBarLength2, nice2);
        }
    }

    private Rectangle getGraphicLocation(MapGraphicContext context) {
        IStyleBlackboard styleBlackboard = context.getLayer().getStyleBlackboard();
        Rectangle location = (Rectangle)styleBlackboard.get("net.refractions.udig.printing.ui.locationStyle");
        if (location == null) {
            location = LocationStyleContent.createDefaultStyle();
            styleBlackboard.put("net.refractions.udig.printing.ui.locationStyle", (Object)location);
        }
        return location;
    }

    private FontStyle getFontStyle(MapGraphicContext context) {
        IStyleBlackboard styleBlackboard = context.getLayer().getStyleBlackboard();
        FontStyle style = (FontStyle)styleBlackboard.get("net.refractions.udig.mapgraphic.style.font");
        if (style == null) {
            style = new FontStyle();
            styleBlackboard.put("net.refractions.udig.mapgraphic.style.font", (Object)style);
        }
        return style;
    }

    private BarStyle getBarStyle(MapGraphicContext context) {
        IStyleBlackboard styleBlackboard = context.getLayer().getStyleBlackboard();
        BarStyle style = (BarStyle)styleBlackboard.get("net.refractions.udig.mapgraphic.style.bartype");
        if (style == null) {
            style = new BarStyle();
            styleBlackboard.put("net.refractions.udig.mapgraphic.style.bartype", (Object)style);
        }
        return style;
    }

    static Pair<Integer, Pair<Integer, Unit>> calculateUnitAndLength(double meterPerPixel, int idealBarLength, Unit ... units) {
        if (units == null || units.length == 0) {
            throw new IllegalArgumentException("units must have at least one unit");
        }
        double mIdealBarDistance = meterPerPixel * (double)idealBarLength;
        NiceIntegers niceIntegers = new NiceIntegers();
        Unit unit = units[0];
        double displayDistance = -1.0;
        int barLengthPixels = idealBarLength;
        int i = 0;
        while (displayDistance < 1.0 && i < units.length) {
            unit = units[i];
            displayDistance = ScalebarMapGraphic.closestInt((int)unit.meterToUnit(mIdealBarDistance), niceIntegers);
            barLengthPixels = (int)(unit.unitToMeter(displayDistance) / meterPerPixel);
            ++i;
        }
        Pair unitMeasure = new Pair((Object)((int)displayDistance), (Object)unit);
        return new Pair((Object)barLengthPixels, (Object)unitMeasure);
    }

    private void doDraw(Unit measurement, MapGraphicContext context, int trueBarLength, int nice) {
        FontStyle font;
        Rectangle location = this.getGraphicLocation(context);
        context.getLabelPainter().put((Rectangle2D)location);
        BarStyle type = this.getBarStyle(context);
        int x = location.x;
        int y = location.y;
        int width = trueBarLength;
        int height = location.height;
        if (x < 0) {
            x = context.getMapDisplay().getWidth() + x - trueBarLength;
        }
        if (y < 0) {
            y = context.getMapDisplay().getHeight() + y - height;
        }
        int barWidth = -1;
        Color bcolor = (Color)context.getMap().getBlackboard().get("mapBackgroundColor");
        BarStyle barStyle = this.getBarStyle(context);
        if (barStyle.getBgColor() != null) {
            bcolor = barStyle.getBgColor();
        }
        if (bcolor == null) {
            bcolor = Color.WHITE;
        }
        if ((font = this.getFontStyle(context)) != null && font.getFont() != null) {
            context.getGraphics().setFont(font.getFont());
        }
        Color maskColor = new Color(bcolor.getRed(), bcolor.getGreen(), bcolor.getBlue(), 80);
        this.computeAndDrawHalo(nice, context, measurement, type, x, y, width, height, maskColor);
        if (type.getType() == BarStyle.BarType.SIMPLE) {
            this.drawSimpleBar(context.getGraphics(), location, x, y, width, height, type.getColor());
            this.drawSingleLabel(context, measurement, nice * type.getNumintervals(), x, y, height, barWidth, width, type.getColor());
        } else if (type.getType() == BarStyle.BarType.SIMPLE_LINE) {
            this.drawLineBar(context.getGraphics(), location, x, y, width, height, type.getNumintervals(), type.getColor(), bcolor);
            this.drawIntervalLabels(context, measurement, nice, x, y, height, barWidth, width, type.getNumintervals(), type.getColor());
        } else if (type.getType() == BarStyle.BarType.FILLED) {
            this.drawFilled(context.getGraphics(), location, x, y, width, height, type.getNumintervals(), type.getColor(), bcolor);
            this.drawIntervalLabels(context, measurement, nice, x, y, height, barWidth, width, type.getNumintervals(), type.getColor());
        } else if (type.getType() == BarStyle.BarType.FILLED_LINE) {
            this.drawFilledLineBar(context.getGraphics(), location, x, y, width, height, type.getNumintervals(), type.getColor(), bcolor);
            this.drawIntervalLabels(context, measurement, nice, x, y, height, barWidth, width, type.getNumintervals(), type.getColor());
        }
    }

    private void computeAndDrawHalo(int nice, MapGraphicContext context, Unit measurement, BarStyle type, int x, int y, int width, int height, Color bgColor) {
        MessageFormat formatter = new MessageFormat("", Locale.getDefault());
        formatter.applyPattern(NUMBER_PATTERN + measurement.display);
        Object[] arguments = new Object[]{nice * type.getNumintervals()};
        String msg = formatter.format(arguments);
        Rectangle2D msgBounds = context.getGraphics().getStringBounds(msg);
        double textwidth = msgBounds.getWidth();
        double textheight = msgBounds.getHeight();
        if (type.getType() == BarStyle.BarType.SIMPLE) {
            textwidth = 10.0;
        }
        double halox = (double)(x + 1) - textwidth / 2.0;
        double halowidth = (double)(width / (type.getNumintervals() * 2) * type.getNumintervals() * 2) + textwidth + 5.0;
        double haloy = (double)(y + height - 8) - textheight - 2.0;
        double haloheight = 8.0 + textheight + 4.0;
        context.getGraphics().setColor(bgColor);
        RoundRectangle2D.Double roundBounds = new RoundRectangle2D.Double();
        ((RoundRectangle2D)roundBounds).setRoundRect(halox, haloy, halowidth, haloheight, 6.0, 6.0);
        context.getGraphics().fill((Shape)roundBounds);
    }

    private void drawSingleLabel(MapGraphicContext context, Unit measurement, int nice, int x, int y, int height, int barWidth, int width, Color c) {
        ViewportGraphics graphics = context.getGraphics();
        FontStyle font = this.getFontStyle(context);
        if (font != null && font.getFont() != null) {
            graphics.setFont(font.getFont());
        }
        MessageFormat formatter = new MessageFormat("", Locale.getDefault());
        formatter.applyPattern(NUMBER_PATTERN + measurement.display);
        Object[] arguments = new Object[]{nice};
        String msg = formatter.format(arguments);
        Rectangle2D msgBounds = graphics.getStringBounds(msg);
        int yText = y + (height - barWidth) - 4;
        int xText = x + (int)((double)width * 0.5) - (int)(msgBounds.getWidth() * 0.5);
        graphics.setColor(c);
        graphics.drawString(msg, xText, yText, -1, -1);
    }

    private void drawIntervalLabels(MapGraphicContext context, Unit measurement, int nice, int x, int y, int height, int barWidth, int width, int numIntervals, Color c) {
        ViewportGraphics graphics = context.getGraphics();
        FontStyle font = this.getFontStyle(context);
        if (font != null && font.getFont() != null) {
            graphics.setFont(font.getFont());
        }
        MessageFormat formatter = new MessageFormat("", Locale.getDefault());
        formatter.applyPattern(NUMBER_PATTERN);
        int i = -1;
        while (i < numIntervals - 1) {
            this.drawIntervalLabel(nice, x, y, height, barWidth, width, numIntervals, c, graphics, formatter, i);
            ++i;
        }
        formatter = new MessageFormat("", Locale.getDefault());
        formatter.applyPattern(NUMBER_PATTERN + measurement.display);
        this.drawIntervalLabel(nice, x, y, height, barWidth, width, numIntervals, c, graphics, formatter, numIntervals - 1);
    }

    private void drawIntervalLabel(int nice, int x, int y, int height, int barWidth, int width, int numIntervals, Color c, ViewportGraphics graphics, MessageFormat formatter, int i) {
        Object[] arguments = new Object[]{nice * i};
        String msg = formatter.format(arguments);
        msg = msg.trim();
        Rectangle2D msgBounds = graphics.getStringBounds(msg);
        int yText = y + (height - barWidth) - 12;
        int xText = x + barWidth + (i + 1) * (width / numIntervals) - (int)msgBounds.getWidth() / 2;
        graphics.setColor(c);
        graphics.drawString(msg, xText, yText, -1, -1);
    }

    private void drawSimpleBar(ViewportGraphics graphics, Rectangle location, int x, int y, int width, int height, Color c) {
        int barStartX = x + 1 + 0;
        int barStartY = y - 2 + location.height - 8;
        GeneralPath path = new GeneralPath();
        path.moveTo(barStartX, barStartY);
        path.lineTo(barStartX, barStartY + 8);
        path.lineTo(barStartX + width, barStartY + 8);
        path.lineTo(barStartX + width, barStartY);
        graphics.setColor(c);
        graphics.setStroke(1, 1);
        graphics.draw((Shape)path);
    }

    private void drawFilled(ViewportGraphics graphics, Rectangle location, int x, int y, int width, int height, int numIntervals, Color c, Color background) {
        int barStartX = x + 1 + 0;
        int barStartY = y - 2 + location.height - 8;
        int interval = width / (numIntervals * 2);
        Color color = c;
        Color intervalColor = background;
        graphics.setColor(color);
        graphics.fillRect(barStartX, barStartY, interval, 8);
        int i = 2;
        while (i < numIntervals * 2) {
            graphics.fillRect(barStartX + i * interval, barStartY, interval * 2, 8);
            i += 4;
        }
        graphics.setColor(intervalColor);
        graphics.fillRect(barStartX + interval, barStartY, interval, 8);
        i = 4;
        while (i < numIntervals * 2) {
            graphics.fillRect(barStartX + i * interval, barStartY, interval * 2, 8);
            i += 4;
        }
        GeneralPath path = new GeneralPath();
        path.moveTo(barStartX, barStartY);
        path.lineTo(barStartX, barStartY + 8);
        path.lineTo(barStartX + numIntervals * 2 * interval, barStartY + 8);
        path.lineTo(barStartX + numIntervals * 2 * interval, barStartY);
        path.lineTo(barStartX, barStartY);
        graphics.setColor(color);
        graphics.setStroke(1, 1);
        graphics.draw((Shape)path);
    }

    private void drawLineBar(ViewportGraphics graphics, Rectangle location, int x, int y, int width, int height, int numIntervals, Color c, Color bcolor) {
        int barStartX = x + 1 + 0;
        int barStartY = y - 2 + location.height - 8;
        int interval = width / (numIntervals * 2);
        graphics.setColor(bcolor);
        graphics.fillRect(barStartX, barStartY, interval * numIntervals * 2, 8);
        GeneralPath path = new GeneralPath();
        path.moveTo(barStartX, barStartY);
        path.lineTo(barStartX, barStartY + 8);
        path.lineTo(barStartX + numIntervals * 2 * interval, barStartY + 8);
        path.lineTo(barStartX + numIntervals * 2 * interval, barStartY);
        path.lineTo(barStartX, barStartY);
        path.moveTo(barStartX + interval, barStartY);
        path.lineTo(barStartX + interval, barStartY + 8);
        int i = 2;
        while (i < numIntervals * 2) {
            path.moveTo(barStartX + i * interval, barStartY);
            path.lineTo(barStartX + i * interval, barStartY + 8);
            i += 2;
        }
        path.moveTo(barStartX, barStartY + 4);
        path.lineTo(barStartX + interval, barStartY + 4);
        i = 2;
        while (i < numIntervals * 2) {
            path.moveTo(barStartX + i * interval, barStartY + 4);
            path.lineTo(barStartX + (i + 2) * interval, barStartY + 4);
            i += 4;
        }
        graphics.setColor(c);
        graphics.setStroke(1, 1);
        graphics.draw((Shape)path);
    }

    private void drawFilledLineBar(ViewportGraphics graphics, Rectangle location, int x, int y, int width, int height, int numIntervals, Color c, Color background) {
        int barStartX = x + 1 + 0;
        int barStartY = y - 2 + location.height - 8;
        int interval = width / (numIntervals * 2);
        Color color = c;
        Color intervalColor = background;
        graphics.setColor(color);
        graphics.fillRect(barStartX, barStartY, interval, 4);
        graphics.fillRect(barStartX + interval, barStartY + 4, interval, 4);
        int i = 2;
        while (i < numIntervals * 2) {
            if (i % 4 != 0) {
                graphics.fillRect(barStartX + i * interval, barStartY, interval * 2, 4);
            } else {
                graphics.fillRect(barStartX + i * interval, barStartY + 4, interval * 2, 4);
            }
            i += 2;
        }
        graphics.setColor(intervalColor);
        graphics.fillRect(barStartX, barStartY + 4, interval, 4);
        graphics.fillRect(barStartX + interval, barStartY, interval, 4);
        i = 2;
        while (i < numIntervals * 2) {
            if (i % 4 != 0) {
                graphics.fillRect(barStartX + i * interval, barStartY + 4, interval * 2, 4);
            } else {
                graphics.fillRect(barStartX + i * interval, barStartY, interval * 2, 4);
            }
            i += 2;
        }
        GeneralPath path = new GeneralPath();
        path.moveTo(barStartX, barStartY);
        path.lineTo(barStartX, barStartY + 8);
        path.lineTo(barStartX + numIntervals * 2 * interval, barStartY + 8);
        path.lineTo(barStartX + numIntervals * 2 * interval, barStartY);
        path.lineTo(barStartX, barStartY);
        path.moveTo(barStartX + interval, barStartY);
        path.lineTo(barStartX + interval, barStartY + 8);
        int i2 = 2;
        while (i2 < numIntervals * 2) {
            path.moveTo(barStartX + i2 * interval, barStartY);
            path.lineTo(barStartX + i2 * interval, barStartY + 8);
            i2 += 2;
        }
        graphics.setColor(color);
        graphics.setStroke(1, 1);
        graphics.draw((Shape)path);
    }

    private void drawWarning(ViewportGraphics graphics, Rectangle location, int displayHeight) {
        graphics.setColor(Color.GRAY);
        graphics.fillRect(location.x, location.y, location.width, location.height);
        graphics.setColor(Color.BLACK);
        graphics.draw((Shape)new Rectangle(location.x, location.y, location.width, location.height));
        int yText = location.y < displayHeight / 2 ? location.y + location.height + 15 : location.y - 15;
        graphics.drawString(Messages.ScalebarMapGraphic_zoomInRequiredMessage, location.x, yText, -1, -1);
    }
}

