/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.mapgraphic.scalebar;

import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.mapgraphic.MapGraphic;
import net.refractions.udig.mapgraphic.MapGraphicPlugin;
import net.refractions.udig.mapgraphic.scalebar.BarStyle;
import net.refractions.udig.mapgraphic.scalebar.UnitPolicy;
import net.refractions.udig.project.StyleContent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IMemento;

public class BarStyleContent
extends StyleContent {
    public static final String ID = "net.refractions.udig.mapgraphic.style.bartype";
    private static final String BARSTYLE = "BAR_STYLE";
    private static final String NUM_INTERVAL = "NUM_INTERVAL";
    private static final String COLOR_R = "R";
    private static final String COLOR_G = "G";
    private static final String COLOR_B = "B";
    private static final String UNITS = "UNITS";

    public BarStyleContent() {
        super(ID);
    }

    public Object createDefaultStyle(IGeoResource resource, Color colour, IProgressMonitor monitor) throws IOException {
        BarStyle style;
        if (!resource.canResolve(MapGraphic.class)) {
            return null;
        }
        if (resource.canResolve(BarStyle.class) && (style = (BarStyle)resource.resolve(BarStyle.class, monitor)) != null) {
            return style;
        }
        return new BarStyle();
    }

    public Class<?> getStyleClass() {
        return BarStyle.class;
    }

    public Object load(IMemento memento) {
        try {
            Integer R = memento.getInteger(COLOR_R);
            Integer G = memento.getInteger(COLOR_G);
            Integer B = memento.getInteger(COLOR_B);
            int r = R == null ? 0 : R;
            int g = G == null ? 0 : G;
            int b = B == null ? 0 : B;
            Color c = new Color(r, g, b);
            int numintervales = memento.getInteger(NUM_INTERVAL);
            String bartype = memento.getString(BARSTYLE);
            UnitPolicy units = UnitPolicy.valueOf(memento.getString(UNITS));
            BarStyle bs = new BarStyle(BarStyle.BarType.valueOf(bartype), c, numintervales, units);
            return bs;
        }
        catch (Throwable e) {
            MapGraphicPlugin.log("Error decoding the stored bar style", e);
            return new BarStyle();
        }
    }

    public Object load(URL url, IProgressMonitor monitor) throws IOException {
        return null;
    }

    public void save(IMemento memento, Object value) {
        BarStyle style = (BarStyle)value;
        memento.putString(BARSTYLE, style.getType().toString());
        memento.putInteger(NUM_INTERVAL, style.getNumintervals());
        memento.putInteger(COLOR_R, style.getColor().getRed());
        memento.putInteger(COLOR_G, style.getColor().getGreen());
        memento.putInteger(COLOR_B, style.getColor().getBlue());
        memento.putString(UNITS, style.getUnits().name());
    }
}

