/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.mapgraphic.scalebar;

import java.awt.Color;
import net.refractions.udig.mapgraphic.MapGraphicPlugin;
import net.refractions.udig.mapgraphic.internal.Messages;
import net.refractions.udig.mapgraphic.scalebar.UnitPolicy;
import org.eclipse.swt.graphics.Image;

public class BarStyle {
    public static final int MINIMUM_DIVISIONS = 2;
    public static final int MAXIMUM_DIVISIONS = 20;
    public static final int DIVISION_INCREMENT = 1;
    private Color color = Color.BLACK;
    private Color bgColor = null;
    private int numintervales = 4;
    private BarType type = BarType.SIMPLE;
    private UnitPolicy units = UnitPolicy.determineDefaultUnits();

    public BarStyle() {
    }

    public BarStyle(BarType type, Color color, int numintervals, UnitPolicy units) {
        this.type = type;
        this.color = color;
        this.numintervales = numintervals;
        this.units = units;
    }

    public Color getColor() {
        return this.color;
    }

    public int getNumintervals() {
        return this.numintervales;
    }

    public BarType getType() {
        return this.type;
    }

    public UnitPolicy getUnits() {
        return this.units;
    }

    public void setType(BarType type) {
        this.type = type;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public void setUnits(UnitPolicy newUnits) {
        this.units = newUnits;
    }

    public void setNumIntervals(int intervals) {
        this.numintervales = intervals;
    }

    public static BarType[] getTypes() {
        return new BarType[]{BarType.SIMPLE, BarType.SIMPLE_LINE, BarType.FILLED, BarType.FILLED_LINE};
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public static enum BarType {
        SIMPLE("simple.gif", Messages.BarStyle_LabelSimple),
        SIMPLE_LINE("simple_line.gif", Messages.BarStyle_LabelLine),
        FILLED("filled.gif", Messages.BarStyle_LabelFilled),
        FILLED_LINE("filled_line.gif", Messages.BarStyle_LabelFilledLine);

        public final String imageName;
        public final String name;

        private BarType(String imageName, String name) {
            this.imageName = "icons/obj/" + imageName;
            this.name = name;
        }

        public Image getImage() {
            return MapGraphicPlugin.getDefault().getImageRegistry().getDescriptor(this.imageName).createImage();
        }

        public String getName() {
            return this.name;
        }
    }
}

