/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.mapgraphic.northarrow;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import net.refractions.udig.mapgraphic.MapGraphic;
import net.refractions.udig.mapgraphic.MapGraphicContext;
import net.refractions.udig.project.IStyleBlackboard;
import net.refractions.udig.project.render.IViewportModel;
import net.refractions.udig.ui.graphics.ViewportGraphics;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class NorthArrowMapGraphic
implements MapGraphic {
    private static int ARROW_HEIGHT = 35;
    private static int ARROW_WIDTH = 22;
    private static int BOTTOM_INSET = 8;
    private static int SPACE_ABOVE_N = 3;
    private Point start;
    private Envelope look;
    private Point end;
    private double theta;
    static CoordinateReferenceSystem GROUND;

    static {
        try {
            GROUND = CRS.decode((String)"EPSG:4326");
        }
        catch (FactoryException factoryException) {
            GROUND = DefaultGeographicCRS.WGS84;
        }
    }

    @Override
    public void draw(MapGraphicContext context) {
        IViewportModel viewport = context.getViewportModel();
        Point here = this.start(context);
        if (here == null) {
            return;
        }
        ReferencedEnvelope bounds = viewport.getBounds();
        if (!here.equals(this.start) || !bounds.equals((Object)this.look)) {
            this.start = here;
            this.look = bounds;
            this.end = null;
            Coordinate worldStart = context.pixelToWorld(here.x, here.y);
            Coordinate groundStart = this.toGround(context, worldStart);
            if (groundStart == null) {
                return;
            }
            Coordinate groundNorth = this.moveNorth(groundStart);
            Coordinate worldNorth = this.fromGround(context, groundNorth);
            this.theta = this.theta(worldStart, worldNorth);
            double distance = context.getViewportModel().getPixelSize().y * 20.0;
            Coordinate destination = this.walk(worldStart, this.theta, distance);
            this.end = context.worldToPixel(destination);
        }
        if (this.start != null && this.end != null) {
            this.drawArrow(context, here);
        }
    }

    private void drawArrow(MapGraphicContext context, Point here) {
        ViewportGraphics g = context.getGraphics();
        AffineTransform t = g.getTransform();
        try {
            int nTop = ARROW_HEIGHT + SPACE_ABOVE_N;
            int arrowCenterX = ARROW_WIDTH / 2;
            int totalHeight = ARROW_HEIGHT + SPACE_ABOVE_N + g.getFontAscent();
            AffineTransform t1 = g.getTransform();
            AffineTransform t2 = g.getTransform();
            t1.translate(here.x + ARROW_WIDTH, here.y + totalHeight);
            t2.translate(here.x + ARROW_WIDTH, here.y + totalHeight);
            t1.scale(-1.0, -1.0);
            t1.rotate(1.5707963267948966);
            t1.rotate(-this.theta);
            g.setTransform(t1);
            g.setStroke(1, 1);
            Point tip = new Point(arrowCenterX, BOTTOM_INSET);
            Point centerBase = new Point(arrowCenterX, ARROW_HEIGHT);
            Point bottomLeft = new Point(0, 0);
            Point bottomRight = new Point(ARROW_WIDTH, 0);
            Polygon left = new Polygon();
            left.addPoint(centerBase.x, centerBase.y);
            left.addPoint(tip.x, tip.y);
            left.addPoint(bottomLeft.x, bottomLeft.y);
            g.setColor(Color.black);
            g.fill((Shape)left);
            g.draw((Shape)left);
            Polygon right = new Polygon();
            right.addPoint(centerBase.x, centerBase.y);
            right.addPoint(tip.x, tip.y);
            right.addPoint(bottomRight.x, bottomRight.y);
            g.setColor(Color.white);
            g.fill((Shape)right);
            g.setColor(Color.black);
            g.draw((Shape)right);
            g.setColor(Color.BLACK);
            g.drawString("N", arrowCenterX - 5, nTop, -1, 0);
        }
        finally {
            g.setTransform(t);
        }
    }

    private void drawSimpleLine(MapGraphicContext context) {
        context.getGraphics().setColor(new Color(255, 0, 0));
        context.getGraphics().drawLine(this.start.x, this.start.y, this.end.x, this.end.y);
    }

    private Coordinate walk(Coordinate ground, double theta, double d) {
        double dx = Math.cos(theta) * d;
        double dy = Math.sin(theta) * d;
        return new Coordinate(ground.x + dx, ground.y + dy);
    }

    private double theta(Coordinate ground, Coordinate north) {
        return Math.atan2(Math.abs(north.y - ground.y), Math.abs(north.x - ground.x));
    }

    private Coordinate moveNorth(Coordinate ground) {
        double up = ground.y + 0.1;
        if (up > 90.0) {
            return new Coordinate(ground.x, 90.0);
        }
        return new Coordinate(ground.x, up);
    }

    private Coordinate moveNorth(Coordinate ground, Double distance) {
        double up = ground.y + distance;
        if (ground.y < 90.0) {
            return new Coordinate(ground.x, up);
        }
        return null;
    }

    private Coordinate toGround(MapGraphicContext context, Coordinate there) {
        if (GROUND.equals(context.getCRS())) {
            return there;
        }
        try {
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)context.getCRS(), (CoordinateReferenceSystem)GROUND);
            return JTS.transform((Coordinate)there, null, (MathTransform)transform);
        }
        catch (FactoryException e) {
            e.printStackTrace();
            return null;
        }
        catch (TransformException transformException) {
            return null;
        }
    }

    private Coordinate fromGround(MapGraphicContext context, Coordinate ground) {
        if (GROUND.equals(context.getCRS())) {
            return ground;
        }
        try {
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)GROUND, (CoordinateReferenceSystem)context.getCRS());
            return JTS.transform((Coordinate)ground, null, (MathTransform)transform);
        }
        catch (FactoryException factoryException) {
            return null;
        }
        catch (TransformException transformException) {
            return null;
        }
    }

    private Point start(MapGraphicContext context) {
        Point point = null;
        IStyleBlackboard style = context.getLayer().getStyleBlackboard();
        try {
            point = (Point)style.get("net.refractions.udig.tool.northarrow-style");
        }
        catch (Exception evil) {
            evil.printStackTrace();
        }
        if (point == null) {
            point = new Point(25, 25);
            style.put("net.refractions.udig.tool.northarrow-style", (Object)point);
        }
        return point;
    }
}

