/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.mapgraphic.internal;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceInfo;
import net.refractions.udig.catalog.ITransientResolve;
import net.refractions.udig.core.internal.CorePlugin;
import net.refractions.udig.mapgraphic.MapGraphicFactory;
import net.refractions.udig.mapgraphic.internal.MapGraphicResource;
import net.refractions.udig.mapgraphic.internal.Messages;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class MapGraphicService
extends IService {
    public static String ID;
    public static final URL SERVICE_URL;
    public static final ID SERVICE_ID;
    private volatile List<MapGraphicResource> members;

    static {
        URL tmp;
        ID = "mapgraphic:///localhost/mapgraphic";
        try {
            tmp = new URL(null, ID, CorePlugin.RELAXED_HANDLER);
        }
        catch (MalformedURLException e) {
            tmp = null;
            e.printStackTrace();
        }
        SERVICE_URL = tmp;
        SERVICE_ID = new ID(SERVICE_URL);
    }

    MapGraphicService() {
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (adaptee == null) {
            throw new NullPointerException("No adaptor specified");
        }
        if (adaptee.isAssignableFrom(MapGraphicFactory.class)) {
            return adaptee.cast(MapGraphicFactory.getInstance());
        }
        if (adaptee.isAssignableFrom(ITransientResolve.class)) {
            return adaptee.cast((Object)this);
        }
        return (T)super.resolve(adaptee, monitor);
    }

    public MapGraphicServiceInfo getInfo(IProgressMonitor monitor) throws IOException {
        return (MapGraphicServiceInfo)super.getInfo(monitor);
    }

    protected synchronized MapGraphicServiceInfo createInfo(IProgressMonitor monitor) throws IOException {
        return new MapGraphicServiceInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MapGraphicResource> resources(IProgressMonitor monitor) throws IOException {
        if (this.members == null) {
            MapGraphicFactory mapGraphicFactory = MapGraphicFactory.getInstance();
            synchronized (mapGraphicFactory) {
                if (this.members == null) {
                    this.members = new ArrayList<MapGraphicResource>();
                    List<IConfigurationElement> graphics = MapGraphicFactory.getInstance().getMapGraphics();
                    if (graphics != null) {
                        for (IConfigurationElement graphic : graphics) {
                            this.members.add(new MapGraphicResource(this, graphic));
                        }
                    }
                }
            }
        }
        return this.members;
    }

    public Map<String, Serializable> getConnectionParams() {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("graphic", SERVICE_URL);
        return params;
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        return adaptee != null && (adaptee.isAssignableFrom(MapGraphicFactory.class) || adaptee.isAssignableFrom(ITransientResolve.class) || super.canResolve(adaptee));
    }

    public IResolve.Status getStatus() {
        return IResolve.Status.CONNECTED;
    }

    public void dispose(IProgressMonitor monitor) {
    }

    public Throwable getMessage() {
        return null;
    }

    public URL getIdentifier() {
        return SERVICE_URL;
    }

    static class MapGraphicServiceInfo
    extends IServiceInfo {
        MapGraphicServiceInfo() {
        }

        public String getTitle() {
            return Messages.MapGraphicService_title;
        }

        public String getDescription() {
            return Messages.MapGraphicService_description;
        }
    }
}

