/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.mapgraphic.internal;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.refractions.udig.mapgraphic.MapGraphic;
import net.refractions.udig.mapgraphic.MapGraphicPlugin;
import net.refractions.udig.mapgraphic.internal.MapGraphicContextImpl;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.internal.render.impl.RendererImpl;
import net.refractions.udig.project.render.ICompositeRenderContext;
import net.refractions.udig.project.render.IMultiLayerRenderer;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.RenderException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class MapGraphicRenderer
extends RendererImpl
implements IMultiLayerRenderer {
    public static final String BLACKBOARD_IMAGE_KEY = "CACHED_IMAGE";
    public static final String BLACKBOARD_IMAGE_BOUNDS_KEY = "CACHED_IMAGE_BOUNDS";
    Job refreshJob = new Job("RefreshJob"){

        protected IStatus run(IProgressMonitor monitor) {
            MapGraphicRenderer.this.getContext().clearImage();
            try {
                MapGraphicRenderer.this.render(monitor);
            }
            catch (Throwable e) {
                MapGraphicPlugin.log(null, e);
            }
            return Status.OK_STATUS;
        }
    };

    public String getName() {
        return super.getName();
    }

    private Object[] backgroundRenderImage(ICompositeRenderContext context, List<IOException> exceptions) {
        BufferedImage cache = new BufferedImage(context.getMapDisplay().getWidth(), context.getMapDisplay().getHeight(), 2);
        ReferencedEnvelope imageBounds = context.getViewportModel().getBounds();
        for (IRenderContext l : context.getContexts()) {
            block8: {
                Graphics2D copy;
                block6: {
                    copy = cache.createGraphics();
                    if (l.getLayer().isVisible()) break block6;
                    copy.dispose();
                    continue;
                }
                try {
                    try {
                        MapGraphic mg = (MapGraphic)l.getGeoResource().resolve(MapGraphic.class, null);
                        MapGraphicContextImpl mgContext = new MapGraphicContextImpl(l, copy);
                        mg.draw(mgContext);
                    }
                    catch (IOException e) {
                        exceptions.add(e);
                        copy.dispose();
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    copy.dispose();
                    throw throwable;
                }
                copy.dispose();
            }
            this.setState(2);
        }
        return new Object[]{cache, imageBounds};
    }

    public void render(Graphics2D destination, IProgressMonitor monitor) {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        for (IRenderContext l : this.getContext().getContexts()) {
            block9: {
                Graphics2D copy;
                block7: {
                    copy = (Graphics2D)destination.create();
                    if (l.getLayer().isVisible()) break block7;
                    copy.dispose();
                    continue;
                }
                try {
                    try {
                        MapGraphic mg = (MapGraphic)l.getGeoResource().resolve(MapGraphic.class, null);
                        MapGraphicContextImpl mgContext = new MapGraphicContextImpl(l, destination);
                        mg.draw(mgContext);
                    }
                    catch (IOException e) {
                        exceptions.add(e);
                        copy.dispose();
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    copy.dispose();
                    throw throwable;
                }
                copy.dispose();
            }
            this.setState(2);
        }
        if (!exceptions.isEmpty()) {
            RenderException exception = new RenderException(String.valueOf(exceptions.size()) + " exceptions we raised while drawing map graphics", (Throwable)exceptions.get(0));
            exception.fillInStackTrace();
        }
        this.setState(4);
    }

    public synchronized ICompositeRenderContext getContext() {
        return (ICompositeRenderContext)super.getContext();
    }

    public synchronized void setContext(IRenderContext newContext) {
        super.setContext(newContext);
    }

    public void render(IProgressMonitor monitor) {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        ILayer layer = this.context.getLayer();
        IBlackboard blackboard = layer.getBlackboard();
        BlackboardItem cached = (BlackboardItem)blackboard.get(BLACKBOARD_IMAGE_KEY);
        if (cached != null && !cached.layersEqual(this.getContext().getLayers())) {
            cached = null;
        }
        if (cached == null) {
            Object[] values = this.backgroundRenderImage(this.getContext(), exceptions);
            cached = new BlackboardItem((BufferedImage)values[0], (ReferencedEnvelope)values[1], this.getContext().getLayers());
            layer.getBlackboard().put(BLACKBOARD_IMAGE_KEY, (Object)cached);
        }
        BufferedImage cache = cached.image;
        ReferencedEnvelope imageBounds = cached.env;
        ReferencedEnvelope request = this.getContext().getImageBounds();
        double pixelperunitx = (double)cache.getWidth() / imageBounds.getWidth();
        double pixelperunity = (double)cache.getHeight() / imageBounds.getHeight();
        int lx = (int)Math.round((request.getMinX() - imageBounds.getMinX()) * pixelperunitx);
        int ly = (int)Math.round((request.getMaxY() - imageBounds.getMaxY()) * pixelperunity);
        AffineTransform transform = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -lx, ly);
        Graphics2D denstination = this.getContext().getImage().createGraphics();
        denstination.drawImage(cache, transform, null);
        if (!exceptions.isEmpty()) {
            RenderException exception = new RenderException(String.valueOf(exceptions.size()) + " exceptions we raised while drawing map graphics", (Throwable)exceptions.get(0));
            exception.fillInStackTrace();
        }
        this.setState(4);
    }

    public void refreshImage() throws RenderException {
        this.refreshJob.schedule();
    }

    public boolean isCacheable() {
        return false;
    }

    public void setState(int newState) {
        if (newState == 16) {
            this.getContext().getLayer().getBlackboard().put(BLACKBOARD_IMAGE_KEY, null);
        }
        super.setState(newState);
    }

    static class BlackboardItem {
        BufferedImage image;
        ReferencedEnvelope env;
        Collection<ILayer> layers;

        public BlackboardItem(BufferedImage image, ReferencedEnvelope env, Collection<ILayer> layers) {
            this.image = image;
            this.env = env;
            this.layers = layers;
        }

        public boolean layersEqual(Collection<ILayer> layers) {
            if (this.layers.size() != layers.size()) {
                return false;
            }
            for (ILayer layer : this.layers) {
                if (layers.contains(layer)) continue;
                return false;
            }
            return true;
        }
    }

    private static class NonDisposableGraphics
    extends Graphics2D {
        final Graphics2D graphics;

        public NonDisposableGraphics(Graphics2D graphics) {
            this.graphics = graphics;
        }

        @Override
        public void addRenderingHints(Map<?, ?> hints) {
            this.graphics.addRenderingHints(hints);
        }

        @Override
        public void clearRect(int x, int y, int width, int height) {
            this.graphics.clearRect(x, y, width, height);
        }

        @Override
        public void clip(Shape s) {
            this.graphics.clip(s);
        }

        @Override
        public void clipRect(int x, int y, int width, int height) {
            this.graphics.clipRect(x, y, width, height);
        }

        @Override
        public void copyArea(int x, int y, int width, int height, int dx, int dy) {
            this.graphics.copyArea(x, y, width, height, dx, dy);
        }

        @Override
        public Graphics create() {
            return this.graphics.create();
        }

        @Override
        public Graphics create(int x, int y, int width, int height) {
            return this.graphics.create(x, y, width, height);
        }

        @Override
        public void dispose() {
            this.graphics.dispose();
        }

        @Override
        public void draw(Shape s) {
            this.graphics.draw(s);
        }

        @Override
        public void draw3DRect(int x, int y, int width, int height, boolean raised) {
            this.graphics.draw3DRect(x, y, width, height, raised);
        }

        @Override
        public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
            this.graphics.drawArc(x, y, width, height, startAngle, arcAngle);
        }

        @Override
        public void drawBytes(byte[] data, int offset, int length, int x, int y) {
            this.graphics.drawBytes(data, offset, length, x, y);
        }

        @Override
        public void drawChars(char[] data, int offset, int length, int x, int y) {
            this.graphics.drawChars(data, offset, length, x, y);
        }

        @Override
        public void drawGlyphVector(GlyphVector g, float x, float y) {
            this.graphics.drawGlyphVector(g, x, y);
        }

        @Override
        public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
            this.graphics.drawImage(img, op, x, y);
        }

        @Override
        public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
            return this.graphics.drawImage(img, xform, obs);
        }

        @Override
        public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
            return this.graphics.drawImage(img, x, y, bgcolor, observer);
        }

        @Override
        public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
            return this.graphics.drawImage(img, x, y, observer);
        }

        @Override
        public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
            return this.graphics.drawImage(img, x, y, width, height, bgcolor, observer);
        }

        @Override
        public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
            return this.graphics.drawImage(img, x, y, width, height, observer);
        }

        @Override
        public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
            return this.graphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
        }

        @Override
        public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
            return this.graphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
        }

        @Override
        public void drawLine(int x1, int y1, int x2, int y2) {
            this.graphics.drawLine(x1, y1, x2, y2);
        }

        @Override
        public void drawOval(int x, int y, int width, int height) {
            this.graphics.drawOval(x, y, width, height);
        }

        @Override
        public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
            this.graphics.drawPolygon(xPoints, yPoints, nPoints);
        }

        @Override
        public void drawPolygon(Polygon p) {
            this.graphics.drawPolygon(p);
        }

        @Override
        public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
            this.graphics.drawPolyline(xPoints, yPoints, nPoints);
        }

        @Override
        public void drawRect(int x, int y, int width, int height) {
            this.graphics.drawRect(x, y, width, height);
        }

        @Override
        public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
            this.graphics.drawRenderableImage(img, xform);
        }

        @Override
        public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
            this.graphics.drawRenderedImage(img, xform);
        }

        @Override
        public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
            this.graphics.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
        }

        @Override
        public void drawString(AttributedCharacterIterator iterator, float x, float y) {
            this.graphics.drawString(iterator, x, y);
        }

        @Override
        public void drawString(AttributedCharacterIterator iterator, int x, int y) {
            this.graphics.drawString(iterator, x, y);
        }

        @Override
        public void drawString(String s, float x, float y) {
            this.graphics.drawString(s, x, y);
        }

        @Override
        public void drawString(String str, int x, int y) {
            this.graphics.drawString(str, x, y);
        }

        @Override
        public void fill(Shape s) {
            this.graphics.fill(s);
        }

        @Override
        public void fill3DRect(int x, int y, int width, int height, boolean raised) {
            this.graphics.fill3DRect(x, y, width, height, raised);
        }

        @Override
        public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
            this.graphics.fillArc(x, y, width, height, startAngle, arcAngle);
        }

        @Override
        public void fillOval(int x, int y, int width, int height) {
            this.graphics.fillOval(x, y, width, height);
        }

        @Override
        public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
            this.graphics.fillPolygon(xPoints, yPoints, nPoints);
        }

        @Override
        public void fillPolygon(Polygon p) {
            this.graphics.fillPolygon(p);
        }

        @Override
        public void fillRect(int x, int y, int width, int height) {
            this.graphics.fillRect(x, y, width, height);
        }

        @Override
        public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
            this.graphics.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
        }

        @Override
        public void finalize() {
            this.graphics.finalize();
        }

        @Override
        public Color getBackground() {
            return this.graphics.getBackground();
        }

        @Override
        public Shape getClip() {
            return this.graphics.getClip();
        }

        @Override
        public Rectangle getClipBounds() {
            return this.graphics.getClipBounds();
        }

        @Override
        public Rectangle getClipBounds(Rectangle r) {
            return this.graphics.getClipBounds(r);
        }

        @Override
        public Rectangle getClipRect() {
            return this.graphics.getClipBounds();
        }

        @Override
        public Color getColor() {
            return this.graphics.getColor();
        }

        @Override
        public Composite getComposite() {
            return this.graphics.getComposite();
        }

        @Override
        public GraphicsConfiguration getDeviceConfiguration() {
            return this.graphics.getDeviceConfiguration();
        }

        @Override
        public Font getFont() {
            return this.graphics.getFont();
        }

        @Override
        public FontMetrics getFontMetrics() {
            return this.graphics.getFontMetrics();
        }

        @Override
        public FontMetrics getFontMetrics(Font f) {
            return this.graphics.getFontMetrics(f);
        }

        @Override
        public FontRenderContext getFontRenderContext() {
            return this.graphics.getFontRenderContext();
        }

        @Override
        public Paint getPaint() {
            return this.graphics.getPaint();
        }

        @Override
        public Object getRenderingHint(RenderingHints.Key hintKey) {
            return this.graphics.getRenderingHint(hintKey);
        }

        @Override
        public RenderingHints getRenderingHints() {
            return this.graphics.getRenderingHints();
        }

        @Override
        public Stroke getStroke() {
            return this.graphics.getStroke();
        }

        @Override
        public AffineTransform getTransform() {
            return this.graphics.getTransform();
        }

        @Override
        public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
            return this.graphics.hit(rect, s, onStroke);
        }

        @Override
        public boolean hitClip(int x, int y, int width, int height) {
            return this.graphics.hitClip(x, y, width, height);
        }

        @Override
        public void rotate(double theta, double x, double y) {
            this.graphics.rotate(theta, x, y);
        }

        @Override
        public void rotate(double theta) {
            this.graphics.rotate(theta);
        }

        @Override
        public void scale(double sx, double sy) {
            this.graphics.scale(sx, sy);
        }

        @Override
        public void setBackground(Color color) {
            this.graphics.setBackground(color);
        }

        @Override
        public void setClip(int x, int y, int width, int height) {
            this.graphics.setClip(x, y, width, height);
        }

        @Override
        public void setClip(Shape clip) {
            this.graphics.setClip(clip);
        }

        @Override
        public void setColor(Color c) {
            this.graphics.setColor(c);
        }

        @Override
        public void setComposite(Composite comp) {
            this.graphics.setComposite(comp);
        }

        @Override
        public void setFont(Font font) {
            this.graphics.setFont(font);
        }

        @Override
        public void setPaint(Paint paint) {
            this.graphics.setPaint(paint);
        }

        @Override
        public void setPaintMode() {
            this.graphics.setPaintMode();
        }

        @Override
        public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
            this.graphics.setRenderingHint(hintKey, hintValue);
        }

        @Override
        public void setRenderingHints(Map<?, ?> hints) {
            this.graphics.setRenderingHints(hints);
        }

        @Override
        public void setStroke(Stroke s) {
            this.graphics.setStroke(s);
        }

        @Override
        public void setTransform(AffineTransform Tx) {
            this.graphics.setTransform(Tx);
        }

        @Override
        public void setXORMode(Color c1) {
            this.graphics.setXORMode(c1);
        }

        @Override
        public void shear(double shx, double shy) {
            this.graphics.shear(shx, shy);
        }

        @Override
        public String toString() {
            return this.graphics.toString();
        }

        @Override
        public void transform(AffineTransform Tx) {
            this.graphics.transform(Tx);
        }

        @Override
        public void translate(double tx, double ty) {
            this.graphics.translate(tx, ty);
        }

        @Override
        public void translate(int x, int y) {
            this.graphics.translate(x, y);
        }
    }
}

