/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.mapgraphic.internal;

import java.awt.Graphics2D;
import net.refractions.udig.mapgraphic.MapGraphicContext;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.render.RenderManager;
import net.refractions.udig.project.internal.render.impl.RenderContextImpl;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.IViewportModelListener;
import net.refractions.udig.project.render.ViewportModelEvent;
import net.refractions.udig.ui.graphics.AWTGraphics;
import net.refractions.udig.ui.graphics.ViewportGraphics;

public class MapGraphicContextImpl
extends RenderContextImpl
implements MapGraphicContext {
    private static final String BLACKBOARD_LAYER_KEY = "HAS_LISTENER";
    private ViewportGraphics vpg;

    public MapGraphicContextImpl(final IRenderContext context, Graphics2D destination) {
        this.setGeoResourceInternal(context.getGeoResource());
        this.setLayerInternal((Layer)context.getLayer());
        this.setRenderManagerInternal((RenderManager)context.getRenderManager());
        this.setMapInternal((Map)context.getMap());
        this.vpg = new AWTGraphics(destination, context.getMapDisplay().getDPI());
        IViewportModelListener listener = (IViewportModelListener)context.getLayer().getBlackboard().get(BLACKBOARD_LAYER_KEY);
        if (listener == null) {
            listener = new IViewportModelListener(){

                public void changed(ViewportModelEvent event) {
                    if (!context.getMap().getViewportModel().isBoundsChanging()) {
                        context.getLayer().getBlackboard().put("CACHED_IMAGE", null);
                        context.getLayer().refresh(null);
                    }
                }
            };
            context.getViewportModel().addViewportModelListener(listener);
            context.getLayer().getBlackboard().put(BLACKBOARD_LAYER_KEY, (Object)listener);
        }
    }

    @Override
    public ViewportGraphics getGraphics() {
        return this.vpg;
    }

    public void dispose() {
        IViewportModelListener listener = (IViewportModelListener)this.getLayer().getBlackboard().get(BLACKBOARD_LAYER_KEY);
        if (listener != null) {
            this.getViewportModel().removeViewportModelListener(listener);
            this.getLayer().getBlackboard().put(BLACKBOARD_LAYER_KEY, null);
        }
        super.dispose();
    }
}

