/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.mapgraphic.grid;

import net.refractions.udig.mapgraphic.grid.GridStyleConfigurator;
import net.refractions.udig.mapgraphic.grid.SpacerController;
import net.refractions.udig.mapgraphic.internal.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

public class UnitListener
implements ModifyListener {
    private Label message;
    private SpacerController otherSpacer;
    private SpacerController thisSpacer;

    public UnitListener(SpacerController otherSpacer, SpacerController thisSpacer, Label message) {
        this.otherSpacer = otherSpacer;
        this.message = message;
        this.thisSpacer = thisSpacer;
    }

    public void modifyText(ModifyEvent e) {
        if (this.thisSpacer.isPixelsSelected()) {
            if (this.thisSpacer.validatePixels(this.otherSpacer)) {
                this.warningMessage();
            } else {
                this.message.setText("");
            }
        } else if (this.thisSpacer.validateWorld(this.otherSpacer)) {
            this.warningMessage();
        } else {
            this.message.setText("");
        }
        this.thisSpacer.setSpinnerProperties();
        this.converSpinnerValueToNewUnit();
    }

    private void warningMessage() {
        this.message.setText(Messages.UnitListener_MixedUnits);
    }

    private void converSpinnerValueToNewUnit() {
        String oldValue = (String)this.thisSpacer.getUnit().getData();
        if (GridStyleConfigurator.selectedString(this.thisSpacer.getUnit()).equals("pixels")) {
            this.convertSpinner(oldValue, 1.0, 1.0, 1.0, 0);
        } else if (GridStyleConfigurator.selectedString(this.thisSpacer.getUnit()).equals("minutes")) {
            this.convertSpinner(oldValue, 60.0, 1.0, 0.016666666666666666, 4);
        } else if (GridStyleConfigurator.selectedString(this.thisSpacer.getUnit()).equals("seconds")) {
            this.convertSpinner(oldValue, 3600.0, 60.0, 1.0, 2);
        } else if (GridStyleConfigurator.selectedString(this.thisSpacer.getUnit()).equals("degrees")) {
            this.convertSpinner(oldValue, 1.0, 0.016666666666666666, 2.777777777777778E-4, 6);
        }
        this.thisSpacer.getUnit().setData((Object)GridStyleConfigurator.selectedString(this.thisSpacer.getUnit()));
    }

    void convertSpinner(String oldUnit, double fromDegree, double fromMinute, double fromSeconds, int digits) {
        Spinner spinner = this.thisSpacer.getSpinner();
        double selection = spinner.getSelection();
        if (oldUnit == null) {
            oldUnit = "pixels";
        }
        if (oldUnit.equals("degrees")) {
            double power = SpacerController.spinnerUnit(digits - 6);
            int newValue = (int)(selection * power * fromDegree);
            spinner.setSelection(newValue);
        } else if (oldUnit.equals("seconds")) {
            double power = SpacerController.spinnerUnit(digits - 2);
            int newValue = (int)(selection * power * fromSeconds);
            spinner.setSelection(newValue);
        } else if (oldUnit.equals("minutes")) {
            double power = SpacerController.spinnerUnit(digits - 4);
            int newValue = (int)(selection * power * fromMinute);
            spinner.setSelection(newValue);
        } else if (oldUnit.equals("pixels")) {
            int power = (int)SpacerController.spinnerUnit(digits);
            if (selection > 360.0) {
                spinner.setSelection(25 * power);
            } else {
                spinner.setSelection((int)(selection * (double)power));
            }
        }
    }
}

