/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.mapgraphic.grid;

import net.refractions.udig.mapgraphic.grid.ColorListener;
import net.refractions.udig.mapgraphic.grid.GridMapGraphic;
import net.refractions.udig.mapgraphic.grid.GridStyle;
import net.refractions.udig.mapgraphic.grid.SpacerController;
import net.refractions.udig.mapgraphic.grid.UnitListener;
import net.refractions.udig.mapgraphic.internal.Messages;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.style.IStyleConfigurator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;

public class GridStyleConfigurator
extends IStyleConfigurator
implements Listener {
    private static final String LINE_DASH = "dash";
    private static final String LINE_DASHDOT = "dash-dot";
    private static final String LINE_DASHDOTDOT = "dash-dot-dot";
    private static final String LINE_DOT = "dot";
    private static final String LINE_SOLID = "solid";
    private static final String[] LINE_STYLES = new String[]{"solid", "dash", "dot", "dash-dot", "dash-dot-dot"};
    SpacerController xSpacer;
    SpacerController ySpacer;
    Combo lineStyle;
    Spinner lineWidth;
    Button color;
    Label xlabel;
    Label ylabel;
    Label message;
    Label colorLabel;
    Label colorDisplay;
    Label lineStyleLabel;
    Label lineWidthLabel;
    private GridStyle style;
    private UnitListener xUnitListener;
    private UnitListener yUnitListener;
    private ColorListener colorListener;
    private Composite comp;

    public boolean canStyle(Layer aLayer) {
        return aLayer.hasResource(GridMapGraphic.class) && aLayer.getStyleBlackboard().get("net.refractions.udig.tool.edit.mapgraphic.grid.style") != null;
    }

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Composite comp = this.createWidgets(parent);
        this.addListeners();
        this.layoutWidgets(comp);
    }

    private void layoutWidgets(Composite comp) {
        comp.setLayout((Layout)new GridLayout(3, false));
        GridData layoutData = new GridData(4, 4, true, false, 3, 1);
        layoutData = new GridData(4, 4, false, false, 1, 1);
        this.xlabel.setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 4, true, false, 1, 1);
        this.xSpacer.getSpinner().setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 4, false, false, 1, 1);
        this.xSpacer.getUnit().setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 4, false, false, 1, 1);
        this.ylabel.setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 4, true, false, 1, 1);
        this.ySpacer.getSpinner().setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 4, false, false, 1, 1);
        this.ySpacer.getUnit().setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 4, false, false, 2, 1);
        this.lineStyleLabel.setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 4, true, false, 1, 1);
        this.lineStyle.setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 4, false, false, 2, 1);
        this.lineWidthLabel.setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 4, true, false, 1, 1);
        this.lineWidth.setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 4, false, false, 1, 1);
        this.colorLabel.setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 4, false, false, 1, 1);
        this.colorDisplay.setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 4, true, false, 1, 1);
        this.color.setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 4, true, true, 3, 1);
        this.message.setLayoutData((Object)layoutData);
    }

    private void addListeners() {
        if (this.xUnitListener == null) {
            this.xUnitListener = new UnitListener(this.ySpacer, this.xSpacer, this.message);
            this.yUnitListener = new UnitListener(this.xSpacer, this.ySpacer, this.message);
        }
        this.xSpacer.addListeners(this.xUnitListener, this);
        this.ySpacer.addListeners(this.yUnitListener, this);
        this.colorListener = new ColorListener(this);
        this.color.addSelectionListener((SelectionListener)this.colorListener);
        this.lineStyle.addListener(24, (Listener)this);
        this.lineStyle.addListener(2, (Listener)this);
        this.lineWidth.addListener(24, (Listener)this);
        this.lineWidth.addListener(2, (Listener)this);
    }

    private void removeListeners() {
        this.xSpacer.removeListeners(this.xUnitListener, this);
        this.ySpacer.removeListeners(this.yUnitListener, this);
        this.color.removeSelectionListener((SelectionListener)this.colorListener);
        this.lineStyle.removeListener(24, (Listener)this);
        this.lineWidth.removeListener(24, (Listener)this);
        this.lineStyle.removeListener(2, (Listener)this);
        this.lineWidth.removeListener(2, (Listener)this);
    }

    private Composite createWidgets(Composite parent) {
        this.comp = new Composite(parent, 0);
        this.xlabel = new Label(this.comp, 0);
        this.xlabel.setText(Messages.GridStyleConfigurator_HSpacing);
        Spinner x = new Spinner(this.comp, 0);
        Combo xUnit = new Combo(this.comp, 8);
        this.xSpacer = new SpacerController(x, xUnit);
        this.ylabel = new Label(this.comp, 0);
        this.ylabel.setText(Messages.GridStyleConfigurator_VSpacing);
        Spinner y = new Spinner(this.comp, 0);
        Combo yUnit = new Combo(this.comp, 8);
        this.ySpacer = new SpacerController(y, yUnit);
        this.colorLabel = new Label(this.comp, 0);
        this.colorLabel.setText(Messages.GridStyleConfigurator_LineColor);
        this.colorDisplay = new Label(this.comp, 0);
        this.colorDisplay.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                GridStyleConfigurator.this.updateColorButton();
            }
        });
        this.color = new Button(this.comp, 8);
        this.color.setText(Messages.GridStyleConfigurator_ChangeColor);
        this.lineStyleLabel = new Label(this.comp, 0);
        this.lineStyleLabel.setText(Messages.GridStyleConfigurator_LineStyle);
        this.lineStyle = new Combo(this.comp, 0);
        this.lineStyle.setItems(LINE_STYLES);
        this.lineStyle.select(0);
        this.lineWidthLabel = new Label(this.comp, 0);
        this.lineWidthLabel.setText(Messages.GridStyleConfigurator_LineWidth);
        this.lineWidth = new Spinner(this.comp, 0);
        this.lineWidth.setIncrement(1);
        this.lineWidth.setDigits(0);
        this.lineWidth.setMinimum(1);
        this.message = new Label(this.comp, 64);
        return this.comp;
    }

    protected void refresh() {
        this.getApplyAction().setEnabled(false);
        this.removeListeners();
        try {
            GridStyle oldStyle = (GridStyle)this.getStyleBlackboard().get("net.refractions.udig.tool.edit.mapgraphic.grid.style");
            if (oldStyle == null) {
                oldStyle = GridStyle.DEFAULT_STYLE;
            }
            this.style = new GridStyle(oldStyle);
            this.message.setText("");
            this.lineWidth.setSelection(this.style.getLineWidth());
            this.setLineStyle(this.style);
            java.awt.Color color2 = this.style.getColor();
            this.color.setData((Object)color2);
            this.updateColorButton();
            switch (this.style.getType()) {
                case SCREEN: {
                    this.xSpacer.setPixelSpacing(this.style.getGridSize()[0]);
                    this.ySpacer.setPixelSpacing(this.style.getGridSize()[1]);
                    break;
                }
                case WORLD: {
                    this.xSpacer.setWorldSpacing(this.style.getGridSize()[0]);
                    this.ySpacer.setWorldSpacing(this.style.getGridSize()[1]);
                    break;
                }
                default: {
                    throw new RuntimeException(Messages.bind((String)Messages.GridStyleConfigurator_0, (Object)((Object)this.style.getType())));
                }
            }
            this.xSpacer.getUnit().setData((Object)GridStyleConfigurator.selectedString(this.xSpacer.getUnit()));
            this.ySpacer.getUnit().setData((Object)GridStyleConfigurator.selectedString(this.ySpacer.getUnit()));
        }
        finally {
            this.addListeners();
        }
    }

    private void setLineStyle(GridStyle style2) {
        switch (this.style.getLineStyle()) {
            case 2: {
                this.lineStyle.select(this.lineStyle.indexOf(LINE_DASH));
                break;
            }
            case 4: {
                this.lineStyle.select(this.lineStyle.indexOf(LINE_DASHDOT));
                break;
            }
            case 5: {
                this.lineStyle.select(this.lineStyle.indexOf(LINE_DASHDOTDOT));
                break;
            }
            case 3: {
                this.lineStyle.select(this.lineStyle.indexOf(LINE_DOT));
                break;
            }
            case 1: {
                this.lineStyle.select(this.lineStyle.indexOf(LINE_SOLID));
                break;
            }
            default: {
                throw new RuntimeException(Messages.bind((String)Messages.GridStyleConfigurator_1, (Object)this.style.getLineStyle()));
            }
        }
    }

    void updateColorButton() {
        Image oldImage = this.colorDisplay.getImage();
        Rectangle bounds = this.colorDisplay.getBounds();
        if (bounds.width == 0 || bounds.height == 0) {
            return;
        }
        Display display = this.colorDisplay.getDisplay();
        Image newImage = new Image((Device)display, bounds.width, bounds.width);
        java.awt.Color awtColor = (java.awt.Color)this.color.getData();
        int red = awtColor.getRed();
        int green = awtColor.getGreen();
        int blue = awtColor.getBlue();
        Color color2 = new Color((Device)display, red, green, blue);
        GC gc = new GC((Drawable)newImage);
        try {
            gc.setForeground(display.getSystemColor(2));
            gc.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
            int alpha = awtColor.getAlpha();
            gc.setAlpha(alpha);
            gc.setBackground(color2);
            gc.fillRectangle(1, 1, bounds.width - 2, bounds.height - 2);
        }
        finally {
            gc.dispose();
            color2.dispose();
        }
        this.colorDisplay.setImage(newImage);
        if (oldImage != null) {
            oldImage.dispose();
        }
        this.colorLabel.redraw();
    }

    public void preApply() {
        if (this.xSpacer.getSpinner().isFocusControl()) {
            this.kickWidget((Control)this.xSpacer.getSpinner());
        } else if (this.ySpacer.getSpinner().isFocusControl()) {
            this.kickWidget((Control)this.ySpacer.getSpinner());
        } else if (this.lineWidth.isFocusControl()) {
            this.kickWidget((Control)this.lineWidth);
        } else if (this.lineStyle.isFocusControl()) {
            this.kickWidget((Control)this.lineStyle);
        }
    }

    private void kickWidget(Control widget) {
        this.comp.setFocus();
        widget.setFocus();
        while (widget.getDisplay().readAndDispatch()) {
        }
    }

    public void handleEvent(Event e) {
        if (e.type == 2 && e.character == '\r') {
            this.makeActionDoStuff();
        } else {
            boolean changed = this.isChanged(e);
            if (!changed) {
                return;
            }
            this.getApplyAction().setEnabled(true);
            if (e.widget != this.xSpacer.getUnit() && e.widget != this.ySpacer.getUnit()) {
                this.message.setText("");
            }
            this.style.setColor((java.awt.Color)this.color.getData());
            this.style.setLineStyle(this.parseLineStyle());
            this.style.setLineWidth(this.lineWidth.getSelection());
            GridStyle.Type type = this.xSpacer.getUnit().getSelectionIndex() == 0 ? GridStyle.Type.SCREEN : GridStyle.Type.WORLD;
            this.style.setType(type);
            this.style.setGridSize(this.xSpacer.getSpacing(), this.ySpacer.getSpacing());
            this.getStyleBlackboard().put("net.refractions.udig.tool.edit.mapgraphic.grid.style", (Object)this.style);
        }
    }

    private boolean isChanged(Event e) {
        if (this.style.getLineStyle() != this.parseLineStyle()) {
            return true;
        }
        if (!this.style.getColor().equals(this.color.getData())) {
            return true;
        }
        if (this.style.getLineWidth() != this.lineWidth.getSelection()) {
            return true;
        }
        if (!this.xSpacer.getUnit().getData().equals(GridStyleConfigurator.selectedString(this.xSpacer.getUnit()))) {
            return true;
        }
        if (!this.ySpacer.getUnit().getData().equals(GridStyleConfigurator.selectedString(this.ySpacer.getUnit()))) {
            return true;
        }
        if (Math.abs(this.xSpacer.getSpacing() - this.style.getGridSize()[0]) > 1.0E-10) {
            return true;
        }
        if (Math.abs(this.ySpacer.getSpacing() - this.style.getGridSize()[1]) > 1.0E-10) {
            return true;
        }
        return e.widget == this.lineWidth || e.widget == this.xSpacer.getSpinner() || e.widget == this.ySpacer.getSpinner();
    }

    private int parseLineStyle() {
        String selectedString = GridStyleConfigurator.selectedString(this.lineStyle);
        if (selectedString.equals(LINE_SOLID)) {
            return 1;
        }
        if (selectedString.equals(LINE_DASH)) {
            return 2;
        }
        if (selectedString.equals(LINE_DOT)) {
            return 3;
        }
        if (selectedString.equals(LINE_DASHDOT)) {
            return 4;
        }
        if (selectedString.equals(LINE_DASHDOTDOT)) {
            return 5;
        }
        throw new IllegalArgumentException(Messages.bind((String)Messages.GridStyleConfigurator_2, (Object)selectedString));
    }

    static String selectedString(Combo item) {
        int selectionIndex = item.getSelectionIndex();
        return item.getItem(selectionIndex);
    }
}

