/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.mapgraphic.grid;

import java.awt.Color;

public class GridStyle {
    public static final String ID = "net.refractions.udig.tool.edit.mapgraphic.grid.style";
    public static final GridStyle DEFAULT_STYLE = new GridStyle(Type.SCREEN, 25.0, 25.0, new Color(0, 0, 255, 100), 3, 1);
    private double[] gridSize;
    private Type type;
    private Color color;
    private boolean centerGrid;
    private boolean showLabels;
    private int lineStyle;
    private int lineWidth;

    public GridStyle(Type type, double dx, double dy, Color color, int lineStyle, int lineWidth) {
        this.gridSize = new double[]{dx, dy};
        this.type = type;
        this.color = color;
        this.lineStyle = lineStyle;
        this.lineWidth = lineWidth;
        this.centerGrid = false;
        this.showLabels = false;
    }

    public GridStyle(GridStyle oldStyle) {
        this.gridSize = oldStyle.getGridSize();
        this.type = oldStyle.getType();
        this.color = oldStyle.getColor();
        this.lineStyle = oldStyle.getLineStyle();
        this.lineWidth = oldStyle.getLineWidth();
        this.centerGrid = oldStyle.isCenterGrid();
        this.showLabels = oldStyle.isShowLabels();
    }

    public double[] getGridSize() {
        return new double[]{this.gridSize[0], this.gridSize[1]};
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setGridSize(double dx, double dy) {
        this.gridSize[0] = dx;
        this.gridSize[1] = dy;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(int lineStyle) {
        this.lineStyle = lineStyle;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public boolean isCenterGrid() {
        return this.centerGrid;
    }

    public void setCenterGrid(boolean centerGrid) {
        this.centerGrid = centerGrid;
    }

    public boolean isShowLabels() {
        return this.showLabels;
    }

    public void setShowLabels(boolean showLabels) {
        this.showLabels = showLabels;
    }

    public static enum Type {
        SCREEN,
        WORLD;

    }
}

