/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.mapgraphic.graticule;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import net.refractions.udig.mapgraphic.MapGraphic;
import net.refractions.udig.mapgraphic.MapGraphicContext;
import net.refractions.udig.mapgraphic.MapGraphicPlugin;
import net.refractions.udig.mapgraphic.graticule.GraticuleCRSConfigurator;
import net.refractions.udig.mapgraphic.graticule.GraticuleStyle;
import net.refractions.udig.mapgraphic.internal.Messages;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.ui.graphics.ViewportGraphics;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.grid.Grids;
import org.geotools.referencing.CRS;
import org.geotools.resources.CRSUtilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class GraticuleGraphic
implements MapGraphic {
    private static final String DELIM = "-";
    private static final String EMPTY = "";
    private static final String GEOM = "element";
    private static final String FORMAT = "0000000";
    private static final int MAX_SCALE = 100000000;
    SimpleFeatureSource grid;
    NumberFormat cf = new DecimalFormat("0000000");

    @Override
    public void draw(MapGraphicContext context) {
        ILayer graticule = context.getLayer();
        GraticuleStyle style = GraticuleStyle.getStyle(graticule);
        if (graticule instanceof Layer) {
            if (style.isInitCRS()) {
                style.setInitCRS(false);
                GraticuleCRSConfigurator.apply((Layer)graticule, context.getCRS());
            } else if (this.mismatch(graticule, style)) {
                GraticuleCRSConfigurator.apply((Layer)graticule, style.getCRS());
            }
        }
        if (1.0E8 < context.getMap().getViewportModel().getScaleDenominator()) {
            graticule.setStatus(4);
            graticule.setStatusMessage(String.valueOf(Messages.GraticuleGraphic_Maximum_Scale) + 100000000);
            return;
        }
        Unit unit = CRSUtilities.getUnit((CoordinateSystem)graticule.getCRS().getCoordinateSystem());
        if (unit != null && !SI.METER.equals((Object)unit)) {
            graticule.setStatus(2);
            graticule.setStatusMessage(Messages.GraticuleGraphic_Illegal_CRS);
            return;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        graticule.setStatus(5);
        graticule.setStatusMessage(null);
        Display display = workbench.getDisplay();
        Font plain = GraticuleStyle.getFontStyle(context).getFont();
        Font bold = plain.deriveFont(1);
        ViewportGraphics g = context.getGraphics();
        g.setFont(bold);
        boolean isShowLabels = style.isShowLabels();
        ReferencedEnvelope bounds = context.getViewportModel().getBounds();
        try {
            double size = this.size(context, unit, 10);
            int sx = (int)(size / context.getViewportModel().getPixelSize().x);
            int sy = (int)(size / context.getViewportModel().getPixelSize().y);
            if (sx < 10 || sy < 10) {
                graticule.setStatus(2);
                graticule.setStatusMessage(Messages.GraticuleGraphic_Error_Too_Many_Squares);
                return;
            }
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)graticule.getCRS(), (CoordinateReferenceSystem)context.getCRS(), (boolean)false);
            bounds = bounds.transform(graticule.getCRS(), true);
            SimpleFeatureIterator it = this.squares(bounds, size);
            while (it.hasNext()) {
                int i = 0;
                Point current = null;
                ArrayList<Line> lines = new ArrayList<Line>(2);
                ArrayList<Label> labels = new ArrayList<Label>(2);
                Geometry geom = (Geometry)((SimpleFeature)it.next()).getDefaultGeometry();
                Coordinate[] coords = geom.getCoordinates();
                String tx = this.getLabel(coords[0].x, size, unit, style);
                String ty = this.getLabel(coords[2].y, size, unit, style);
                boolean vgap = this.isGap(tx, unit, style);
                boolean hgap = this.isGap(ty, unit, style);
                Coordinate[] coordinateArray = coords = JTS.transform((Geometry)geom, (MathTransform)transform).getCoordinates();
                int n = coords.length;
                int n2 = 0;
                while (n2 < n) {
                    Coordinate c = coordinateArray[n2];
                    switch (i) {
                        case 1: {
                            current = this.vert(display, g, sy, style.getLineWidth(), current, context.worldToPixel(c), isShowLabels & hgap, vgap, lines);
                            if (!(isShowLabels & hgap)) break;
                            labels.add(new Label(current, tx, vgap ? bold : plain));
                            current = context.worldToPixel(c);
                            break;
                        }
                        case 2: {
                            current = this.horz(display, g, sx, style.getLineWidth(), current, context.worldToPixel(c), isShowLabels & vgap, hgap, lines);
                            if (!(isShowLabels & vgap)) break;
                            labels.add(new Label(current, ty, hgap ? bold : plain));
                            current = context.worldToPixel(c);
                            break;
                        }
                        default: {
                            current = context.worldToPixel(c);
                        }
                    }
                    ++i;
                    ++n2;
                }
                for (Line line : lines) {
                    line.draw(g, style);
                }
                if (!style.isShowLabels()) continue;
                for (Label label : labels) {
                    label.draw(g, style);
                }
            }
        }
        catch (IOException ex) {
            MapGraphicPlugin.log(Messages.GraticuleGraphic_Error, ex);
        }
        catch (FactoryException ex) {
            MapGraphicPlugin.log(Messages.GraticuleGraphic_Error, ex);
        }
        catch (MismatchedDimensionException ex) {
            MapGraphicPlugin.log(Messages.GraticuleGraphic_Error, ex);
        }
        catch (TransformException ex) {
            MapGraphicPlugin.log(Messages.GraticuleGraphic_Error, ex);
        }
        graticule.setStatus(0);
    }

    private boolean mismatch(ILayer graticule, GraticuleStyle style) {
        try {
            String code = "EPSG:" + CRS.lookupEpsgCode((CoordinateReferenceSystem)graticule.getCRS(), (boolean)false);
            return !code.equals(style.getCRS());
        }
        catch (FactoryException ex) {
            MapGraphicPlugin.log(Messages.GraticuleGraphic_Error, ex);
            return true;
        }
    }

    private SimpleFeatureIterator squares(ReferencedEnvelope bounds, double size) throws IOException {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        BBOX filter = ff.bbox((Expression)ff.property(GEOM), (BoundingBox)bounds);
        bounds = this.align(bounds, size, 1.6);
        SimpleFeatureSource grid = Grids.createSquareGrid((ReferencedEnvelope)bounds, (double)size);
        return grid.getFeatures((Filter)filter).features();
    }

    private ReferencedEnvelope expand(ReferencedEnvelope bounds, double distance) {
        bounds = new ReferencedEnvelope(bounds);
        bounds.expandBy(distance);
        return bounds;
    }

    private ReferencedEnvelope align(ReferencedEnvelope bounds, double size, double expand) {
        bounds = this.expand(bounds, expand * size);
        double x = this.offset(bounds.getLowerCorner(), 0, size);
        double y = this.offset(bounds.getLowerCorner(), 1, size);
        bounds.translate(-x, -y);
        return bounds;
    }

    private double offset(DirectPosition point, int ordinate, double size) {
        return point.getOrdinate(ordinate) % size;
    }

    private double size(MapGraphicContext context, Unit<?> unit, int min) {
        double scale = context.getMap().getViewportModel().getScaleDenominator();
        if (scale < 100000.0) {
            return 1000.0;
        }
        if (scale < 1000000.0) {
            return 10000.0;
        }
        if (scale < 1.0E7) {
            return 100000.0;
        }
        if (scale < 1.0E8) {
            return 1000000.0;
        }
        return 1.0E8;
    }

    private boolean isGap(String coordinate, Unit<?> unit, GraticuleStyle style) {
        return Integer.valueOf(coordinate) % 10 == 0;
    }

    private String getLabel(double coordinate, double size, Unit<?> unit, GraticuleStyle style) {
        int digits = 2;
        int offset = Math.max(1, 3 - String.valueOf(Math.round(size / 1000.0)).length());
        return String.valueOf(Math.signum(coordinate) == -1.0 ? DELIM : EMPTY) + this.cf.format(Math.abs(coordinate)).substring(offset, offset + digits);
    }

    private Point offset(Point p1, Point p2, int offset) {
        int length;
        int segment = (int)p1.distance(p2);
        int k1 = length = segment / 2 + offset;
        int k2 = segment - length;
        int x = (k1 * p2.x + k2 * p1.x) / (k1 + k2);
        int y = (k1 * p2.y + k2 * p1.y) / (k1 + k2);
        return new Point(x, y);
    }

    private Point vert(Display display, ViewportGraphics g, int sy, int lw, Point current, Point next, boolean gap, boolean bold, List<Line> lines) {
        ArrayList<Path> paths = new ArrayList<Path>(2);
        Path path = new Path((Device)display);
        path.moveTo((float)current.x, (float)(current.y - (bold ? 2 * lw : lw)));
        if (gap) {
            int offset = Math.max(1, g.getFontHeight());
            Point p = this.offset(current, next, -offset);
            path.lineTo((float)p.x, (float)p.y);
            paths.add(path);
            path = new Path((Device)display);
            p = this.offset(current, next, offset);
            path.moveTo((float)p.x, (float)p.y);
        }
        path.lineTo((float)next.x, (float)(next.y + (bold ? 0 : lw)));
        paths.add(path);
        lines.add(new Line(paths, bold ? 2 * lw : lw));
        return gap ? this.offset(current, next, 0) : next;
    }

    private Point horz(Display display, ViewportGraphics g, int sx, int lw, Point current, Point next, boolean gap, boolean bold, List<Line> lines) {
        ArrayList<Path> paths = new ArrayList<Path>(2);
        Path path = new Path((Device)display);
        path.moveTo((float)current.x, (float)current.y);
        if (gap) {
            int offset = Math.max(1, g.getFontHeight());
            Point p = this.offset(current, next, -offset);
            path.lineTo((float)p.x, (float)p.y);
            paths.add(path);
            path = new Path((Device)display);
            p = this.offset(current, next, offset);
            path.moveTo((float)p.x, (float)p.y);
        }
        path.lineTo((float)(next.x - (bold ? 2 * lw : lw)), (float)next.y);
        paths.add(path);
        lines.add(new Line(paths, bold ? 2 * lw : lw));
        return gap ? this.offset(current, next, 0) : next;
    }

    private static class Label {
        Font font;
        String text;
        Point anchor;

        public Label(Point anchor, String text, Font font) {
            this.font = font;
            this.text = text;
            this.anchor = anchor;
        }

        public void draw(ViewportGraphics g, GraticuleStyle style) {
            Color old = g.getColor();
            g.setColor(style.getFontColor());
            g.setFont(this.font);
            g.drawString(this.text, this.anchor.x, this.anchor.y, 0, 0);
            g.setColor(old);
        }
    }

    private static class Line {
        int w;
        List<Path> paths;

        public Line(List<Path> paths, int w) {
            this.w = w;
            this.paths = paths;
        }

        public void draw(ViewportGraphics g, GraticuleStyle style) {
            g.setColor(style.getLineColor());
            g.setStroke(style.getLineStyle(), this.w);
            for (Path path : this.paths) {
                g.drawPath(path);
            }
        }
    }
}

