/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.netcdf;

import it.geosolutions.imageio.ndplugin.BaseImageReader;
import it.geosolutions.imageio.plugins.netcdf.BaseNetCDFImageReader;
import it.geosolutions.imageio.plugins.netcdf.NetCDFImageReader;
import it.geosolutions.imageio.plugins.netcdf.NetCDFUtilities;
import it.geosolutions.imageio.utilities.Utilities;
import java.io.IOException;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class NetCDFStreamMetadata
extends IIOMetadata {
    public static final String nativeMetadataFormatName = "it_geosolutions_imageio_plugins_netcdf_streamMetadata_1.0";
    private BaseImageReader reader;
    public static final String GLOBAL_ATTRIBUTES = "GlobalAttributes";

    public NetCDFStreamMetadata(BaseImageReader reader) {
        this.reader = reader;
    }

    protected Node createCommonNativeTree() {
        IIOMetadataNode root = new IIOMetadataNode(nativeMetadataFormatName);
        IIOMetadataNode node = new IIOMetadataNode(GLOBAL_ATTRIBUTES);
        if (this.reader instanceof NetCDFImageReader) {
            NetCDFImageReader directReader = (NetCDFImageReader)this.reader;
            BaseNetCDFImageReader innerReader = directReader.getInnerReader();
            int numAttributes = innerReader.getNumGlobalAttributes();
            try {
                for (int i = 0; i < numAttributes; ++i) {
                    NetCDFUtilities.KeyValuePair keyValuePair = innerReader.getGlobalAttribute(i);
                    String attributeName = keyValuePair.getKey();
                    String attributeValue = keyValuePair.getValue();
                    if (attributeName.contains("\\")) {
                        attributeName = Utilities.adjustAttributeName((String)attributeName);
                    }
                    node.setAttribute(attributeName, attributeValue);
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to parse attribute", e);
            }
            root.appendChild(node);
        }
        return root;
    }

    public Node getAsTree(String formatName) {
        if (nativeMetadataFormatName.equalsIgnoreCase(formatName)) {
            return this.createCommonNativeTree();
        }
        throw new IllegalArgumentException(formatName + " is not a supported format name");
    }

    public boolean isReadOnly() {
        return true;
    }

    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        throw new UnsupportedOperationException();
    }

    public void reset() {
    }
}

