/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.worldimage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.catalog.internal.worldimage.InMemoryCoverageLoader;
import net.refractions.udig.catalog.internal.worldimage.WorldImageInfo;
import net.refractions.udig.catalog.internal.worldimage.WorldImageServiceImpl;
import net.refractions.udig.catalog.rasterings.AbstractRasterGeoResource;
import net.refractions.udig.catalog.rasterings.AbstractRasterService;
import net.refractions.udig.catalog.rasterings.GridCoverageLoader;
import net.refractions.udig.catalog.worldimage.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.geotools.data.PrjFileReader;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WorldImageGeoResourceImpl
extends AbstractRasterGeoResource {
    private URL prjURL;
    private InMemoryCoverageLoader loader;

    public WorldImageGeoResourceImpl(WorldImageServiceImpl service, String name, URL prjURL) {
        super((AbstractRasterService)service, name);
        this.prjURL = prjURL;
        try {
            this.loader = new InMemoryCoverageLoader(this, this.fileName);
        }
        catch (IOException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
    }

    public WorldImageInfo getInfo(IProgressMonitor monitor) throws IOException {
        return (WorldImageInfo)super.getInfo(monitor);
    }

    protected WorldImageInfo createInfo(IProgressMonitor monitor) throws IOException {
        this.lock.lock();
        try {
            if (this.getStatus() == IResolve.Status.BROKEN) {
                return null;
            }
            CoordinateReferenceSystem crs = this.readCrs();
            WorldImageInfo worldImageInfo = new WorldImageInfo(this, crs);
            return worldImageInfo;
        }
        finally {
            this.lock.unlock();
        }
    }

    private PrjFileReader openPrjReader(URL prjURL) throws IOException, FactoryException {
        ReadableByteChannel rbc = null;
        try {
            if (prjURL != null) {
                rbc = this.getReadChannel(prjURL);
            }
        }
        catch (IOException e) {
            CatalogPlugin.getDefault().getLog().log((IStatus)new Status(2, "net.refractions.udig.catalog", 0, Messages.WorldImageGeoResourceImpl_PrjUnavailable, (Throwable)e));
        }
        if (rbc == null) {
            return null;
        }
        return new PrjFileReader(rbc);
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        if (GridCoverageLoader.class.isAssignableFrom(adaptee)) {
            return true;
        }
        return super.canResolve(adaptee);
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (GridCoverageLoader.class.isAssignableFrom(adaptee)) {
            return adaptee.cast((Object)this.loader);
        }
        return (T)super.resolve(adaptee, monitor);
    }

    private ReadableByteChannel getReadChannel(URL prjURL) throws IOException {
        ReadableByteChannel channel = null;
        if (prjURL.getProtocol().equalsIgnoreCase("file")) {
            File file = URLUtils.urlToFile((URL)prjURL);
            if (!file.exists() || !file.canRead()) {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
            FileInputStream in = new FileInputStream(file);
            channel = in.getChannel();
        } else {
            InputStream in = prjURL.openConnection().getInputStream();
            channel = Channels.newChannel(in);
        }
        return channel;
    }

    public ParameterGroup getReadParameters() {
        try {
            CoordinateReferenceSystem crsSys = this.readCrs();
            DefaultParameterDescriptor crs = new DefaultParameterDescriptor("crs", CoordinateReferenceSystem.class, null, (Object)crsSys);
            DefaultParameterDescriptor gridGeometryDescriptor = this.getWorldGridGeomDescriptor();
            HashMap<String, String> info1 = new HashMap<String, String>();
            info1.put("name", "WorldImage");
            info1.put("description", "A raster file accompanied by a spatial data file");
            info1.put("vendor", "Geotools");
            info1.put("docURL", "http://www.geotools.org/WorldImageReader+formats");
            info1.put("version", "1.0");
            return new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(info1, new GeneralParameterDescriptor[]{crs, gridGeometryDescriptor}));
        }
        catch (MalformedURLException e) {
            CatalogPlugin.getDefault().getLog().log((IStatus)new Status(2, "net.refractions.udig.catalog", 0, "", (Throwable)e));
            return super.getReadParameters();
        }
        catch (IOException e) {
            CatalogPlugin.getDefault().getLog().log((IStatus)new Status(2, "net.refractions.udig.catalog", 0, "", (Throwable)e));
            return super.getReadParameters();
        }
    }

    private CoordinateReferenceSystem readCrs() throws IOException {
        PrjFileReader prjRead = null;
        try {
            prjRead = this.openPrjReader(this.prjURL);
        }
        catch (FileNotFoundException e) {
            CatalogPlugin.getDefault().getLog().log((IStatus)new Status(2, "net.refractions.udig.catalog", 0, "", (Throwable)e));
        }
        catch (FactoryException e) {
            CatalogPlugin.getDefault().getLog().log((IStatus)new Status(2, "net.refractions.udig.catalog", 0, "", (Throwable)e));
        }
        Object crsSys = null;
        crsSys = prjRead != null ? prjRead.getCoordinateReferenceSystem() : DefaultEngineeringCRS.GENERIC_2D;
        return crsSys;
    }
}

