/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.geotools.data;

import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.core.jts.ReferencedEnvelopeCache;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.geotools.data.ResourceInfo;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FeatureSourceGeoResourceInfo
extends IGeoResourceInfo {
    private ResourceInfo info;

    public FeatureSourceGeoResourceInfo(ResourceInfo info) {
        this.info = info;
        this.bounds = ReferencedEnvelopeCache.getReferencedEnvelope((CoordinateReferenceSystem)info.getCRS());
        this.description = info.getDescription();
        this.keywords = info.getKeywords().toArray(new String[0]);
        this.name = info.getName();
        try {
            this.schema = info.getSchema();
        }
        catch (NullPointerException nullPointerException) {}
        this.title = info.getTitle();
        if (this.title != null) {
            this.title = this.title.replace('_', ' ');
        }
        this.icon = CatalogUIPlugin.getDefault().getImageDescriptor("obj16/feature_obj.gif");
    }

    public void refresh(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("refresh bounds", 100);
            this.bounds = this.info.getBounds();
        }
        finally {
            monitor.done();
        }
    }

    public ResourceInfo toResourceInfo() {
        return this.info;
    }

    public ResourceInfo getInfo() {
        return this.info;
    }
}

