/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.geotools.data;

import java.io.IOException;
import java.net.URL;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.geotools.data.DataStoreService;
import net.refractions.udig.catalog.geotools.data.FeatureSourceGeoResourceInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.geotools.data.DataStore;
import org.geotools.data.ResourceInfo;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.opengis.feature.type.Name;

public class FeatureSourceGeoResource
extends IGeoResource {
    protected Name name;
    private ID id;

    public FeatureSourceGeoResource(DataStoreService service, Name name) {
        this.service = service;
        this.name = name;
        this.id = new ID(service.getID(), name.getLocalPart());
    }

    public DataStoreService service(IProgressMonitor monitor) throws IOException {
        return (DataStoreService)this.service;
    }

    public SimpleFeatureSource toFeatureSource() throws IOException {
        DataStore dataStore = this.service(null).toDataAccess();
        return dataStore.getFeatureSource(this.name);
    }

    protected IGeoResourceInfo createInfo(IProgressMonitor monitor) throws IOException {
        SimpleFeatureSource featureSource = this.toFeatureSource();
        ResourceInfo gtInfo = featureSource.getInfo();
        return new FeatureSourceGeoResourceInfo(gtInfo);
    }

    public ID getID() {
        return this.id;
    }

    public URL getIdentifier() {
        return this.id.toURL();
    }

    public Throwable getMessage() {
        return null;
    }

    public IResolve.Status getStatus() {
        return null;
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isInstance((Object)this) || adaptee.isAssignableFrom(FeatureSourceGeoResourceInfo.class) || adaptee.isAssignableFrom(SimpleFeatureSource.class) || adaptee.isAssignableFrom(SimpleFeatureStore.class) || super.canResolve(adaptee);
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        SimpleFeatureSource fs;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (adaptee == null) {
            throw new NullPointerException("No adaptor specified");
        }
        if (adaptee.isInstance((Object)this)) {
            return adaptee.cast((Object)this);
        }
        if (adaptee.isAssignableFrom(FeatureSourceGeoResourceInfo.class)) {
            return adaptee.cast(this.createInfo(monitor));
        }
        if (adaptee.isAssignableFrom(SimpleFeatureStore.class) && (fs = this.toFeatureSource()) instanceof SimpleFeatureStore) {
            return adaptee.cast(fs);
        }
        if (adaptee.isAssignableFrom(SimpleFeatureSource.class)) {
            return adaptee.cast(this.toFeatureSource());
        }
        return (T)super.resolve(adaptee, monitor);
    }
}

