/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.geotools.data;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceExtension;
import net.refractions.udig.catalog.geotools.Activator;
import net.refractions.udig.catalog.geotools.data.DataStoreService;
import net.refractions.udig.catalog.geotools.data.GTFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DataUtilities;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.jdbc.JDBCDataStoreFactory;

public class DataStoreServiceExtension
extends IServiceExtension {
    public Map<String, Serializable> createParams(URL url) {
        return DataStoreServiceExtension.createDataAcessParameters(url);
    }

    public static Map<String, Serializable> createDataAcessParameters(URL url) {
        Iterator available = DataAccessFinder.getAvailableDataStores();
        while (available.hasNext()) {
            DataAccessFactory factory = (DataAccessFactory)available.next();
            try {
                Map<String, Serializable> params;
                if (!DataStoreServiceExtension.consider(factory, url) || (params = DataStoreServiceExtension.createConnectionParameters(url, factory)) == null || !factory.canProcess(params)) continue;
                return params;
            }
            catch (Throwable t) {
                if (!Activator.getDefault().isDebugging()) continue;
                Status warning = new Status(2, "net.refractions.udig.catalog.geotools", String.valueOf(factory.getDisplayName()) + " unable to process " + url, t);
                Activator.getDefault().getLog().log((IStatus)warning);
            }
        }
        return null;
    }

    public static DataAccessFactory findDataAcessFactory(Map<String, Serializable> params) {
        Iterator available = DataAccessFinder.getAvailableDataStores();
        while (available.hasNext()) {
            DataAccessFactory factory = (DataAccessFactory)available.next();
            if (params == null || !factory.canProcess(params)) continue;
            return factory;
        }
        return null;
    }

    static Map<String, Serializable> createConnectionParameters(URL url, DataAccessFactory factory) {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        DataAccessFactory.Param[] paramArray = factory.getParametersInfo();
        int n = paramArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataAccessFactory.Param param = paramArray[n2];
            if (param.required) {
                if (param.sample != null) {
                    params.put(param.key, (Serializable)param.sample);
                }
                if (URL.class.isAssignableFrom(param.type)) {
                    params.put(param.key, url);
                } else if (File.class.isAssignableFrom(param.type) && "file".equalsIgnoreCase(url.getProtocol())) {
                    File file = DataUtilities.urlToFile((URL)url);
                    params.put(param.key, file);
                } else if (param.sample != null) {
                    params.put(param.key, (Serializable)param.sample);
                }
            } else if (param.sample != null) {
                params.put(param.key, (Serializable)param.sample);
            }
            ++n2;
        }
        return params;
    }

    public static boolean consider(DataAccessFactory factory, URL url) {
        if (factory instanceof FileDataStoreFactorySpi) {
            FileDataStoreFactorySpi fileFactory = (FileDataStoreFactorySpi)factory;
            return fileFactory.canProcess(url);
        }
        DataAccessFactory.Param[] paramArray = factory.getParametersInfo();
        int n = paramArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataAccessFactory.Param param = paramArray[n2];
            if (param.required) {
                if (URL.class.isAssignableFrom(param.type)) {
                    return true;
                }
                if (File.class.isAssignableFrom(param.type)) {
                    return "file".equalsIgnoreCase(url.getProtocol());
                }
            }
            ++n2;
        }
        if (factory instanceof JDBCDataStoreFactory) {
            return "jdbc".equalsIgnoreCase(url.getProtocol());
        }
        return false;
    }

    public IService createService(URL providedId, Map<String, Serializable> params) {
        Iterator available = DataStoreFinder.getAvailableDataStores();
        while (available.hasNext()) {
            ID id;
            DataStoreFactorySpi factory = (DataStoreFactorySpi)available.next();
            if (!factory.canProcess(params) || (id = DataStoreServiceExtension.createID(providedId, (DataAccessFactory)factory, params)) == null) continue;
            return new DataStoreService(id, factory, params);
        }
        return null;
    }

    public static ID createID(URL providedId, DataAccessFactory factory, Map<String, Serializable> params) {
        if (providedId != null) {
            return new ID(providedId, factory.getDisplayName());
        }
        GTFormat format = GTFormat.format(factory);
        return format.toID(factory, params);
    }
}

