/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.geotools.data;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.geotools.data.DataStoreServiceInfo;
import net.refractions.udig.catalog.geotools.data.FeatureSourceGeoResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.ServiceInfo;
import org.opengis.feature.type.Name;

public class DataStoreService
extends IService {
    public static String GENERIC = "generic";
    private ID id;
    private Map<String, Serializable> connectionParams;
    private DataStore dataStore;
    private DataStoreFactorySpi factory;
    private IOException message;
    private List<FeatureSourceGeoResource> resources;

    public DataStoreService(ID id, DataStoreFactorySpi factory, Map<String, Serializable> params) {
        this.id = id;
        this.connectionParams = params;
        this.factory = factory;
    }

    public synchronized DataStore toDataAccess() throws IOException {
        if (this.dataStore == null) {
            try {
                this.dataStore = this.factory.createDataStore(this.connectionParams);
            }
            catch (IOException e) {
                this.message = e;
                throw e;
            }
        }
        return this.dataStore;
    }

    protected DataStoreServiceInfo createInfo(IProgressMonitor monitor) throws IOException {
        DataStore access = this.toDataAccess();
        ServiceInfo gtInfo = access.getInfo();
        return new DataStoreServiceInfo((DataAccessFactory)this.factory, this.connectionParams, gtInfo);
    }

    public Map<String, Serializable> getConnectionParams() {
        return this.connectionParams;
    }

    public synchronized List<FeatureSourceGeoResource> resources(IProgressMonitor monitor) throws IOException {
        if (this.resources == null) {
            DataStore access = this.toDataAccess();
            this.resources = new ArrayList<FeatureSourceGeoResource>();
            for (Name name : access.getNames()) {
                FeatureSourceGeoResource geoResource = new FeatureSourceGeoResource(this, name);
                this.resources.add(geoResource);
            }
        }
        return this.resources;
    }

    public URL getIdentifier() {
        return this.id.toURL();
    }

    public ID getID() {
        return this.id;
    }

    public Throwable getMessage() {
        return this.message;
    }

    public IResolve.Status getStatus() {
        if (this.dataStore == null) {
            return super.getStatus();
        }
        return IResolve.Status.CONNECTED;
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        return adaptee == null || DataAccess.class.isAssignableFrom(adaptee) || super.canResolve(adaptee);
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (adaptee == null) {
            throw new NullPointerException("No adaptor specified");
        }
        if (DataAccess.class.isAssignableFrom(adaptee)) {
            return adaptee.cast(this.toDataAccess());
        }
        return (T)super.resolve(adaptee, monitor);
    }

    public void dispose(IProgressMonitor monitor) {
        super.dispose(monitor);
        if (this.dataStore != null) {
            this.dataStore.dispose();
            this.dataStore = null;
        }
        if (this.resources != null) {
            this.resources = null;
        }
    }
}

