/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.geotools.data;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.miginfocom.swt.MigLayout;
import net.refractions.udig.catalog.geotools.Activator;
import net.refractions.udig.catalog.geotools.data.DataStoreConnectionPage;
import net.refractions.udig.catalog.ui.AbstractUDIGImportPage;
import net.refractions.udig.catalog.ui.UDIGConnectionPage;
import net.refractions.udig.catalog.ui.wizard.CatalogImportWizard;
import net.refractions.udig.catalog.ui.workflow.State;
import net.refractions.udig.catalog.ui.workflow.Workflow;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataUtilities;

public class DataStoreParameterPage
extends AbstractUDIGImportPage
implements UDIGConnectionPage {
    private DataAccessFactory paramFactory;
    private List<DataAccessFactory.Param> paramInfo = null;
    private Map<DataAccessFactory.Param, Text> fields = new HashMap<DataAccessFactory.Param, Text>();
    private KeyListener listener = new KeyListener(){

        public void keyReleased(KeyEvent e) {
            Text field = (Text)e.getSource();
            if (field.isDisposed()) {
                return;
            }
            DataAccessFactory.Param param = (DataAccessFactory.Param)field.getData();
            DataStoreParameterPage.this.sync(param, field);
            DataStoreParameterPage.this.getContainer().updateButtons();
        }

        public void keyPressed(KeyEvent e) {
        }
    };
    private Map<String, Serializable> connectionParameters;
    private TestConnection connect = new TestConnection();

    protected void sync(final DataAccessFactory.Param param, final Text field) {
        Display display = this.getControl().getDisplay();
        PlatformGIS.asyncInDisplayThread((Display)display, (Runnable)new Runnable(){

            @Override
            public void run() {
                block15: {
                    if (field.isDisposed()) {
                        return;
                    }
                    String text = field.getText();
                    if (text.length() == 0) {
                        DataStoreParameterPage.this.connectionParameters.remove(param.key);
                        if (param.sample != null) {
                            field.setToolTipText("Default: " + param.text(param.sample));
                            DataStoreParameterPage.this.setErrorMessage(null);
                        } else {
                            field.setToolTipText("Empty");
                            if (param.required && param.sample == null) {
                                DataStoreParameterPage.this.setErrorMessage(String.valueOf(param.key) + " is required");
                            } else {
                                DataStoreParameterPage.this.setErrorMessage(null);
                            }
                        }
                    } else {
                        Object value;
                        try {
                            value = param.parse(text);
                            DataStoreParameterPage.this.setErrorMessage(null);
                        }
                        catch (Throwable e) {
                            DataStoreParameterPage.this.setErrorMessage(e.getLocalizedMessage());
                            value = null;
                        }
                        if (value == null && param.required) {
                            field.setToolTipText("Required");
                            DataStoreParameterPage.this.connectionParameters.remove(param.key);
                        } else {
                            field.setToolTipText("Value: " + value);
                            if (value instanceof Serializable) {
                                DataStoreParameterPage.this.connectionParameters.put(param.key, (Serializable)value);
                            } else {
                                try {
                                    String txt = param.text(value);
                                    DataStoreParameterPage.this.connectionParameters.put(param.key, txt);
                                }
                                catch (Throwable t) {
                                    if (!Activator.getDefault().isDebugging()) break block15;
                                    System.out.println("net.refractions.udig.catalog.geotools could not write out " + param.key + " connection param:" + t);
                                    t.printStackTrace();
                                }
                            }
                        }
                    }
                }
            }
        }, (boolean)false);
    }

    public DataStoreParameterPage() {
        super("Parameters");
    }

    public Composite getControl() {
        return (Composite)super.getControl();
    }

    public CatalogImportWizard getWizard() {
        return (CatalogImportWizard)super.getWizard();
    }

    public DataStoreConnectionPage getPreviousPage() {
        return (DataStoreConnectionPage)super.getPreviousPage();
    }

    public void createControl(Composite parent) {
        State workflowState = this.getState();
        if (workflowState != null) {
            workflowState.getName();
            Workflow workflow = workflowState.getWorkflow();
            workflow.getContext();
        }
        this.getParams();
        this.getWizard();
        DataAccessFactory factory = this.getPreviousPage().getFactory();
        this.connectionParameters = this.getPreviousPage().getParams();
        this.getParams();
        if (this.connectionParameters == null) {
            this.connectionParameters = new HashMap<String, Serializable>();
            for (DataAccessFactory.Param param : this.getParameterInfo()) {
                if (!param.required) continue;
                this.connectionParameters.put(param.key, (Serializable)param.sample);
            }
        }
        this.setTitle(factory.getDisplayName());
        this.setDescription(factory.getDescription());
        this.setControl((Control)new Composite(parent, 0));
        this.getControl().setLayout((Layout)new MigLayout("", "[right,pref!]para[grow]rel[pref!]", ""));
        for (DataAccessFactory.Param param : this.getParameterInfo()) {
            if (!"user".equals(param.getLevel())) continue;
            Text field = this.addField(this.getControl(), param);
            this.fields.put(param, field);
        }
        Label seperator = new Label(this.getControl(), 258);
        seperator.setLayoutData((Object)"growx,span,wrap");
        Label advanced = new Label(this.getControl(), 16384);
        advanced.setLayoutData((Object)"growx,span,wrap");
        for (DataAccessFactory.Param param : this.getParameterInfo()) {
            if (!"advanced".equals(param.getLevel())) continue;
            Text field = this.addField(this.getControl(), param);
            this.fields.put(param, field);
        }
        this.listen(true);
    }

    private void listen(boolean listen) {
        if (listen) {
            for (Text field : this.fields.values()) {
                if (field.isDisposed()) continue;
                field.addKeyListener(this.listener);
            }
        } else {
            for (Text field : this.fields.values()) {
                if (field.isDisposed()) continue;
                field.removeKeyListener(this.listener);
            }
        }
    }

    public void dispose() {
        if (this.getControl() != null) {
            this.listen(false);
            this.fields.clear();
            this.fields = null;
        }
        this.paramFactory = null;
        if (this.paramInfo != null) {
            this.paramInfo.clear();
            this.paramInfo = null;
        }
        super.dispose();
    }

    protected Text addField(final Composite parent, final DataAccessFactory.Param param) {
        String text;
        Text field;
        Label label = new Label(parent, 131072);
        String name = param.title == null ? param.key : param.title.toString();
        String suffix = param.required ? "*:" : ":";
        label.setText(String.valueOf(name) + suffix);
        label.setToolTipText(param.description.toString());
        final String EXTENSION = param.metadata != null ? param.metadata.get("ext") : null;
        if (param.isPassword()) {
            field = new Text(parent, 0x400804);
            field.setLayoutData((Object)"span, growx, wrap unrelated");
        } else if (File.class.isAssignableFrom(param.type) || URL.class.isAssignableFrom(param.type)) {
            field = new Text(parent, 2052);
            field.setLayoutData((Object)"growx");
            Button button = new Button(parent, -1);
            button.setText("Browse");
            button.setLayoutData((Object)"wrap unrelated");
            final Text target = field;
            button.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    DataStoreParameterPage.this.getPathAndSynchWithText(EXTENSION, parent, target, param.type);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        } else {
            field = new Text(parent, 2052);
            field.setLayoutData((Object)"span, growx, wrap unrelated");
        }
        field.setData((Object)param);
        if ("dbtype".equals(param.key)) {
            field.setEditable(false);
        }
        Object value = null;
        if (this.getParams() != null && this.getParams().containsKey(param.key)) {
            value = this.getParams().get(param.key);
        }
        if (value == null) {
            value = param.getDefaultValue();
        }
        String string = text = value != null ? param.text(value) : "";
        if (value != null) {
            field.setText(text);
        }
        return field;
    }

    protected void getPathAndSynchWithText(String extension, Composite parent, Text target, Class targetClass) {
        FileDialog browse;
        String path = null;
        if (extension != null) {
            browse = new FileDialog(parent.getShell(), 4096);
            browse.setFilterExtensions(new String[]{this.wrapExtension(extension)});
            path = browse.open();
        } else {
            browse = new DirectoryDialog(parent.getShell(), 4096);
            path = browse.open();
        }
        if (path != null) {
            String text = null;
            if (File.class.isAssignableFrom(targetClass)) {
                text = path;
            } else if (URL.class.isAssignableFrom(targetClass)) {
                File file = new File(path);
                URL url = DataUtilities.fileToURL((File)file);
                text = url.toString();
            }
            if (text != null) {
                target.setText(text);
            }
            this.sync((DataAccessFactory.Param)target.getData(), target);
        }
    }

    protected String wrapExtension(String extension) {
        if (extension != null) {
            int index = extension.lastIndexOf(46);
            return "*." + (index >= 0 && extension.length() > index + 1 ? extension.substring(index + 1) : extension);
        }
        return null;
    }

    protected synchronized List<DataAccessFactory.Param> getParameterInfo() {
        if (this.paramFactory == this.getPreviousPage().getFactory()) {
            return this.paramInfo;
        }
        this.paramFactory = this.getPreviousPage().getFactory();
        DataAccessFactory.Param[] info = this.getPreviousPage().getFactory().getParametersInfo();
        this.paramInfo = Arrays.asList(info);
        return this.paramInfo;
    }

    public Map<String, Serializable> getParams() {
        return this.connectionParameters;
    }

    public boolean canFlipToNextPage() {
        return this.isParametersComplete(false);
    }

    public boolean leavingPage() {
        this.syncParameters();
        return true;
    }

    private void syncParameters() {
        for (Map.Entry<DataAccessFactory.Param, Text> field : this.fields.entrySet()) {
            DataAccessFactory.Param param = field.getKey();
            Text textField = field.getValue();
            this.sync(param, textField);
        }
    }

    protected boolean isParametersComplete(boolean testConnection) {
        DataAccessFactory factory = this.getPreviousPage().getFactory();
        this.connectionParameters = this.getParams();
        if (!factory.canProcess(this.connectionParameters)) {
            return false;
        }
        if (testConnection) {
            try {
                this.getWizard().getContainer().run(false, true, (IRunnableWithProgress)this.connect);
            }
            catch (InvocationTargetException e) {
                this.setErrorMessage(e.getCause().toString());
            }
            catch (InterruptedException interruptedException) {}
            return this.connect.isConnected();
        }
        return true;
    }

    private final class TestConnection
    implements IRunnableWithProgress {
        private boolean isConnected;

        private TestConnection() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this.isConnected = false;
            DataAccessFactory factory = DataStoreParameterPage.this.getPreviousPage().getFactory();
            DataStoreParameterPage.this.connectionParameters = DataStoreParameterPage.this.getParams();
            if (factory.canProcess(DataStoreParameterPage.this.connectionParameters)) {
                try {
                    factory.createDataStore(DataStoreParameterPage.this.connectionParameters);
                    this.isConnected = true;
                }
                catch (IOException e) {
                    DataStoreParameterPage.this.setErrorMessage(e.toString());
                }
            }
        }

        public boolean isConnected() {
            return this.isConnected;
        }
    }
}

