/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.geotools.data;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Map;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.geotools.Activator;
import net.refractions.udig.catalog.geotools.data.DataStoreServiceExtension;
import net.refractions.udig.catalog.ui.UDIGConnectionFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.geotools.data.DataUtilities;

public class DataStoreConnectionFactory
extends UDIGConnectionFactory {
    public Map<String, Serializable> createConnectionParameters(Object context) {
        block5: {
            try {
                if (context instanceof URL) {
                    URL url = (URL)context;
                    Map<String, Serializable> params = DataStoreServiceExtension.createDataAcessParameters(url);
                    return params;
                }
                if (context instanceof File) {
                    File file = (File)context;
                    URL url = DataUtilities.fileToURL((File)file);
                    Map<String, Serializable> params = DataStoreServiceExtension.createDataAcessParameters(url);
                    return params;
                }
                if (context instanceof IResolve) {
                    IResolve resolve = (IResolve)context;
                    ID id = resolve.getID();
                    URL url = id.toURL();
                    Map<String, Serializable> params = DataStoreServiceExtension.createDataAcessParameters(url);
                    return params;
                }
            }
            catch (Throwable t) {
                if (!Activator.getDefault().isDebugging()) break block5;
                Status status = new Status(2, "net.refractions.udig.catalog.geotools", "DataStoreConnection cannot process: " + context, t);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        return null;
    }

    public URL createConnectionURL(Object context) {
        block5: {
            try {
                if (context instanceof URL) {
                    URL url = (URL)context;
                    Map<String, Serializable> params = DataStoreServiceExtension.createDataAcessParameters(url);
                    return params != null ? url : null;
                }
                if (context instanceof File) {
                    File file = (File)context;
                    URL url = DataUtilities.fileToURL((File)file);
                    Map<String, Serializable> params = DataStoreServiceExtension.createDataAcessParameters(url);
                    return params != null ? url : null;
                }
                if (context instanceof IResolve) {
                    IResolve resolve = (IResolve)context;
                    ID id = resolve.getID();
                    URL url = id.toURL();
                    Map<String, Serializable> params = DataStoreServiceExtension.createDataAcessParameters(url);
                    return params != null ? url : null;
                }
            }
            catch (Throwable t) {
                if (!Activator.getDefault().isDebugging()) break block5;
                Status status = new Status(2, "net.refractions.udig.catalog.geotools", "DataStoreConnection cannot produce a url: " + context, t);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        return null;
    }
}

