/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.ww;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.ServiceExtension2;
import net.refractions.udig.catalog.internal.wmt.ww.WWService;
import net.refractions.udig.catalog.wmt.internal.Messages;

public class WWServiceExtension
implements ServiceExtension2 {
    public IService createService(URL id, Map<String, Serializable> params) {
        if (params == null) {
            return null;
        }
        if (!params.containsKey("net.refractions.udig.catalog.internal.wmt.WWService.WW_URL_KEY") && id == null && !params.containsKey("net.refractions.udig.catalog.internal.wmt.WWService.WW_LAYERSET_KEY")) {
            return null;
        }
        URL extractedId = this.extractId(params);
        if (extractedId != null) {
            if (id != null) {
                return new WWService(id, params);
            }
            return new WWService(extractedId, params);
        }
        return null;
    }

    private URL extractId(Map<String, Serializable> params) {
        if (params.containsKey("net.refractions.udig.catalog.internal.wmt.WWService.WW_URL_KEY")) {
            URL base = null;
            if (params.get("net.refractions.udig.catalog.internal.wmt.WWService.WW_URL_KEY") instanceof URL) {
                base = (URL)params.get("net.refractions.udig.catalog.internal.wmt.WWService.WW_URL_KEY");
            } else {
                try {
                    base = new URL((String)((Object)params.get("net.refractions.udig.catalog.internal.wmt.WWService.WW_URL_KEY")));
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                    return null;
                }
                params.remove(params.get("net.refractions.udig.catalog.internal.wmt.WWService.WW_URL_KEY"));
                params.put("net.refractions.udig.catalog.internal.wmt.WWService.WW_URL_KEY", base);
            }
            return base;
        }
        return null;
    }

    public Map<String, Serializable> createParams(URL url) {
        if (!WWServiceExtension.isWWConfigFile(url)) {
            return null;
        }
        HashMap<String, Serializable> params2 = new HashMap<String, Serializable>();
        params2.put("net.refractions.udig.catalog.internal.wmt.WWService.WW_URL_KEY", url);
        return params2;
    }

    public static boolean isWWConfigFile(URL url) {
        return WWServiceExtension.processURL(url) == null;
    }

    public String reasonForFailure(Map<String, Serializable> params) {
        URL id = this.extractId(params);
        if (id == null) {
            return String.valueOf(Messages.WWServiceExtension_NeedsKey) + "net.refractions.udig.catalog.internal.wmt.WWService.WW_URL_KEY" + Messages.WWServiceExtension_NullValue;
        }
        return this.reasonForFailure(id);
    }

    public String reasonForFailure(URL url) {
        return WWServiceExtension.processURL(url);
    }

    private static String processURL(URL url) {
        if (url == null) {
            return Messages.WWServiceExtension_NullURL;
        }
        String PROTOCOL = url.getProtocol();
        String PATH = url.getPath();
        if (PROTOCOL == null || PROTOCOL.isEmpty()) {
            return Messages.WWServiceExtension_Protocol;
        }
        if (PATH == null || PATH.isEmpty() || !PATH.toLowerCase().contains(".xml")) {
            return Messages.Wizard_WW_Error_InvalidURL;
        }
        return null;
    }
}

