/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.wmtsource.ww;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.catalog.internal.wmt.tile.WWTile;
import net.refractions.udig.catalog.internal.wmt.wmtsource.ww.QuadTileSet;
import net.refractions.udig.catalog.internal.wmt.wmtsource.ww.TileService;
import net.refractions.udig.project.internal.render.impl.ScaleUtils;
import org.eclipse.swt.widgets.Display;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.jdom.Element;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ImageAccessor {
    private double levelZeroTileSizeDegrees;
    private int numberLevels;
    private int tileSize;
    private String tileFormat;
    private List<WWTile.WWTileName.WWZoomLevel> zoomLevels;
    private double[] scales;
    private QuadTileSet quadTileSet;
    private TileService tileService;

    public ImageAccessor(Element xmlElement, QuadTileSet quadTileSet) throws Exception {
        this.quadTileSet = quadTileSet;
        this.levelZeroTileSizeDegrees = Double.parseDouble(xmlElement.getChildText("LevelZeroTileSizeDegrees"));
        this.numberLevels = Integer.parseInt(xmlElement.getChildText("NumberLevels"));
        this.tileSize = Integer.parseInt(xmlElement.getChildText("TextureSizePixels"));
        this.tileFormat = xmlElement.getChildText("ImageFileExtension");
        this.tileService = TileService.createTileService(xmlElement, this);
        this.setZoomLevels();
    }

    private void setZoomLevels() {
        ReferencedEnvelope bounds = this.quadTileSet.getBounds();
        this.zoomLevels = new ArrayList<WWTile.WWTileName.WWZoomLevel>(this.numberLevels);
        this.scales = new double[this.numberLevels];
        double tileSizeDegrees = this.levelZeroTileSizeDegrees;
        int i = 0;
        while (i < this.numberLevels) {
            WWTile.WWTileName.WWZoomLevel zoomLevel = new WWTile.WWTileName.WWZoomLevel(i, this.getBoundOfFirstTile(tileSizeDegrees, bounds), this.getScale(tileSizeDegrees), this);
            zoomLevel.setZoomLevel(i);
            this.zoomLevels.add(zoomLevel);
            this.scales[i] = zoomLevel.getScale();
            tileSizeDegrees /= 2.0;
            ++i;
        }
    }

    private ReferencedEnvelope getBoundOfFirstTile(double tileSizeDegrees, ReferencedEnvelope bounds) {
        return new ReferencedEnvelope(bounds.getMinX(), bounds.getMinX() + tileSizeDegrees, bounds.getMinY(), bounds.getMinY() + tileSizeDegrees, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    private double getScale(double tileSizeDegrees) {
        double halfWidth = tileSizeDegrees / 2.0;
        double halfHeight = tileSizeDegrees / 2.0;
        ReferencedEnvelope boundsAtEquator = new ReferencedEnvelope(-halfWidth, halfWidth, -halfHeight, halfHeight, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        int dpi = 96;
        try {
            dpi = Display.getDefault().getDPI().x;
        }
        catch (Exception exception) {}
        return ScaleUtils.calculateScaleDenominator((ReferencedEnvelope)boundsAtEquator, (Dimension)new Dimension(this.tileSize, this.tileSize), (int)dpi);
    }

    public QuadTileSet getQuadTileSet() {
        return this.quadTileSet;
    }

    public double[] getScaleList() {
        return this.scales;
    }

    public WWTile.WWTileName.WWZoomLevel getZoomLevel(int index) {
        return this.zoomLevels.get(index);
    }

    public String getTileUrl(WWTile.WWTileName tileName) {
        return this.tileService.getTileRequest(tileName);
    }

    public String getFileFormat() {
        return this.tileFormat;
    }

    public int getTileSize() {
        return this.tileSize;
    }
}

