/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.wmtsource;

import net.refractions.udig.catalog.internal.wmt.tile.WWTile;
import net.refractions.udig.catalog.internal.wmt.wmtsource.WMTSource;
import net.refractions.udig.catalog.internal.wmt.wmtsource.ww.QuadTileSet;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WWSource
extends WMTSource {
    private QuadTileSet quadTileSet;
    public static final ReferencedEnvelope WORLD_BOUNDS = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);

    public WWSource(QuadTileSet quadTileSet) {
        this.quadTileSet = quadTileSet;
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return this.quadTileSet.getBounds();
    }

    @Override
    public CoordinateReferenceSystem getProjectedTileCrs() {
        return DefaultGeographicCRS.WGS84;
    }

    @Override
    public double[] getScaleList() {
        return this.quadTileSet.getScaleList();
    }

    @Override
    public WWTile.WWTileFactory getTileFactory() {
        return new WWTile.WWTileFactory();
    }

    @Override
    public String getFileFormat() {
        return this.quadTileSet.getFileFormat();
    }

    @Override
    public String getName() {
        return this.quadTileSet.getName();
    }

    @Override
    public int getTileHeight() {
        return this.quadTileSet.getTileSize();
    }

    @Override
    public int getTileWidth() {
        return this.getTileHeight();
    }

    @Override
    public String getId() {
        return this.quadTileSet.getId();
    }

    public WWTile.WWTileName.WWZoomLevel getZoomLevel(int index) {
        return this.quadTileSet.getZoomLevel(index);
    }
}

