/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.wmtsource;

import com.vividsolutions.jts.geom.Envelope;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.refractions.udig.catalog.internal.wmt.WMTPlugin;
import net.refractions.udig.catalog.internal.wmt.WMTRenderJob;
import net.refractions.udig.catalog.internal.wmt.WMTScaleZoomLevelMatcher;
import net.refractions.udig.catalog.internal.wmt.WMTService;
import net.refractions.udig.catalog.internal.wmt.tile.WMTTile;
import net.refractions.udig.catalog.internal.wmt.ui.properties.WMTLayerProperties;
import net.refractions.udig.catalog.internal.wmt.wmtsource.CSSource;
import net.refractions.udig.catalog.internal.wmt.wmtsource.OSMCloudMadeSource;
import net.refractions.udig.catalog.wmsc.server.Tile;
import net.refractions.udig.core.internal.CorePlugin;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.ObjectCache;
import org.geotools.util.ObjectCaches;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class WMTSource {
    private String name;
    private ObjectCache tiles = ObjectCaches.create((String)"soft", (int)50);
    private WMTService wmtService;
    public static final CoordinateReferenceSystem CRS_EPSG_900913;

    static {
        CoordinateReferenceSystem crs = null;
        try {
            crs = CRS.decode((String)"EPSG:900913");
        }
        catch (Exception exception) {
            WMTPlugin.trace("[WMTSource] EPSG:900913 is not in the database, now it is created manually", null);
            String wkt = "PROJCS[\"Google Mercator\",GEOGCS[\"WGS 84\",    DATUM[\"World Geodetic System 1984\",        SPHEROID[\"WGS 84\",6378137.0,298.257223563,            AUTHORITY[\"EPSG\",\"7030\"]],        AUTHORITY[\"EPSG\",\"6326\"]],    PRIMEM[\"Greenwich\",0.0,        AUTHORITY[\"EPSG\",\"8901\"]],    UNIT[\"degree\",0.017453292519943295],    AXIS[\"Geodetic latitude\",NORTH],    AXIS[\"Geodetic longitude\",EAST],    AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Mercator_1SP\"],PARAMETER[\"semi_minor\",6378137.0],PARAMETER[\"latitude_of_origin\",0.0],PARAMETER[\"central_meridian\",0.0],PARAMETER[\"scale_factor\",1.0],PARAMETER[\"false_easting\",0.0],PARAMETER[\"false_northing\",0.0],UNIT[\"m\",1.0],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"900913\"]]";
            try {
                crs = CRS.parseWKT((String)wkt);
            }
            catch (Exception exc2) {
                WMTPlugin.log("[WMTSource] Could not build EPSG:900913!", exc2);
                crs = DefaultGeographicCRS.WGS84;
            }
        }
        CRS_EPSG_900913 = crs;
    }

    protected WMTSource() {
    }

    protected void init(String resourceId) throws Exception {
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.getName();
    }

    public int getTileWidth() {
        return 256;
    }

    public int getTileHeight() {
        return 256;
    }

    public String getFileFormat() {
        return "png";
    }

    public ReferencedEnvelope getBounds() {
        return new ReferencedEnvelope(-180.0, 180.0, -85.051, 85.0511, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    public CoordinateReferenceSystem getProjectedTileCrs() {
        return CRS_EPSG_900913;
    }

    public CoordinateReferenceSystem getTileCrs() {
        return DefaultGeographicCRS.WGS84;
    }

    public boolean listContainsTile(String tileId) {
        return this.tiles.peek((Object)tileId) != null && this.tiles.get((Object)tileId) != null;
    }

    public WMTTile addTileToList(WMTTile tile) {
        if (this.listContainsTile(tile.getId())) {
            WMTPlugin.debug("[WMTSource.addTileToList] Already in cache: " + tile.getId(), "net.refractions.udig.catalog.wmt/debug/request");
            return this.getTileFromList(tile.getId());
        }
        WMTPlugin.debug("[WMTSource.addTileToList] Was not in cache: " + tile.getId(), "net.refractions.udig.catalog.wmt/debug/request");
        this.tiles.put((Object)tile.getId(), (Object)tile);
        return tile;
    }

    public WMTTile getTileFromList(String tileId) {
        return (WMTTile)this.tiles.get((Object)tileId);
    }

    public WMTService getWmtService() {
        return this.wmtService;
    }

    public void setWmtService(WMTService wmtService) {
        this.wmtService = wmtService;
    }

    public static URL getRelatedServiceUrl(Class<? extends WMTSource> sourceClass) {
        URL url;
        try {
            url = new URL(null, String.valueOf(WMTService.ID) + sourceClass.getName(), CorePlugin.RELAXED_HANDLER);
        }
        catch (MalformedURLException exc) {
            WMTPlugin.log("[WMTSource.getRelatedServiceUrl] Could not create url: " + sourceClass.getName(), exc);
            url = null;
        }
        return url;
    }

    public static URL getCloudMadeServiceUrl(String styleId) {
        URL url = WMTSource.getRelatedServiceUrl(OSMCloudMadeSource.class);
        try {
            url = new URL(null, String.valueOf(url.toExternalForm()) + "/" + styleId, CorePlugin.RELAXED_HANDLER);
        }
        catch (MalformedURLException exc) {
            WMTPlugin.log("[WMTSource.getCloudMadeServiceUrl] Could not create url: " + styleId, exc);
            url = null;
        }
        return url;
    }

    public static URL getCustomServerServiceUrl(String serverUrl, String zoomMin, String zoomMax, String type) {
        URL url = WMTSource.getRelatedServiceUrl(CSSource.class);
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(url.toExternalForm());
            sb.append("/");
            sb.append(serverUrl);
            sb.append("/");
            sb.append(zoomMin);
            sb.append("/");
            sb.append(zoomMax);
            if (type != null) {
                sb.append("/");
                sb.append(type);
            }
            url = new URL(null, sb.toString(), CorePlugin.RELAXED_HANDLER);
        }
        catch (MalformedURLException exc) {
            WMTPlugin.log("[WMTSource.getCustomServerServiceUrl] Could not create url: " + serverUrl + " " + zoomMin + " " + zoomMax, exc);
            url = null;
        }
        return url;
    }

    public abstract double[] getScaleList();

    public int getZoomLevelFromMapScale(WMTScaleZoomLevelMatcher zoomLevelMatcher, int scaleFactor) {
        double[] scaleList = this.getScaleList();
        double[] tempScaleList = new double[scaleList.length];
        Arrays.fill(tempScaleList, Double.NaN);
        assert (scaleList != null && scaleList.length > 0);
        int zoomLevel = zoomLevelMatcher.getZoomLevelFromScale(this, tempScaleList);
        if (zoomLevel == 0) {
            return zoomLevel;
        }
        int upperScaleIndex = zoomLevel - 1;
        int lowerScaleIndex = zoomLevel;
        double deltaScale = tempScaleList[upperScaleIndex] - tempScaleList[lowerScaleIndex];
        double rangeScale = (double)scaleFactor / 100.0 * deltaScale;
        double limitScale = tempScaleList[lowerScaleIndex] + rangeScale;
        if (zoomLevelMatcher.getScale() > limitScale) {
            return upperScaleIndex;
        }
        return lowerScaleIndex;
    }

    public int getZoomLevelToUse(WMTScaleZoomLevelMatcher zoomLevelMatcher, int scaleFactor, boolean useRecommended, WMTLayerProperties layerProperties) {
        if (useRecommended) {
            return this.getZoomLevelFromMapScale(zoomLevelMatcher, scaleFactor);
        }
        boolean selectionAutomatic = true;
        int zoomLevel = -1;
        if (layerProperties.load()) {
            selectionAutomatic = layerProperties.getSelectionAutomatic();
            zoomLevel = layerProperties.getZoomLevel();
        } else {
            selectionAutomatic = true;
        }
        if (!selectionAutomatic && zoomLevel >= this.getMinZoomLevel() && zoomLevel <= this.getMaxZoomLevel()) {
            return zoomLevel;
        }
        return this.getZoomLevelFromMapScale(zoomLevelMatcher, scaleFactor);
    }

    public int getMinZoomLevel() {
        double[] scaleList = this.getScaleList();
        int minZoomLevel = 0;
        while (Double.isNaN(scaleList[minZoomLevel]) && minZoomLevel < scaleList.length) {
            ++minZoomLevel;
        }
        return minZoomLevel;
    }

    public int getMaxZoomLevel() {
        double[] scaleList = this.getScaleList();
        int maxZoomLevel = scaleList.length - 1;
        while (Double.isNaN(scaleList[maxZoomLevel]) && maxZoomLevel >= 0) {
            --maxZoomLevel;
        }
        return maxZoomLevel;
    }

    public abstract WMTTile.WMTTileFactory getTileFactory();

    /*
     * Unable to fully structure code
     */
    public Map<String, Tile> cutExtentIntoTiles(WMTRenderJob renderJob, int scaleFactor, boolean recommendedZoomLevel, WMTLayerProperties layerProperties, int tileLimitWarning) {
        if (!renderJob.getMapExtentTileCrs().intersects((Envelope)this.getBounds())) {
            return Collections.emptyMap();
        }
        extent = this.normalizeExtent(renderJob.getMapExtentTileCrs());
        tileFactory = this.getTileFactory();
        zoomLevel = tileFactory.getZoomLevel(this.getZoomLevelToUse(renderJob.getZoomLevelMatcher(), scaleFactor, recommendedZoomLevel, layerProperties), this);
        maxNumberOfTiles = zoomLevel.getMaxTileNumber();
        tileList = new HashMap<String, Tile>();
        WMTPlugin.debug("[WMTSource.cutExtentIntoTiles] Zoom-Level: " + zoomLevel.getZoomLevel() + " Extent: " + extent, "net.refractions.udig.catalog.wmt/debug/request");
        firstTile = tileFactory.getTileFromCoordinate(extent.getMaxY(), extent.getMinX(), zoomLevel, this);
        tileList.put(firstTile.getId(), this.addTileToList(firstTile));
        firstTileOfRow = null;
        movingTile = firstTileOfRow = firstTile;
        do lbl-1000:
        // 3 sources

        {
            block3: {
                if (!extent.intersects((Envelope)(rightNeighbour = movingTile.getRightNeighbour()).getExtent()) || firstTileOfRow.equals(rightNeighbour)) break block3;
                tileList.put(rightNeighbour.getId(), this.addTileToList(rightNeighbour));
                WMTPlugin.debug("[WMTSource.cutExtentIntoTiles] Adding right neighbour: " + rightNeighbour.getId(), "net.refractions.udig.catalog.wmt/debug/request");
                movingTile = rightNeighbour;
                if (tileList.size() > tileLimitWarning) {
                    return Collections.emptyMap();
                }
                if ((long)tileList.size() < maxNumberOfTiles) ** GOTO lbl-1000
            }
            if (!extent.intersects((Envelope)(lowerNeighbour = firstTileOfRow.getLowerNeighbour()).getExtent()) || firstTile.equals(lowerNeighbour)) break;
            tileList.put(lowerNeighbour.getId(), this.addTileToList(lowerNeighbour));
            WMTPlugin.debug("[WMTSource.cutExtentIntoTiles] Adding lower neighbour: " + lowerNeighbour.getId(), "net.refractions.udig.catalog.wmt/debug/request");
            firstTileOfRow = movingTile = lowerNeighbour;
        } while ((long)tileList.size() < maxNumberOfTiles);
        return tileList;
    }

    private ReferencedEnvelope normalizeExtent(ReferencedEnvelope envelope) {
        ReferencedEnvelope bounds = this.getBounds();
        if (envelope.getMaxY() > bounds.getMaxY() || envelope.getMinY() < bounds.getMinY() || envelope.getMaxX() > bounds.getMaxX() || envelope.getMinX() < bounds.getMinX()) {
            double maxY = envelope.getMaxY() > bounds.getMaxY() ? bounds.getMaxY() : envelope.getMaxY();
            double minY = envelope.getMinY() < bounds.getMinY() ? bounds.getMinY() : envelope.getMinY();
            double maxX = envelope.getMaxX() > bounds.getMaxX() ? bounds.getMaxX() : envelope.getMaxX();
            double minX = envelope.getMinX() < bounds.getMinX() ? bounds.getMinX() : envelope.getMinX();
            ReferencedEnvelope newEnvelope = new ReferencedEnvelope(minX, maxX, minY, maxY, envelope.getCoordinateReferenceSystem());
            return newEnvelope;
        }
        return envelope;
    }

    public String toString() {
        return this.getName();
    }
}

