/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.wmtsource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.refractions.udig.catalog.internal.wmt.WMTPlugin;
import net.refractions.udig.catalog.internal.wmt.tile.NASATile;
import net.refractions.udig.catalog.internal.wmt.tile.WMTTile;
import net.refractions.udig.catalog.internal.wmt.wmtsource.NASASourceManager;
import net.refractions.udig.catalog.internal.wmt.wmtsource.WMTSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.jdom.Element;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class NASASource
extends WMTSource {
    public static String NAME = "NASA";
    private static WMTTile.WMTTileFactory tileFactory = new NASATile.NASATileFactory();
    private ReferencedEnvelope bounds;
    private String baseUrl;
    private List<NASATile.NASATileName.NASAZoomLevel> zoomLevels;
    private double[] scales;
    private int tileWidth;
    private int tileHeight;
    private String tileFormat;
    private static final String tileWidthPatternString = "(width=)(\\d*)(&)";
    private static final String tileHeightPatternString = "(height=)(\\d*)(&)";
    private static final String tileFormatPatternString = "(format=image/)([a-zA-Z]+)(&)";
    private static final Pattern tileWidthPattern = Pattern.compile("(width=)(\\d*)(&)", 34);
    private static final Pattern tileHeightPattern = Pattern.compile("(height=)(\\d*)(&)", 34);
    private static final Pattern tileFormatPattern = Pattern.compile("(format=image/)([a-zA-Z]+)(&)", 34);

    protected NASASource() {
    }

    @Override
    protected void init(String resourceId) throws Exception {
        NASASourceManager sourceManager = NASASourceManager.getInstance();
        Element tiledGroup = sourceManager.getTiledGroup(resourceId);
        this.baseUrl = sourceManager.getBaseUrl();
        this.setName(tiledGroup.getChildText("Name"));
        this.setBounds(tiledGroup.getChild("LatLonBoundingBox"));
        String firstTilePattern = tiledGroup.getChild("TilePattern").getValue();
        this.setTileSize(firstTilePattern);
        this.setTileFormat(firstTilePattern);
        WMTPlugin.debug("[NASASource] " + this.getName() + " " + this.getBounds(), "net.refractions.udig.catalog.wmt/debug/nasa");
        this.setZoomLevels(tiledGroup.getChildren("TilePattern"), this.baseUrl);
    }

    private void setZoomLevels(List<?> tilePatterns, String baseUrl) {
        this.zoomLevels = new ArrayList<NASATile.NASATileName.NASAZoomLevel>();
        for (Object element : tilePatterns) {
            if (!(element instanceof Element)) continue;
            Element tilePattern = (Element)element;
            String tilePatternText = tilePattern.getValue();
            NASATile.NASATileName.NASAZoomLevel zoomLevel = new NASATile.NASATileName.NASAZoomLevel(tilePatternText, this);
            WMTPlugin.debug("[NASASource] Zoom-Level: " + zoomLevel.getScale() + " " + zoomLevel.getWidthInWorldUnits(), "net.refractions.udig.catalog.wmt/debug/nasa");
            this.zoomLevels.add(zoomLevel);
        }
        this.generateScaleList();
    }

    private void generateScaleList() {
        Collections.sort(this.zoomLevels);
        Collections.reverse(this.zoomLevels);
        this.scales = new double[this.zoomLevels.size()];
        int i = 0;
        while (i < this.zoomLevels.size()) {
            this.zoomLevels.get(i).setZoomLevel(i);
            this.scales[i] = this.zoomLevels.get(i).getScale();
            ++i;
        }
    }

    private void setBounds(Element latLonBoundingBox) {
        try {
            double minX = latLonBoundingBox.getAttribute("minx").getDoubleValue();
            double maxX = latLonBoundingBox.getAttribute("maxx").getDoubleValue();
            double minY = latLonBoundingBox.getAttribute("miny").getDoubleValue();
            double maxY = latLonBoundingBox.getAttribute("maxy").getDoubleValue();
            this.bounds = new ReferencedEnvelope(minX, maxX, minY, maxY, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        }
        catch (Exception exc) {
            WMTPlugin.log("[NASASource.setBounds] Failed: " + this.getName(), exc);
            this.bounds = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        }
    }

    private void setTileSize(String tilePattern) {
        Matcher mWidth = tileWidthPattern.matcher(tilePattern);
        Matcher mHeight = tileHeightPattern.matcher(tilePattern);
        if (mWidth.find() && mHeight.find()) {
            String widthText = mWidth.group(2);
            String heightText = mHeight.group(2);
            try {
                int width = Integer.parseInt(widthText);
                int height = Integer.parseInt(heightText);
                this.tileWidth = width;
                this.tileHeight = height;
                return;
            }
            catch (Exception exc) {
                WMTPlugin.log("[NASASource.setTileSize] Failed: " + this.getName(), exc);
            }
        }
        this.tileWidth = 512;
        this.tileHeight = 512;
    }

    private void setTileFormat(String tilePattern) {
        Matcher matcher = tileFormatPattern.matcher(tilePattern);
        String format = "jpeg";
        if (matcher.find()) {
            format = matcher.group(2);
        } else {
            WMTPlugin.log("[NASASource.setTileFormat] Could not get the format: " + this.getName(), null);
        }
        this.tileFormat = format;
    }

    @Override
    public String getFileFormat() {
        return this.tileFormat;
    }

    @Override
    public double[] getScaleList() {
        return this.scales;
    }

    public NASATile.NASATileName.NASAZoomLevel getZoomLevel(int index) {
        return this.zoomLevels.get(index);
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return this.bounds;
    }

    @Override
    public WMTTile.WMTTileFactory getTileFactory() {
        return tileFactory;
    }

    @Override
    public int getTileHeight() {
        return this.tileHeight;
    }

    @Override
    public int getTileWidth() {
        return this.tileWidth;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public CoordinateReferenceSystem getProjectedTileCrs() {
        return DefaultGeographicCRS.WGS84;
    }
}

