/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.ui.wizard.controls;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.refractions.udig.catalog.internal.wmt.WMTPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class OSMCloudMadeStylesManager {
    private static final String URL_FEATURED = "http://maps.cloudmade.com/map_styles/gallery_search?group=1&color=-14&text=";
    private static final String URL_CLOUDMADE = "http://maps.cloudmade.com/map_styles/gallery_search?group=3&color=-14&text=";
    private static final String PROP_FEATURED = "WIZ_CLOUDMADE_FEATURED";
    private static final String PROP_CLOUDMADE = "WIZ_CLOUDMADE_CLOUDMADE";
    private static final String FALLBACK_FILE_FEATURED = "group-featured.txt";
    private static final String FALLBACK_FILE_CLOUDMADE = "group-cloudmade.txt";
    private static final String IMG_DIR = "/icons/wizard/";
    public static final String IMG_DEFAULT = "/icons/wizard/default.png";
    public static final String IMG_LOADING = "/icons/wizard/loading.png";
    private Map<String, CloudMadeStyle> styles = new HashMap<String, CloudMadeStyle>();

    public CloudMadeStyleGroup getGroupFeatured() {
        return this.cacheGroup(new CloudMadeStyleGroup(URL_FEATURED, PROP_FEATURED, FALLBACK_FILE_FEATURED));
    }

    public CloudMadeStyleGroup getGroupCloudMade() {
        return this.cacheGroup(new CloudMadeStyleGroup(URL_CLOUDMADE, PROP_CLOUDMADE, FALLBACK_FILE_CLOUDMADE));
    }

    private CloudMadeStyleGroup cacheGroup(CloudMadeStyleGroup group) {
        List<CloudMadeStyle> groupStyles = group.getStyles();
        for (CloudMadeStyle style : groupStyles) {
            this.cacheStyle(style);
        }
        return group;
    }

    private void cacheStyle(CloudMadeStyle style) {
        if (!this.styles.containsKey(style.getId())) {
            this.styles.put(style.getId(), style);
        }
    }

    public CloudMadeStyle getStyleFromId(String id) {
        if (this.styles.containsKey(id)) {
            return this.styles.get(id);
        }
        String requestUrl = CloudMadeStyleGroup.buildRequestUrl("", id);
        List<CloudMadeStyle> styles = new CloudMadeStyleGroup(requestUrl).getStyles();
        for (CloudMadeStyle style : styles) {
            if (!style.getId().equals(id)) continue;
            this.cacheStyle(style);
            return style;
        }
        return CloudMadeStyle.EMPTY_STYLE;
    }

    public static class CloudMadeStyle {
        private String id;
        private String name;
        private String author;
        public static final String EMPTY_STYLE_ID = "default";
        public static final CloudMadeStyle EMPTY_STYLE = new CloudMadeStyle("default", "not found", "-");

        public CloudMadeStyle(String id, String name, String author) {
            this.id = id;
            this.name = name;
            this.author = author;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class CloudMadeStyleGroup {
        private String requestUrl;
        private String backupProperties;
        private String fallBackFile;
        private boolean requestOnly = false;
        private List<CloudMadeStyle> styles;
        private static final String stylePatternString = "(\\{)([^\\}]*)(\\})";
        private static final Pattern stylePattern = Pattern.compile("(\\{)([^\\}]*)(\\})", 34);
        private static final String authorPatternString = "(\"author\": )(\".*?\")";
        private static final Pattern authorPattern = Pattern.compile("(\"author\": )(\".*?\")", 34);
        private static final String namePatternString = "(\"name\": )(\".*?\")";
        private static final Pattern namePattern = Pattern.compile("(\"name\": )(\".*?\")", 34);
        private static final String idPatternString = "(\"id\": )(\\d+)";
        private static final Pattern idPattern = Pattern.compile("(\"id\": )(\\d+)", 34);
        private IPreferenceStore preferences;

        public CloudMadeStyleGroup(String requestUrl) {
            this(requestUrl, null, null);
        }

        public CloudMadeStyleGroup(String requestUrl, String backupProperties, String fallBackFile) {
            this.requestUrl = requestUrl;
            this.backupProperties = backupProperties;
            this.fallBackFile = fallBackFile;
            if (backupProperties == null) {
                this.requestOnly = true;
            }
            this.preferences = WMTPlugin.getDefault().getPreferenceStore();
            this.loadStyles();
            if (this.styles == null) {
                this.styles = Collections.emptyList();
            }
        }

        public List<CloudMadeStyle> getStyles() {
            return this.styles;
        }

        private void loadStyles() {
            try {
                this.getStylesFromRequest();
                return;
            }
            catch (Exception exc) {
                WMTPlugin.log("[CloudMadeStyleGroup.loadStyles] Getting styles from request failed", exc);
                if (this.requestOnly) {
                    return;
                }
                try {
                    this.getStylesFromBackup();
                    return;
                }
                catch (Exception exc2) {
                    WMTPlugin.log("[CloudMadeStyleGroup.loadStyles] Getting styles from backup failed", exc2);
                    try {
                        this.getStylesFromFallBackFile();
                        return;
                    }
                    catch (Exception exc3) {
                        WMTPlugin.log("[CloudMadeStyleGroup.loadStyles] Getting style from fallback file failed", exc3);
                        this.styles = Collections.emptyList();
                        return;
                    }
                }
            }
        }

        private void getStylesFromRequest() throws Exception {
            URL url = new URL(this.requestUrl);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            String rawStyles = this.getStylesFromStream(in);
            if (this.requestOnly) {
                return;
            }
            if (this.styles == null || this.styles.isEmpty()) {
                throw new Exception("No Styles loaded: " + rawStyles);
            }
            this.preferences.setValue(this.backupProperties, rawStyles);
        }

        private void getStylesFromBackup() throws Exception {
            this.getStylesFromString(this.preferences.getString(this.backupProperties));
            if (this.styles == null || this.styles.isEmpty()) {
                throw new Exception("No Styles loaded");
            }
        }

        private void getStylesFromFallBackFile() throws Exception {
            URL url = this.getClass().getResource(this.fallBackFile);
            this.getStylesFromFile(url);
        }

        private void getStylesFromFile(URL filePath) throws Exception {
            BufferedReader in = new BufferedReader(new InputStreamReader(filePath.openStream()));
            this.getStylesFromStream(in);
        }

        private String getStylesFromStream(BufferedReader reader) throws Exception {
            StringBuffer response = new StringBuffer();
            try {
                String inputLine;
                while ((inputLine = reader.readLine()) != null) {
                    response.append(inputLine);
                }
            }
            finally {
                reader.close();
            }
            String rawStyles = response.toString();
            this.getStylesFromString(rawStyles);
            return rawStyles;
        }

        private void getStylesFromString(String rawStyles) throws Exception {
            this.styles = new ArrayList<CloudMadeStyle>();
            Matcher matcher = stylePattern.matcher(rawStyles);
            while (matcher.find()) {
                CloudMadeStyle style = this.getStyleFromString(matcher.group(2));
                if (style == null) continue;
                this.styles.add(style);
            }
        }

        private CloudMadeStyle getStyleFromString(String rawStyle) {
            Matcher matcherName = namePattern.matcher(rawStyle);
            Matcher matcherId = idPattern.matcher(rawStyle);
            Matcher matcherAuthor = authorPattern.matcher(rawStyle);
            if (matcherName.find() && matcherId.find() && matcherAuthor.find()) {
                String nameText = this.getStringWithoutQuotes(matcherName.group(2)).trim();
                String authorText = this.getStringWithoutQuotes(matcherAuthor.group(2)).trim();
                String idText = matcherId.group(2).trim();
                CloudMadeStyle style = new CloudMadeStyle(idText, nameText, authorText);
                return style;
            }
            return null;
        }

        private String getStringWithoutQuotes(String s) {
            if (s.length() <= 0) {
                return "";
            }
            return s.substring(1, s.length() - 1);
        }

        public static String buildRequestUrl(String group, String text) {
            return "http://maps.cloudmade.com/map_styles/gallery_search?group=" + group.trim() + "&color=-14&text=" + text.trim();
        }
    }
}

