/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.ui.wizard.controls;

import java.net.URL;
import java.util.Map;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.internal.wmt.WMTServiceExtension;
import net.refractions.udig.catalog.internal.wmt.ui.wizard.controls.OSMCloudMadeStylesManager;
import net.refractions.udig.catalog.internal.wmt.ui.wizard.controls.WMTWizardControl;
import net.refractions.udig.catalog.internal.wmt.wmtsource.WMTSource;
import net.refractions.udig.catalog.wmt.internal.Messages;
import net.refractions.udig.core.internal.CorePlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class OSMCloudMadeControl
extends WMTWizardControl {
    private ListViewer lvCloudMade;
    private ListViewer lvFeatured;
    private Label lblStyleIdField;
    private Text txtStyleId;
    private Link link;
    private Button btnStyleGroups;
    private Group gBCloudMade;
    private Group gBFeatured;
    private Button btnRefresh;
    private Composite previewImage;
    private Display display;
    private Label lblStyleNameValue;
    private Label lblStyleIdValue;
    private Label lblStyleAuthorValue;
    private OSMCloudMadeStylesManager stylesManager;
    private OSMCloudMadeStylesManager.CloudMadeStyleGroup styleGroupFeatured;
    private OSMCloudMadeStylesManager.CloudMadeStyleGroup styleGroupCloudMade;
    private WMTServiceExtension serviceExtension;
    private ImageRegistry imageCache;
    private volatile String previewStyleId;
    private SelectionAdapter radioSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            boolean enableState = OSMCloudMadeControl.this.btnStyleGroups.getSelection();
            OSMCloudMadeControl.this.lvCloudMade.getList().setEnabled(enableState);
            OSMCloudMadeControl.this.lvFeatured.getList().setEnabled(enableState);
            OSMCloudMadeControl.this.gBCloudMade.setEnabled(enableState);
            OSMCloudMadeControl.this.gBFeatured.setEnabled(enableState);
            OSMCloudMadeControl.this.lblStyleIdField.setEnabled(!enableState);
            OSMCloudMadeControl.this.txtStyleId.setEnabled(!enableState);
            OSMCloudMadeControl.this.btnRefresh.setEnabled(!enableState);
            OSMCloudMadeControl.this.link.setEnabled(!enableState);
            OSMCloudMadeControl.this.updatePreview();
        }
    };
    private SelectionAdapter listSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            if (event.getSource() == OSMCloudMadeControl.this.lvCloudMade.getList()) {
                OSMCloudMadeControl.this.lvFeatured.getList().setSelection(-1);
            } else {
                OSMCloudMadeControl.this.lvCloudMade.getList().setSelection(-1);
            }
            OSMCloudMadeControl.this.updatePreview();
        }
    };

    @Override
    public IService getService() {
        URL url = WMTSource.getCloudMadeServiceUrl(this.getSelectedStyleId());
        IService service = this.serviceExtension.createService(url, (Map)this.serviceExtension.createParams(url));
        return service;
    }

    private String getSelectedStyleId() {
        if (this.btnStyleGroups != null && !this.btnStyleGroups.isDisposed()) {
            if (this.btnStyleGroups.getSelection()) {
                return this.getSelectedStyle().getId();
            }
            return this.txtStyleId.getText().trim();
        }
        return "";
    }

    @Override
    protected Control buildControl(Composite infoBox) {
        this.display = infoBox.getDisplay();
        Composite composite = new Composite(infoBox, 0);
        composite.setLayout((Layout)new RowLayout(512));
        this.btnStyleGroups = new Button(composite, 16);
        this.btnStyleGroups.setSelection(true);
        this.btnStyleGroups.setText(Messages.Wizard_CloudMade_StyleFromGroup);
        this.btnStyleGroups.addSelectionListener((SelectionListener)this.radioSelectionListener);
        Composite compositeGroups = new Composite(composite, 0);
        compositeGroups.setLayout((Layout)new RowLayout(256));
        this.gBCloudMade = new Group(compositeGroups, 2048);
        this.gBCloudMade.setLayout((Layout)new RowLayout(512));
        this.gBCloudMade.setText(Messages.Wizard_CloudMade_GroupCloudMade);
        this.lvCloudMade = new ListViewer((Composite)this.gBCloudMade);
        this.lvCloudMade.getList().setLayoutData((Object)new RowData(180, 80));
        this.lvCloudMade.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.lvCloudMade.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.gBCloudMade.pack();
        this.gBFeatured = new Group(compositeGroups, 2048);
        this.gBFeatured.setLayout((Layout)new RowLayout(512));
        this.gBFeatured.setText(Messages.Wizard_CloudMade_GroupFeatured);
        this.lvFeatured = new ListViewer((Composite)this.gBFeatured);
        this.lvFeatured.getList().setLayoutData((Object)new RowData(180, 80));
        this.lvFeatured.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.lvFeatured.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.gBFeatured.pack();
        Button btnOwnStyle = new Button(composite, 16);
        btnOwnStyle.setText(Messages.Wizard_CloudMade_StyleFromId);
        Composite compositeStyleId = new Composite(composite, 0);
        compositeStyleId.setLayout((Layout)new RowLayout(256));
        this.lblStyleIdField = new Label(compositeStyleId, 256);
        this.lblStyleIdField.setText(Messages.Wizard_CloudMade_StyleId);
        this.txtStyleId = new Text(compositeStyleId, 2048);
        this.txtStyleId.setBounds(10, 10, 200, 200);
        this.txtStyleId.setText(Messages.Wizard_CloudMade_DefaultStyleId);
        this.txtStyleId.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                    OSMCloudMadeControl.this.updatePreview();
                }
            }

            public void keyReleased(KeyEvent arg0) {
            }
        });
        this.txtStyleId.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String input = e.text;
                int i = 0;
                while (i < input.length()) {
                    if ('0' > input.charAt(i) || input.charAt(i) > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        this.btnRefresh = new Button(compositeStyleId, 8);
        this.btnRefresh.setText(Messages.Wizard_CloudMade_RefreshPreview);
        this.btnRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OSMCloudMadeControl.this.updatePreview();
            }
        });
        this.link = new Link(composite, 2048);
        this.link.setText(Messages.Wizard_CloudMade_StyleEditorInfo);
        this.link.setLayoutData((Object)new RowData(400, 50));
        this.link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Program.launch((String)"http://maps.cloudmade.com/editor");
            }
        });
        Group gBPreview = new Group(composite, 2048);
        gBPreview.setLayout((Layout)new RowLayout(256));
        gBPreview.setText(Messages.Wizard_CloudMade_Preview);
        Composite compositeStyleInfo = new Composite((Composite)gBPreview, 0);
        compositeStyleInfo.setLayout((Layout)new RowLayout(512));
        compositeStyleInfo.setLayoutData((Object)new RowData(180, 160));
        Label lblStyleName = new Label(compositeStyleInfo, 257);
        lblStyleName.setText(Messages.Wizard_CloudMade_PreviewName);
        Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
        lblStyleName.setFont(boldFont);
        this.lblStyleNameValue = new Label(compositeStyleInfo, 256);
        this.lblStyleNameValue.setText("");
        Label lblStyleId = new Label(compositeStyleInfo, 256);
        lblStyleId.setText(Messages.Wizard_CloudMade_PreviewId);
        lblStyleId.setFont(boldFont);
        this.lblStyleIdValue = new Label(compositeStyleInfo, 256);
        this.lblStyleIdValue.setText("");
        Label lblStyleAuthor = new Label(compositeStyleInfo, 256);
        lblStyleAuthor.setText(Messages.Wizard_CloudMade_PreviewAuthor);
        lblStyleAuthor.setFont(boldFont);
        this.lblStyleAuthorValue = new Label(compositeStyleInfo, 256);
        this.lblStyleAuthorValue.setText("");
        this.previewImage = new Composite((Composite)gBPreview, 0);
        this.previewImage.setLayoutData((Object)new RowData(233, 160));
        this.previewImage.setCursor(new Cursor((Device)this.display, 21));
        this.previewImage.setToolTipText(Messages.Wizard_CloudMade_PreviewGetFullMap);
        this.previewImage.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent arg0) {
            }

            public void mouseUp(MouseEvent arg0) {
            }

            public void mouseDown(MouseEvent arg0) {
                if (!OSMCloudMadeControl.this.previewStyleId.equals("default")) {
                    Program.launch((String)("http://maps.cloudmade.com/?lat=51.508315&lng=-0.124712&zoom=14&styleId=" + OSMCloudMadeControl.this.previewStyleId));
                }
            }
        });
        gBPreview.pack();
        this.stylesManager = new OSMCloudMadeStylesManager();
        this.styleGroupCloudMade = this.stylesManager.getGroupCloudMade();
        this.lvCloudMade.setInput(this.styleGroupCloudMade.getStyles());
        this.styleGroupFeatured = this.stylesManager.getGroupFeatured();
        this.lvFeatured.setInput(this.styleGroupFeatured.getStyles());
        if (this.styleGroupCloudMade.getStyles().size() > 0) {
            this.lvCloudMade.getList().setSelection(0);
        }
        this.imageCache = new ImageRegistry(this.display);
        ImageDescriptor descDefault = ImageDescriptor.createFromFile(this.getClass(), (String)"/icons/wizard/default.png");
        this.imageCache.put("default", descDefault);
        ImageDescriptor descLoading = ImageDescriptor.createFromFile(this.getClass(), (String)"/icons/wizard/loading.png");
        this.imageCache.put("/icons/wizard/loading.png", descLoading);
        this.lvCloudMade.getList().addSelectionListener((SelectionListener)this.listSelectionListener);
        this.lvFeatured.getList().addSelectionListener((SelectionListener)this.listSelectionListener);
        this.radioSelectionListener.widgetSelected(null);
        this.serviceExtension = new WMTServiceExtension();
        this.control = composite;
        return composite;
    }

    private void updatePreview() {
        OSMCloudMadeStylesManager.CloudMadeStyle style = this.btnStyleGroups.getSelection() ? this.getSelectedStyle() : this.stylesManager.getStyleFromId(this.txtStyleId.getText().trim());
        this.updatePreviewWithStyle(style);
    }

    private void updatePreviewWithStyle(OSMCloudMadeStylesManager.CloudMadeStyle style) {
        this.lblStyleNameValue.setText(style.getName());
        this.lblStyleNameValue.pack();
        this.lblStyleIdValue.setText(style.getId());
        this.lblStyleIdValue.pack();
        this.lblStyleAuthorValue.setText(style.getAuthor());
        this.lblStyleAuthorValue.pack();
        this.updatePreviewMap(style.getId());
    }

    private void updatePreviewMap(final String styleId) {
        this.previewStyleId = styleId;
        this.previewImage.setBackgroundImage(this.imageCache.get("/icons/wizard/loading.png"));
        Image image = this.imageCache.get(styleId);
        if (image == null) {
            new Thread(){

                @Override
                public void run() {
                    Image newImage;
                    block9: {
                        String imageUrl = "http://tile.cloudmade.com/c8d1aeca771d57d6a0584fea7ce386f4/" + styleId + "/256/15/16372/10896.png";
                        newImage = null;
                        try {
                            try {
                                URL url = new URL(null, imageUrl, CorePlugin.RELAXED_HANDLER);
                                ImageDescriptor imageDescr = ImageDescriptor.createFromURL((URL)url);
                                OSMCloudMadeControl.this.imageCache.put(styleId, imageDescr);
                                newImage = OSMCloudMadeControl.this.imageCache.get(styleId);
                            }
                            catch (Exception exception) {
                                newImage = null;
                                if (newImage == null || !newImage.isDisposed() && newImage.getBounds().width < 256) {
                                    newImage = OSMCloudMadeControl.this.imageCache.get("default");
                                }
                                break block9;
                            }
                        }
                        catch (Throwable throwable) {
                            if (newImage == null || !newImage.isDisposed() && newImage.getBounds().width < 256) {
                                newImage = OSMCloudMadeControl.this.imageCache.get("default");
                            }
                            throw throwable;
                        }
                        if (newImage == null || !newImage.isDisposed() && newImage.getBounds().width < 256) {
                            newImage = OSMCloudMadeControl.this.imageCache.get("default");
                        }
                    }
                    if (OSMCloudMadeControl.this.previewStyleId.equals(styleId)) {
                        final Image newImageToDisplay = newImage;
                        OSMCloudMadeControl.this.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                OSMCloudMadeControl.this.previewImage.setBackgroundImage(newImageToDisplay);
                            }
                        });
                    }
                }
            }.start();
        } else {
            this.previewImage.setBackgroundImage(image);
        }
    }

    private OSMCloudMadeStylesManager.CloudMadeStyle getSelectedStyle() {
        if (this.lvCloudMade.getList().getSelectionCount() > 0) {
            return this.styleGroupCloudMade.getStyles().get(this.lvCloudMade.getList().getSelectionIndex());
        }
        if (this.lvFeatured.getList().getSelectionCount() > 0) {
            return this.styleGroupFeatured.getStyles().get(this.lvFeatured.getList().getSelectionIndex());
        }
        return OSMCloudMadeStylesManager.CloudMadeStyle.EMPTY_STYLE;
    }
}

