/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.ui.wizard.controls;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.internal.wmt.WMTServiceExtension;
import net.refractions.udig.catalog.internal.wmt.ui.wizard.controls.WMTWizardControl;
import net.refractions.udig.catalog.internal.wmt.wmtsource.WMTSource;
import org.apache.commons.io.FileUtils;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;

public class JGrasstoolsTmsFolderControl
extends WMTWizardControl {
    private WMTServiceExtension serviceExtension;
    private Text txtUrl;
    private boolean isTMS = false;

    @Override
    public IService getService() {
        if (this.txtUrl == null || this.txtUrl.isDisposed()) {
            return null;
        }
        String urlText = this.txtUrl.getText().trim();
        File urlFile = new File(urlText);
        if (!urlFile.exists()) {
            return null;
        }
        String urlString = null;
        String zoomMin = "0";
        String zoomMax = "18";
        List fileLines = null;
        try {
            fileLines = FileUtils.readLines((File)urlFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        for (String line : fileLines) {
            int split;
            if ((line = line.trim()).length() == 0 || (split = line.indexOf(61)) == -1) continue;
            String value = line.substring(split + 1).trim();
            if (line.startsWith("url")) {
                int indexOfZ = value.indexOf("ZZZ");
                String folderName = value.substring(0, indexOfZ);
                urlString = String.valueOf(urlFile.getParent()) + "/" + folderName + "/{z}/{x}/{y}.png";
            }
            if (line.startsWith("minzoom")) {
                zoomMin = value;
            }
            if (line.startsWith("maxzoom")) {
                zoomMax = value;
            }
            if (!line.startsWith("type") || !value.toLowerCase().equals("tms")) continue;
            this.isTMS = true;
        }
        URL url = WMTSource.getCustomServerServiceUrl(urlString, zoomMin, zoomMax, this.isTMS ? "TMS" : null);
        IService service = this.serviceExtension.createService(url, (Map)this.serviceExtension.createParams(url));
        return service;
    }

    @Override
    protected Control buildControl(Composite composite) {
        final Composite control = new Composite(composite, 0);
        control.setLayout((Layout)new GridLayout(2, false));
        Link text = new Link(control, 320);
        GridData textGD = new GridData(4, 4, true, false);
        textGD.horizontalSpan = 2;
        text.setLayoutData((Object)textGD);
        text.setText("Here you can load a TMS tiles folder that was exported with the Spatial Toolbox and the JGrasstools tiler.");
        Label lblUrl = new Label(control, 257);
        lblUrl.setText("Select the tiles file definition (*.mapurl)");
        Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
        lblUrl.setFont(boldFont);
        GridData lblUrlGD = new GridData(4, 4, true, false);
        lblUrlGD.horizontalSpan = 2;
        lblUrl.setLayoutData((Object)lblUrlGD);
        this.txtUrl = new Text(control, 2048);
        this.txtUrl.setLayoutData((Object)new RowData(380, 20));
        GridData txtUrlGD = new GridData(4, 4, true, false);
        this.txtUrl.setLayoutData((Object)txtUrlGD);
        Button browseButton = new Button(control, 8);
        browseButton.setLayoutData((Object)new GridData(0x1000008, 4, false, false));
        browseButton.setText("...");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(control.getShell(), 4096);
                String path = fileDialog.open();
                if (path == null || path.length() < 1) {
                    JGrasstoolsTmsFolderControl.this.txtUrl.setText("");
                } else {
                    JGrasstoolsTmsFolderControl.this.txtUrl.setText(path);
                }
            }
        });
        this.serviceExtension = new WMTServiceExtension();
        this.control = control;
        return control;
    }
}

