/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.ui.wizard.controls;

import java.net.URL;
import java.util.Map;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.internal.wmt.WMTServiceExtension;
import net.refractions.udig.catalog.internal.wmt.ui.wizard.controls.WMTWizardControl;
import net.refractions.udig.catalog.internal.wmt.wmtsource.WMTSource;
import net.refractions.udig.catalog.wmt.internal.Messages;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class CSControl
extends WMTWizardControl {
    private WMTServiceExtension serviceExtension;
    private Spinner spZoomMin;
    private Spinner spZoomMax;
    private Text txtUrl;
    private Button typeButton;

    @Override
    public IService getService() {
        if (this.txtUrl == null || this.txtUrl.isDisposed()) {
            return null;
        }
        String urlText = this.txtUrl.getText().trim();
        if (this.validUrl(urlText)) {
            if (urlText.startsWith("http")) {
                urlText = urlText.substring(7);
            }
            URL url = WMTSource.getCustomServerServiceUrl(urlText, this.spZoomMin.getText(), this.spZoomMax.getText(), this.typeButton.getSelection() ? "TMS" : null);
            IService service = this.serviceExtension.createService(url, (Map)this.serviceExtension.createParams(url));
            return service;
        }
        return null;
    }

    private boolean validUrl(String url) {
        if (!url.contains("{z}")) {
            return false;
        }
        if (!url.contains("{x}")) {
            return false;
        }
        return url.contains("{y}");
    }

    @Override
    protected Control buildControl(Composite composite) {
        Composite control = new Composite(composite, 0);
        control.setLayout((Layout)new RowLayout(512));
        Link text = new Link(control, 320);
        text.setLayoutData((Object)new RowData(400, 110));
        text.setText(Messages.Wizard_CS_Description);
        text.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Program.launch((String)Messages.Wizard_CS_UrlTileNames);
            }
        });
        Label lblUrl = new Label(control, 257);
        lblUrl.setText(Messages.Wizard_CS_Url);
        Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
        lblUrl.setFont(boldFont);
        this.txtUrl = new Text(control, 2048);
        this.txtUrl.setLayoutData((Object)new RowData(380, 20));
        this.txtUrl.setText(Messages.Wizard_CS_UrlDefault);
        this.typeButton = new Button(control, 32);
        this.typeButton.setLayoutData((Object)new RowData(380, 20));
        this.typeButton.setText("Handle as TMS as opposed to Google tile schema.");
        Composite compositeRow = new Composite(control, 0);
        compositeRow.setLayout((Layout)new RowLayout(256));
        Composite compositeZoom = new Composite(compositeRow, 0);
        compositeZoom.setLayout((Layout)new RowLayout(512));
        compositeZoom.setLayoutData((Object)new RowData(200, 100));
        Label lblZoom = new Label(compositeZoom, 257);
        lblZoom.setText(Messages.Wizard_CS_ZoomLevel);
        lblZoom.setFont(boldFont);
        Composite compositeRowZoom = new Composite(compositeZoom, 0);
        compositeRowZoom.setLayout((Layout)new GridLayout(2, true));
        Label lblZoomMin = new Label(compositeRowZoom, 257);
        lblZoomMin.setText(Messages.Wizard_CS_Min);
        this.spZoomMin = new Spinner(compositeRowZoom, 2056);
        this.spZoomMin.setMinimum(0);
        this.spZoomMin.setMaximum(22);
        this.spZoomMin.setSelection(2);
        this.spZoomMin.setIncrement(1);
        this.spZoomMin.pack();
        Label lblZoomMax = new Label(compositeRowZoom, 257);
        lblZoomMax.setText(Messages.Wizard_CS_Max);
        this.spZoomMax = new Spinner(compositeRowZoom, 2056);
        this.spZoomMax.setMinimum(0);
        this.spZoomMax.setMaximum(22);
        this.spZoomMax.setSelection(18);
        this.spZoomMax.setIncrement(1);
        this.spZoomMax.pack();
        Composite compositeTags = new Composite(compositeRow, 0);
        compositeTags.setLayout((Layout)new RowLayout(512));
        Label lblTags = new Label(compositeTags, 257);
        lblTags.setText(Messages.Wizard_CS_AvailableTags);
        lblTags.setFont(boldFont);
        Label lblTagZ = new Label(compositeTags, 257);
        lblTagZ.setText(Messages.Wizard_CS_TagZoom);
        Label lblTagX = new Label(compositeTags, 257);
        lblTagX.setText(Messages.Wizard_CS_TagX);
        Label lblTagY = new Label(compositeTags, 257);
        lblTagY.setText(Messages.Wizard_CS_TagY);
        this.serviceExtension = new WMTServiceExtension();
        this.control = control;
        return control;
    }
}

