/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.ui.wizard;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.internal.wmt.WMTPlugin;
import net.refractions.udig.catalog.internal.wmt.ui.wizard.WWConnectionFactory;
import net.refractions.udig.catalog.internal.wmt.ww.WWService;
import net.refractions.udig.catalog.internal.wmt.ww.WWServiceExtension;
import net.refractions.udig.catalog.ui.AbstractUDIGImportPage;
import net.refractions.udig.catalog.ui.UDIGConnectionPage;
import net.refractions.udig.catalog.ui.workflow.EndConnectionState;
import net.refractions.udig.catalog.wmt.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class WWWizardPage
extends AbstractUDIGImportPage
implements ModifyListener,
UDIGConnectionPage {
    private static final String WW_WIZARD = "WW_WIZARD";
    private static final String WW_RECENT = "WW_RECENT";
    private static final String WW_PATH = "WW_PATH";
    private static final int COMBO_HISTORY_LENGTH = 15;
    private IDialogSettings settings;
    private Combo comboUrl;
    private Text txtLocalFile;
    private Button btnUrl;
    private Button btnLocalFile;
    private Button btnOpenFileDialog;
    private String url = "";
    private SelectionAdapter radioSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            boolean enableState = WWWizardPage.this.btnUrl.getSelection();
            WWWizardPage.this.comboUrl.setEnabled(enableState);
            WWWizardPage.this.txtLocalFile.setEnabled(!enableState);
            WWWizardPage.this.btnOpenFileDialog.setEnabled(!enableState);
            WWWizardPage.this.modifyText(null);
        }
    };

    public WWWizardPage() {
        super(Messages.Wizard_WW_Title);
        this.settings = WMTPlugin.getDefault().getDialogSettings().getSection(WW_WIZARD);
        if (this.settings == null) {
            this.settings = WMTPlugin.getDefault().getDialogSettings().addNewSection(WW_WIZARD);
        }
    }

    public String getId() {
        return "net.refractions.udig.catalog.ui.WW";
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        Label urlLabel = new Label(composite, 0);
        urlLabel.setText(Messages.Wizard_WW_Description);
        GridData gridLabel = new GridData();
        urlLabel.setLayoutData((Object)gridLabel);
        this.btnUrl = new Button(composite, 16);
        this.btnUrl.addSelectionListener((SelectionListener)this.radioSelectionListener);
        this.btnUrl.setSelection(true);
        this.btnUrl.setText(Messages.Wizard_WW_Url);
        this.comboUrl = new Combo(composite, 2048);
        this.comboUrl.setItems(this.getRecentURLs());
        this.comboUrl.setVisibleItemCount(15);
        GridData gridDataCombo = new GridData(768);
        gridDataCombo.widthHint = 400;
        this.comboUrl.setLayoutData((Object)gridDataCombo);
        Map<String, Serializable> params = this.defaultParams();
        this.setDefaultUrl(this.getURL(params));
        this.comboUrl.addModifyListener((ModifyListener)this);
        this.btnLocalFile = new Button(composite, 16);
        this.btnLocalFile.setText(Messages.Wizard_WW_LocalFile);
        Composite row = new Composite(composite, 0);
        row.setLayout((Layout)new RowLayout(256));
        this.txtLocalFile = new Text(row, 2048);
        this.txtLocalFile.setLayoutData((Object)new RowData(350, 20));
        this.btnOpenFileDialog = new Button(row, 8);
        this.btnOpenFileDialog.setText(Messages.Wizard_WW_SelectFile);
        final Shell shell = parent.getShell();
        this.btnOpenFileDialog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(shell, 4096);
                fd.setText(Messages.Wizard_WW_SelectFile);
                this.setLastUsedPath(fd);
                String[] filterExtensions = new String[]{"*.xml"};
                String[] filterNames = new String[]{"NASA WorldWind Configuration File (*.xml)"};
                fd.setFilterExtensions(filterExtensions);
                fd.setFilterNames(filterNames);
                String selectedFile = fd.open();
                if (selectedFile != null) {
                    WWWizardPage.this.txtLocalFile.setText(selectedFile);
                    this.saveLastUsedPath(fd.getFilterPath());
                    WWWizardPage.this.modifyText(null);
                }
            }

            private void saveLastUsedPath(String path) {
                if (WWWizardPage.this.settings != null && path != null) {
                    WWWizardPage.this.settings.put(WWWizardPage.WW_PATH, path);
                }
            }

            private void setLastUsedPath(FileDialog fd) {
                if (WWWizardPage.this.settings != null) {
                    fd.setFilterPath(WWWizardPage.this.settings.get(WWWizardPage.WW_PATH));
                }
            }
        });
        this.radioSelectionListener.widgetSelected(null);
        this.setControl((Control)composite);
        this.getWizard().getContainer().updateButtons();
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                EndConnectionState currentState = WWWizardPage.this.getState();
                Map errors = currentState.getErrors();
                if (errors != null && !errors.isEmpty()) {
                    for (Map.Entry entry : errors.entrySet()) {
                        if (!(entry.getKey() instanceof WWService)) continue;
                        Throwable value = (Throwable)entry.getValue();
                        String message = String.valueOf(Messages.Wizard_WW_ConnectionProblem) + value.getLocalizedMessage();
                        WWWizardPage.this.setErrorMessage(message);
                    }
                }
            }
        });
    }

    private void setDefaultUrl(URL selectedURL) {
        if (selectedURL != null) {
            this.comboUrl.setText(selectedURL.toExternalForm());
            this.url = selectedURL.toExternalForm();
            this.setPageComplete(true);
        } else if (this.url != null && this.url.length() != 0) {
            this.comboUrl.setText(this.url);
            this.setPageComplete(true);
        } else {
            this.url = null;
            this.comboUrl.setText("http://");
            this.setPageComplete(false);
        }
    }

    private String[] getRecentURLs() {
        String[] recentURLs = this.settings.getArray(WW_RECENT);
        if (recentURLs == null) {
            recentURLs = new String[]{};
        }
        return recentURLs;
    }

    protected Map<String, Serializable> defaultParams() {
        IStructuredSelection selection = (IStructuredSelection)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        Map<String, Serializable> toParams = this.toParams(selection);
        if (!toParams.isEmpty()) {
            return toParams;
        }
        WWConnectionFactory connectionFactory = new WWConnectionFactory();
        Map<String, Serializable> params = connectionFactory.createConnectionParameters(this.getState().getWorkflow().getContext());
        if (params != null) {
            return params;
        }
        return Collections.emptyMap();
    }

    protected Map<String, Serializable> toParams(IStructuredSelection context) {
        if (context != null) {
            WWConnectionFactory connectionFactory = new WWConnectionFactory();
            Iterator itr = context.iterator();
            while (itr.hasNext()) {
                Map<String, Serializable> params = connectionFactory.createConnectionParameters(itr.next());
                if (params.isEmpty()) continue;
                return params;
            }
        }
        return Collections.emptyMap();
    }

    public void setErrorMessage(String newMessage) {
        WizardPage page = (WizardPage)this.getContainer().getCurrentPage();
        page.setErrorMessage(newMessage);
        this.setPageComplete(newMessage == null);
        this.getWizard().getContainer().updateButtons();
    }

    public void setMessage(String newMessage) {
        WizardPage page = (WizardPage)this.getContainer().getCurrentPage();
        page.setMessage(newMessage);
    }

    public void setMessage(String newMessage, int messageType) {
        WizardPage page = (WizardPage)this.getContainer().getCurrentPage();
        page.setMessage(newMessage, messageType);
    }

    public EndConnectionState getState() {
        return (EndConnectionState)super.getState();
    }

    public URL getURL(Map<String, Serializable> params) {
        Serializable value = params.get("net.refractions.udig.catalog.internal.wmt.WWService.WW_URL_KEY");
        if (value == null) {
            return null;
        }
        if (value instanceof URL) {
            return (URL)value;
        }
        if (value instanceof String) {
            try {
                URL url = new URL((String)((Object)value));
                return url;
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        e.getClass();
        if (this.getWizard().canFinish()) {
            this.getWizard().performFinish();
        }
    }

    public List<IService> getResources(IProgressMonitor monitor) throws Exception {
        URL location = new URL(this.url);
        WWServiceExtension creator = new WWServiceExtension();
        Map<String, Serializable> params = creator.createParams(location);
        IService service = creator.createService(location, params);
        service.getInfo(monitor);
        ArrayList<IService> servers = new ArrayList<IService>();
        servers.add(service);
        this.saveWidgetValues();
        return servers;
    }

    public boolean leavingPage() {
        Collection services = this.getServices();
        Iterator iterator = services.iterator();
        while (iterator.hasNext()) {
            IService service;
            final IService runService = service = (IService)iterator.next();
            try {
                this.getContainer().run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(Messages.Wizard_WW_Connecting, -1);
                        try {
                            runService.members(monitor);
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e, e.getLocalizedMessage());
                        }
                        monitor.done();
                    }
                });
            }
            catch (Exception exception) {
                this.setErrorMessage(Messages.WWService_NoValidFile);
                this.setPageComplete(false);
                this.getWizard().getContainer().updateButtons();
                return false;
            }
        }
        this.saveWidgetValues();
        return super.leavingPage();
    }

    public void modifyText(ModifyEvent e) {
        try {
            this.getState().getErrors().clear();
            if (this.btnUrl.getSelection()) {
                this.url = this.comboUrl.getText().trim();
            } else {
                String path = this.txtLocalFile.getText().trim();
                File file = new File(path);
                this.url = file.toURI().toURL().toString();
            }
            new URL(this.url);
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
        catch (MalformedURLException malformedURLException) {
            this.setErrorMessage(Messages.Wizard_WW_Url);
            this.setPageComplete(false);
        }
        this.getWizard().getContainer().updateButtons();
    }

    private void saveWidgetValues() {
        if (this.settings != null) {
            String[] recentURLs = this.getRecentURLs();
            recentURLs = this.addToHistory(recentURLs, this.url);
            this.settings.put(WW_RECENT, recentURLs);
        }
    }

    private String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        this.addToHistory(l, newEntry);
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    private void addToHistory(List<String> history, String newEntry) {
        history.remove(newEntry);
        history.add(0, newEntry);
        if (history.size() > 15) {
            history.remove(15);
        }
    }

    public Map<String, Serializable> getParams() {
        WWServiceExtension creator;
        URL location;
        block3: {
            try {
                location = new URL(this.url);
                creator = new WWServiceExtension();
                String errorMessage = creator.reasonForFailure(location);
                if (errorMessage == null) break block3;
                this.setErrorMessage(errorMessage);
                return null;
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        return creator.createParams(location);
    }

    public List<URL> getURLs() {
        try {
            ArrayList<URL> l = new ArrayList<URL>();
            l.add(new URL(this.url));
            return l;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }
}

