/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.ui.wizard;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.internal.wmt.wmtsource.ww.LayerSet;
import net.refractions.udig.catalog.internal.wmt.ww.WWGeoResource;
import net.refractions.udig.catalog.internal.wmt.ww.WWService;
import net.refractions.udig.catalog.internal.wmt.ww.WWServiceExtension;
import net.refractions.udig.catalog.ui.UDIGConnectionFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class WWConnectionFactory
extends UDIGConnectionFactory {
    public boolean canProcess(Object context) {
        if (context instanceof IResolve) {
            IResolve resolve = (IResolve)context;
            return resolve.canResolve(LayerSet.class);
        }
        return WWConnectionFactory.toWWConfigURL(context) != null;
    }

    public Map<String, Serializable> createConnectionParameters(Object context) {
        Map<String, Serializable> params;
        if (context instanceof IResolve && !(params = WWConnectionFactory.createParams((IResolve)context)).isEmpty()) {
            return params;
        }
        URL url = WWConnectionFactory.toWWConfigURL(context);
        if (url == null) {
            url = CatalogPlugin.locateURL((Object)context);
        }
        if (url != null) {
            List list = CatalogPlugin.getDefault().getLocalCatalog().find(url, null);
            for (IResolve resolve : list) {
                Map<String, Serializable> params2 = WWConnectionFactory.createParams(resolve);
                if (params2.isEmpty()) continue;
                return params2;
            }
            return WWConnectionFactory.createParams(url);
        }
        return Collections.emptyMap();
    }

    public static Map<String, Serializable> createParams(IResolve handle) {
        if (handle instanceof WWService) {
            WWService service = (WWService)handle;
            return service.getConnectionParams();
        }
        if (handle instanceof WWGeoResource) {
            WWGeoResource geoResource = (WWGeoResource)handle;
            try {
                WWService service = (WWService)geoResource.service((IProgressMonitor)new NullProgressMonitor());
                return service.getConnectionParams();
            }
            catch (IOException iOException) {
                WWConnectionFactory.checkedURL(geoResource.getIdentifier());
            }
        } else if (handle.canResolve(LayerSet.class)) {
            return WWConnectionFactory.createParams(handle.getIdentifier());
        }
        return Collections.emptyMap();
    }

    public static Map<String, Serializable> createParams(URL url) {
        WWServiceExtension factory = new WWServiceExtension();
        Map<String, Serializable> params = factory.createParams(url);
        if (params != null) {
            return params;
        }
        HashMap<String, Serializable> params2 = new HashMap<String, Serializable>();
        params2.put("net.refractions.udig.catalog.internal.wmt.WWService.WW_URL_KEY", url);
        return params2;
    }

    static URL toWWConfigURL(Object data) {
        if (data instanceof IResolve) {
            return WWConnectionFactory.toWWConfigURL((IResolve)data);
        }
        if (data instanceof URL) {
            return WWConnectionFactory.toWWConfigURL((URL)data);
        }
        if (CatalogPlugin.locateURL((Object)data) != null) {
            return WWConnectionFactory.toWWConfigURL(CatalogPlugin.locateURL((Object)data));
        }
        return null;
    }

    static URL toWWConfigURL(IResolve resolve) {
        if (resolve instanceof IService) {
            return WWConnectionFactory.toWWConfigURL((IService)resolve);
        }
        return WWConnectionFactory.toWWConfigURL(resolve.getIdentifier());
    }

    static URL toWWConfigURL(IService resolve) {
        if (resolve instanceof WWService) {
            return WWConnectionFactory.toWWConfigURL((WWService)resolve);
        }
        return WWConnectionFactory.toWWConfigURL(resolve.getIdentifier());
    }

    static URL toWWConfigURL(WWService service) {
        return service.getIdentifier();
    }

    static URL toWWConfigURL(URL url) {
        if (url == null) {
            return null;
        }
        String PROTOCOL = url.getProtocol();
        String PATH = url.getPath();
        if (PROTOCOL == null || PROTOCOL.isEmpty()) {
            return null;
        }
        if (PATH == null || PATH.isEmpty() || !PATH.toLowerCase().contains(".xml")) {
            return null;
        }
        return WWConnectionFactory.checkedURL(url);
    }

    public static URL checkedURL(URL url) {
        String check = url.toExternalForm();
        int hash = check.indexOf(35);
        if (hash == -1) {
            return url;
        }
        try {
            return new URL(check.substring(0, hash));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public URL createConnectionURL(Object context) {
        if (context instanceof URL) {
            return (URL)context;
        }
        return null;
    }
}

