/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.internal.wmt.WMTPlugin;
import net.refractions.udig.catalog.internal.wmt.WMTService;
import net.refractions.udig.catalog.internal.wmt.WMTServiceExtension;
import net.refractions.udig.catalog.internal.wmt.ui.wizard.WMTWizardTreeItemData;
import net.refractions.udig.catalog.internal.wmt.ui.wizard.controls.CSControl;
import net.refractions.udig.catalog.internal.wmt.ui.wizard.controls.JGrasstoolsTmsFolderControl;
import net.refractions.udig.catalog.internal.wmt.ui.wizard.controls.MQControl;
import net.refractions.udig.catalog.internal.wmt.ui.wizard.controls.OSMCloudMadeControl;
import net.refractions.udig.catalog.internal.wmt.ui.wizard.controls.OSMControl;
import net.refractions.udig.catalog.internal.wmt.ui.wizard.controls.WMTWizardControl;
import net.refractions.udig.catalog.internal.wmt.ui.wizard.controls.WWControl;
import net.refractions.udig.catalog.internal.wmt.wmtsource.MQSource;
import net.refractions.udig.catalog.internal.wmt.wmtsource.NASASource;
import net.refractions.udig.catalog.internal.wmt.wmtsource.NASASourceManager;
import net.refractions.udig.catalog.internal.wmt.wmtsource.OSMCycleMapSource;
import net.refractions.udig.catalog.internal.wmt.wmtsource.OSMMapnikSource;
import net.refractions.udig.catalog.internal.wmt.wmtsource.OSMOsmarenderSource;
import net.refractions.udig.catalog.internal.wmt.wmtsource.OSMSource;
import net.refractions.udig.catalog.internal.wmt.wmtsource.WMTSource;
import net.refractions.udig.catalog.ui.AbstractUDIGImportPage;
import net.refractions.udig.catalog.ui.UDIGConnectionPage;
import net.refractions.udig.catalog.wmt.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class WMTWizardPage
extends AbstractUDIGImportPage
implements UDIGConnectionPage {
    private WMTServiceExtension serviceExtension = new WMTServiceExtension();
    private Tree tree;
    private StackLayout stackLayoutInfoBox;
    private Composite infoBox;
    private Composite childControl;

    public WMTWizardPage() {
        super(Messages.Wizard_Title);
    }

    public String getId() {
        return "net.refractions.udig.catalog.ui.WMT";
    }

    public boolean leavingPage() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                WMTWizardPage.this.getWizard().getWorkflow().next();
            }
        };
        try {
            this.getContainer().run(true, false, runnable);
        }
        catch (InvocationTargetException e2) {
            throw (RuntimeException)new RuntimeException().initCause(e2);
        }
        catch (InterruptedException e2) {
            throw (RuntimeException)new RuntimeException().initCause(e2);
        }
        return super.leavingPage();
    }

    public Collection<URL> getResourceIDs() {
        LinkedList<URL> resourceIDs = new LinkedList<URL>();
        this.getSelectedResources(resourceIDs, this.tree);
        return resourceIDs;
    }

    private void getSelectedResources(Collection<URL> resourceIDs, Tree tree) {
        int i = 0;
        while (i < tree.getItemCount()) {
            TreeItem treeItem = tree.getItem(i);
            if (treeItem.getChecked() || treeItem.getGrayed()) {
                this.getSelectedResources(resourceIDs, treeItem);
            }
            ++i;
        }
    }

    private void getSelectedResources(Collection<URL> resourceIDs, TreeItem treeItem) {
        WMTWizardTreeItemData itemData;
        IGeoResource geoResource;
        if (treeItem.getData() instanceof WMTWizardTreeItemData && (geoResource = (itemData = (WMTWizardTreeItemData)treeItem.getData()).getGeoResource()) != null) {
            WMTPlugin.debug("[Wizard.getSelectedResources] adding " + geoResource.getIdentifier(), "net.refractions.udig.catalog.wmt/debug/wizard");
            resourceIDs.add(geoResource.getIdentifier());
        }
        int i = 0;
        while (i < treeItem.getItemCount()) {
            TreeItem childItem = treeItem.getItem(i);
            if (childItem.getChecked() || childItem.getGrayed()) {
                this.getSelectedResources(resourceIDs, childItem);
            }
            ++i;
        }
    }

    public Collection<IService> getServices() {
        ArrayList<IService> services = new ArrayList<IService>();
        int i = 0;
        while (i < this.tree.getItemCount()) {
            TreeItem parentItem = this.tree.getItem(i);
            if (parentItem.getChecked() || parentItem.getGrayed()) {
                this.addItemData(services, parentItem.getData());
                int j = 0;
                while (j < parentItem.getItemCount()) {
                    TreeItem childItem = parentItem.getItem(j);
                    if (childItem.getChecked()) {
                        this.addItemData(services, childItem.getData());
                    }
                    ++j;
                }
            }
            ++i;
        }
        return services;
    }

    private void addItemData(Collection<IService> services, Object data) {
        WMTWizardTreeItemData itemData;
        IService service;
        if (data instanceof WMTWizardTreeItemData && (service = (itemData = (WMTWizardTreeItemData)data).getService()) != null) {
            services.add(service);
        }
    }

    private void addWMTSourceToTree(TreeItem treeItem, Class<? extends WMTSource> sourceClass, WMTWizardControl controlFactory) {
        TreeItem newTreeItem = new TreeItem(treeItem, 0);
        WMTService service = this.serviceExtension.createService(sourceClass);
        newTreeItem.setText(service.getName());
        WMTWizardTreeItemData data = new WMTWizardTreeItemData((IResolve)service, controlFactory);
        newTreeItem.setData((Object)data);
    }

    public void createControl(Composite parent) {
        if (this.tree != null && !this.tree.isDisposed()) {
            return;
        }
        Composite composite = this.childControl = new Composite(parent, 0);
        composite.setLayout((Layout)new RowLayout());
        this.setControl((Control)composite);
        this.createTreeControl(composite);
        TreeItem osm = this.addOsmOptions();
        this.addWorldWindOptions();
        this.addNasaOptions();
        osm.getItems()[0].setChecked(true);
        this.tree.setSelection(osm.getItems()[0]);
        this.displayInfoControl(osm.getItems()[0]);
        osm.setChecked(true);
        osm.setGrayed(true);
        composite.pack();
    }

    private void createTreeControl(Composite composite) {
        this.tree = new Tree(composite, 2080);
        this.tree.setLayoutData((Object)new RowData(300, 442));
        this.tree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TreeItem item = (TreeItem)event.item;
                WMTWizardPage.this.displayInfoControl(item);
                if (event.detail == 32) {
                    boolean checked = item.getChecked();
                    WMTWizardPage.this.checkItems(item, checked);
                    WMTWizardPage.this.checkPath(item.getParentItem(), checked, false);
                    if (WMTWizardPage.this.noItemChecked()) {
                        WMTWizardPage.this.setPageComplete(false);
                    } else {
                        WMTWizardPage.this.setPageComplete(true);
                    }
                    WMTWizardPage.this.getWizard().getContainer().updateButtons();
                }
            }
        });
        this.infoBox = new Composite(composite, 0);
        this.stackLayoutInfoBox = new StackLayout();
        this.infoBox.setLayout((Layout)this.stackLayoutInfoBox);
        this.infoBox.setLayoutData((Object)new RowData(430, 470));
    }

    private TreeItem addOsmOptions() {
        TreeItem osm = new TreeItem(this.tree, 0);
        osm.setText(OSMSource.NAME);
        OSMControl osmControlFactory = new OSMControl();
        this.addWMTSourceToTree(osm, OSMMapnikSource.class, osmControlFactory);
        this.addWMTSourceToTree(osm, OSMOsmarenderSource.class, osmControlFactory);
        this.addWMTSourceToTree(osm, OSMCycleMapSource.class, osmControlFactory);
        OSMCloudMadeControl osmCloudMadeControlFactory = new OSMCloudMadeControl();
        TreeItem cloudMadeTreeItem = new TreeItem(osm, 0);
        cloudMadeTreeItem.setText("CloudMade");
        WMTWizardTreeItemData dataCloudMade = new WMTWizardTreeItemData(null, osmCloudMadeControlFactory);
        cloudMadeTreeItem.setData((Object)dataCloudMade);
        CSControl osmCSControlFactory = new CSControl();
        TreeItem csTreeItem = new TreeItem(osm, 0);
        csTreeItem.setText(Messages.Wizard_CS_Title);
        WMTWizardTreeItemData dataCS = new WMTWizardTreeItemData(null, osmCSControlFactory);
        csTreeItem.setData((Object)dataCS);
        JGrasstoolsTmsFolderControl jgrasstoolsTmsControlFactory = new JGrasstoolsTmsFolderControl();
        TreeItem jgrasstoolsTmsTreeItem = new TreeItem(osm, 0);
        jgrasstoolsTmsTreeItem.setText("JGrasstools TMS folder");
        WMTWizardTreeItemData dataJGTms = new WMTWizardTreeItemData(null, jgrasstoolsTmsControlFactory);
        jgrasstoolsTmsTreeItem.setData((Object)dataJGTms);
        osm.setExpanded(true);
        return osm;
    }

    private void addNasaOptions() {
        TreeItem nasa = new TreeItem(this.tree, 0);
        nasa.setText(NASASource.NAME);
        NASASourceManager nasaManager = NASASourceManager.getInstance();
        nasaManager.buildWizardTree(nasa);
        nasa.setExpanded(true);
    }

    private void addWorldWindOptions() {
        TreeItem ww = new TreeItem(this.tree, 0);
        ww.setText(Messages.Wizard_Ww_Example_Title);
        WWControl wwControlFactory = new WWControl();
        TreeItem wwTreeItem = new TreeItem(ww, 0);
        wwTreeItem.setText(Messages.Wizard_Ww_Example_Demis_Title);
        WMTWizardTreeItemData dataWW = new WMTWizardTreeItemData(null, wwControlFactory);
        wwTreeItem.setData((Object)dataWW);
        ww.setExpanded(true);
    }

    private void addMapQuestOptions() {
        MQControl mqControlFactory = new MQControl();
        TreeItem mq = new TreeItem(this.tree, 0);
        mq.setText(MQSource.NAME);
        this.addWMTSourceToTree(mq, MQSource.class, mqControlFactory);
        mq.setExpanded(true);
    }

    private void displayInfoControl(TreeItem item) {
        if (item.getData() != null && item.getData() instanceof WMTWizardTreeItemData) {
            WMTWizardTreeItemData itemData = (WMTWizardTreeItemData)item.getData();
            this.stackLayoutInfoBox.topControl = itemData.getControlFactory().getControl(this.infoBox);
            this.infoBox.layout();
            this.childControl.pack();
        }
    }

    private boolean noItemChecked() {
        int selectedItemCount = 0;
        int i = 0;
        while (i < this.tree.getItemCount()) {
            TreeItem parentItem = this.tree.getItem(i);
            if (parentItem.getChecked() || parentItem.getGrayed()) {
                int j = 0;
                while (j < parentItem.getItemCount()) {
                    TreeItem childItem = parentItem.getItem(j);
                    if (childItem.getChecked()) {
                        ++selectedItemCount;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return selectedItemCount <= 0;
    }

    private void checkPath(TreeItem item, boolean checked, boolean grayed) {
        if (item == null) {
            return;
        }
        if (grayed) {
            checked = true;
        } else {
            int index = 0;
            TreeItem[] items = item.getItems();
            while (index < items.length) {
                TreeItem child = items[index];
                if (child.getGrayed() || checked != child.getChecked()) {
                    grayed = true;
                    checked = true;
                    break;
                }
                ++index;
            }
        }
        item.setChecked(checked);
        item.setGrayed(grayed);
        this.checkPath(item.getParentItem(), checked, grayed);
    }

    private void checkItems(TreeItem item, boolean checked) {
        item.setGrayed(false);
        item.setChecked(checked);
        TreeItem[] items = item.getItems();
        int i = 0;
        while (i < items.length) {
            this.checkItems(items[i], checked);
            ++i;
        }
    }

    void close() {
        if (this.getContainer() != null && this.getContainer().getShell() != null && !this.getContainer().getShell().isDisposed()) {
            this.getContainer().getShell().close();
        }
    }
}

