/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.ui.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.internal.wmt.WMTPlugin;
import net.refractions.udig.catalog.internal.wmt.WMTRenderJob;
import net.refractions.udig.catalog.internal.wmt.WMTScaleZoomLevelMatcher;
import net.refractions.udig.catalog.internal.wmt.wmtsource.WMTSource;
import net.refractions.udig.catalog.wmt.internal.Messages;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.IMapCompositionListener;
import net.refractions.udig.project.MapCompositionEvent;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.commands.SetScaleCommand;
import net.refractions.udig.project.render.IViewportModelListener;
import net.refractions.udig.project.render.ViewportModelEvent;
import net.refractions.udig.project.ui.ApplicationGIS;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class WMTZoomLevelSwitcher
extends ViewPart {
    private ISelectionChangedListener listenerZoomLevel;
    private IMapCompositionListener listenerMap;
    private IViewportModelListener listenerViewport;
    private IPartListener listenerMapEditor;
    private Composite parentControl;
    private Button btnZoomOut;
    private Button btnZoomIn;
    private ComboViewer cvLayers;
    private ComboViewer cvZoomLevels;
    private IMap currentMap = ApplicationGIS.NO_MAP;
    private List<ILayer> layerList;
    private Integer[] zoomLevels;
    private ImageRegistry imageCache;
    private static final String ICONS_PATH = "/icons/etool16/";
    private static final String ICON_ZOOM_IN = "ZOOM_IN";
    private static final String ICON_ZOOM_IN_PATH = "/icons/etool16/zoom_in_co.gif";
    private static final String ICON_ZOOM_OUT = "ZOOM_OUT";
    private static final String ICON_ZOOM_OUT_PATH = "/icons/etool16/zoom_out_co.gif";

    public WMTZoomLevelSwitcher() {
        this.initListeners();
    }

    private void initListeners() {
        this.initMapListener();
        this.initViewportListener();
        this.initMapEditorListener();
    }

    private void initMapListener() {
        this.listenerMap = new IMapCompositionListener(){

            public void changed(MapCompositionEvent event) {
                if (WMTZoomLevelSwitcher.this.parentControl == null || WMTZoomLevelSwitcher.this.parentControl.isDisposed()) {
                    return;
                }
                WMTZoomLevelSwitcher.this.parentControl.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        WMTZoomLevelSwitcher.this.updateGUI(ApplicationGIS.getActiveMap());
                    }
                });
            }
        };
    }

    private void initViewportListener() {
        this.listenerViewport = new IViewportModelListener(){

            public void changed(ViewportModelEvent event) {
                if (WMTZoomLevelSwitcher.this.parentControl == null || WMTZoomLevelSwitcher.this.parentControl.isDisposed()) {
                    return;
                }
                WMTZoomLevelSwitcher.this.parentControl.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        WMTZoomLevelSwitcher.this.updateGUIFromScale();
                    }
                });
            }
        };
    }

    private void initMapEditorListener() {
        this.listenerMapEditor = new IPartListener(){
            private IWorkbenchPart currentPart;

            public void partActivated(IWorkbenchPart part) {
                if (part == this.currentPart) {
                    return;
                }
                final IMap map = this.getMapFromPart(part);
                if (map != null) {
                    this.currentPart = part;
                    if (WMTZoomLevelSwitcher.this.parentControl == null || WMTZoomLevelSwitcher.this.parentControl.isDisposed()) {
                        return;
                    }
                    WMTZoomLevelSwitcher.this.parentControl.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            WMTZoomLevelSwitcher.this.setUpMapListeners(map);
                        }
                    });
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
                this.partActivated(part);
            }

            public void partClosed(IWorkbenchPart part) {
                if (part == WMTZoomLevelSwitcher.this) {
                    if (WMTZoomLevelSwitcher.this.parentControl == null || WMTZoomLevelSwitcher.this.parentControl.isDisposed()) {
                        return;
                    }
                    WMTZoomLevelSwitcher.this.parentControl.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            WMTZoomLevelSwitcher.this.removeAllListeners();
                            currentPart = null;
                        }
                    });
                    return;
                }
                if (part != this.currentPart) {
                    return;
                }
                final IMap map = this.getMapFromPart(part);
                if (map != null) {
                    if (WMTZoomLevelSwitcher.this.parentControl == null || WMTZoomLevelSwitcher.this.parentControl.isDisposed()) {
                        return;
                    }
                    WMTZoomLevelSwitcher.this.parentControl.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            WMTZoomLevelSwitcher.this.removeMapListeners(map, true);
                        }
                    });
                }
                this.currentPart = null;
            }

            private IMap getMapFromPart(IWorkbenchPart part) {
                IWorkbenchPart adaptable;
                Object obj;
                if (part != null && (obj = (adaptable = part).getAdapter(Map.class)) instanceof Map) {
                    return (Map)obj;
                }
                return null;
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partOpened(IWorkbenchPart part) {
            }
        };
    }

    public void setUpMapListeners(IMap map) {
        this.removeMapListeners(this.currentMap, false);
        this.removeMapListeners(map, false);
        map.addMapCompositionListener(this.listenerMap);
        map.getViewportModel().addViewportModelListener(this.listenerViewport);
        this.updateGUI(map);
    }

    public void removeMapListeners(IMap map, boolean updateGUI) {
        if (map == null || map == ApplicationGIS.NO_MAP) {
            return;
        }
        map.removeMapCompositionListener(this.listenerMap);
        map.getViewportModel().removeViewportModelListener(this.listenerViewport);
        if (updateGUI && this.parentControl != null && !this.parentControl.isDisposed()) {
            this.currentMap = ApplicationGIS.NO_MAP;
            this.layerList.clear();
            this.enableComponents(false);
        }
    }

    public void removeAllListeners() {
        this.removeMapListeners(this.currentMap, false);
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.listenerMapEditor);
    }

    public void createPartControl(Composite parent) {
        this.parentControl = parent;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new RowLayout(256));
        Label lblLayer = new Label(composite, 256);
        lblLayer.setText(Messages.ZoomLevelSwitcher_Layer);
        this.cvLayers = new ComboViewer(composite, 8);
        this.cvLayers.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.cvLayers.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ILayer) {
                    return ((ILayer)element).getName();
                }
                return super.getText(element);
            }
        });
        this.cvLayers.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WMTZoomLevelSwitcher.this.updateZoomLevels();
                WMTZoomLevelSwitcher.this.updateGUIFromScale();
            }
        });
        Label lblZoomLevel = new Label(composite, 256);
        lblZoomLevel.setText(Messages.ZoomLevelSwitcher_ZoomLevel);
        this.cvZoomLevels = new ComboViewer(composite, 8);
        this.cvZoomLevels.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.cvZoomLevels.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.setUpImageCache(parent);
        this.btnZoomOut = new Button(composite, 8);
        this.btnZoomOut.setImage(this.imageCache.get(ICON_ZOOM_OUT));
        this.btnZoomOut.setToolTipText(Messages.ZoomLevelSwitcher_ZoomOut);
        this.btnZoomOut.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WMTZoomLevelSwitcher.this.zoomOut();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnZoomIn = new Button(composite, 8);
        this.btnZoomIn.setImage(this.imageCache.get(ICON_ZOOM_IN));
        this.btnZoomIn.setToolTipText(Messages.ZoomLevelSwitcher_ZoomIn);
        this.btnZoomIn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WMTZoomLevelSwitcher.this.zoomIn();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.listenerZoomLevel = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WMTZoomLevelSwitcher.this.zoomToZoomLevel(WMTZoomLevelSwitcher.this.getSelectedZoomLevel());
            }
        };
        this.cvZoomLevels.addSelectionChangedListener(this.listenerZoomLevel);
        this.setUpMapListeners(ApplicationGIS.getActiveMap());
        this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.listenerMapEditor);
    }

    private void setUpImageCache(Composite parent) {
        this.imageCache = new ImageRegistry(parent.getDisplay());
        ImageDescriptor descZoomOut = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)ICON_ZOOM_OUT_PATH);
        this.imageCache.put(ICON_ZOOM_OUT, descZoomOut);
        ImageDescriptor descZoomIn = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)ICON_ZOOM_IN_PATH);
        this.imageCache.put(ICON_ZOOM_IN, descZoomIn);
    }

    private void updateGUI(IMap map) {
        if (this.parentControl != null && !this.parentControl.isDisposed()) {
            this.updateLayerList(map);
            this.updateZoomLevels();
            this.updateGUIFromScale();
            this.parentControl.pack();
        }
    }

    private void updateLayerList(IMap map) {
        if (this.layerList == null) {
            this.layerList = new ArrayList<ILayer>();
        }
        ILayer selectedLayer = this.getSelectedLayer();
        this.layerList.clear();
        if (map == null || map == ApplicationGIS.NO_MAP) {
            map = ApplicationGIS.getActiveMap();
        }
        if (map != ApplicationGIS.NO_MAP) {
            List mapLayers = map.getMapLayers();
            for (ILayer layer : mapLayers) {
                if (layer == null || layer.findGeoResource(WMTSource.class) == null) continue;
                this.layerList.add(layer);
            }
        }
        this.cvLayers.setInput(this.layerList);
        this.setSelectedLayer(selectedLayer);
        this.enableComponents(!this.layerList.isEmpty());
        this.currentMap = map;
    }

    private void updateZoomLevels() {
        WMTSource wmtSource = this.getWMTSourceOfSelectedLayer();
        if (wmtSource == null) {
            this.cvZoomLevels.setInput(null);
        } else {
            int minZoomLevel = wmtSource.getMinZoomLevel();
            int maxZoomLevel = wmtSource.getMaxZoomLevel();
            this.generateZoomLevels(minZoomLevel, maxZoomLevel);
            this.cvZoomLevels.setInput((Object)this.zoomLevels);
        }
    }

    private void updateGUIFromScale() {
        try {
            WMTSource wmtSource = this.getWMTSourceOfSelectedLayer();
            if (wmtSource == null) {
                throw new Exception("wmtSource is null");
            }
            WMTScaleZoomLevelMatcher zoomLevelMatcher = this.getZoomLevelMatcher(wmtSource);
            int zoomLevel = wmtSource.getZoomLevelFromMapScale(zoomLevelMatcher, WMTRenderJob.getScaleFactor());
            this.setSelectedZoomLevel(zoomLevel);
            this.updateZoomButtons(zoomLevel);
        }
        catch (Exception e) {
            WMTPlugin.log("[WMTZoomLevelSwitcher.updateGUIFromScale] Failed ", e);
        }
    }

    private void setSelectedZoomLevel(int zoomLevel) {
        ArrayList<Integer> selectedZoomLevels = new ArrayList<Integer>(1);
        selectedZoomLevels.add(zoomLevel);
        StructuredSelection selection = new StructuredSelection(selectedZoomLevels);
        this.cvZoomLevels.removeSelectionChangedListener(this.listenerZoomLevel);
        this.cvZoomLevels.setSelection((ISelection)selection);
        this.cvZoomLevels.addSelectionChangedListener(this.listenerZoomLevel);
    }

    private int getSelectedZoomLevel() {
        StructuredSelection selection = (StructuredSelection)this.cvZoomLevels.getSelection();
        if (selection.isEmpty()) {
            return this.zoomLevels[0];
        }
        return (Integer)selection.getFirstElement();
    }

    private void generateZoomLevels(int minZoomLevel, int maxZoomLevel) {
        int length = maxZoomLevel - minZoomLevel + 1;
        this.zoomLevels = new Integer[length];
        int zoomLevel = minZoomLevel;
        int i = 0;
        while (i < length) {
            this.zoomLevels[i] = zoomLevel++;
            ++i;
        }
    }

    private WMTSource getWMTSourceOfSelectedLayer() {
        ILayer layer = this.getSelectedLayer();
        if (layer == null) {
            return null;
        }
        IGeoResource resource = layer.findGeoResource(WMTSource.class);
        if (resource == null) {
            return null;
        }
        try {
            WMTSource wmtSource = (WMTSource)resource.resolve(WMTSource.class, null);
            return wmtSource;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private ILayer getSelectedLayer() {
        StructuredSelection selection = (StructuredSelection)this.cvLayers.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (ILayer)selection.getFirstElement();
    }

    private void setSelectedLayer(ILayer layer) {
        if (layer == null || !this.layerList.contains(layer)) {
            if (this.layerList.isEmpty()) {
                return;
            }
            layer = this.layerList.get(0);
        }
        ArrayList<ILayer> selectedLayers = new ArrayList<ILayer>(1);
        selectedLayers.add(layer);
        StructuredSelection selection = new StructuredSelection(selectedLayers);
        this.cvLayers.setSelection((ISelection)selection);
    }

    private void enableComponents(boolean enabled) {
        this.cvLayers.getCombo().setEnabled(enabled);
        this.cvZoomLevels.getCombo().setEnabled(enabled);
        this.btnZoomIn.setEnabled(enabled);
        this.btnZoomOut.setEnabled(enabled);
    }

    private void updateZoomButtons(int zoomLevel) {
        boolean zoomInEnabled = true;
        boolean zoomOutEnabled = true;
        if (zoomLevel <= this.zoomLevels[0]) {
            zoomOutEnabled = false;
        } else if (zoomLevel >= this.zoomLevels[this.zoomLevels.length - 1]) {
            zoomInEnabled = false;
        }
        this.btnZoomIn.setEnabled(zoomInEnabled);
        this.btnZoomOut.setEnabled(zoomOutEnabled);
    }

    private synchronized WMTScaleZoomLevelMatcher getZoomLevelMatcher(WMTSource wmtSource) throws Exception {
        double mapScale = this.currentMap.getViewportModel().getScaleDenominator();
        ReferencedEnvelope mapExtentMapCrs = this.currentMap.getViewportModel().getBounds();
        return WMTScaleZoomLevelMatcher.createMatcher(mapExtentMapCrs, mapScale, wmtSource);
    }

    private void zoomIn() {
        int zoomLevel = this.getSelectedZoomLevel();
        if (zoomLevel < this.zoomLevels[this.zoomLevels.length - 1]) {
            this.zoomToZoomLevel(zoomLevel + 1);
        }
    }

    private void zoomOut() {
        int zoomLevel = this.getSelectedZoomLevel();
        if (zoomLevel > this.zoomLevels[0]) {
            this.zoomToZoomLevel(zoomLevel - 1);
        }
    }

    private void zoomToZoomLevel(int zoomLevel) {
        try {
            WMTSource wmtSource = this.getWMTSourceOfSelectedLayer();
            if (wmtSource == null) {
                throw new Exception("wmtSource is null");
            }
            WMTScaleZoomLevelMatcher zoomLevelMatcher = this.getZoomLevelMatcher(wmtSource);
            double scale = zoomLevelMatcher.getOptimumScaleFromZoomLevel(zoomLevel, wmtSource);
            this.zoomToScale(scale);
        }
        catch (Exception e) {
            WMTPlugin.log("[WMTZoomLevelSwitcher.zoomToZoomLevel] Zooming failed: " + zoomLevel, e);
        }
    }

    private void zoomToScale(double scale) {
        ApplicationGIS.getActiveMap().sendCommandASync((MapCommand)new SetScaleCommand(scale));
    }

    public void setFocus() {
    }
}

