/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.tile;

import java.net.HttpURLConnection;
import java.net.URL;
import net.refractions.udig.catalog.internal.wmt.WMTPlugin;
import net.refractions.udig.catalog.internal.wmt.tile.WMTTile;
import net.refractions.udig.catalog.internal.wmt.tile.WMTTileName;
import net.refractions.udig.catalog.internal.wmt.wmtsource.WMTSource;
import net.refractions.udig.catalog.internal.wmt.wmtsource.WWSource;
import net.refractions.udig.catalog.internal.wmt.wmtsource.ww.ImageAccessor;
import net.refractions.udig.core.internal.CorePlugin;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WWTile
extends WMTTile {
    private WWTileName tileName;
    private WWSource wwSource;

    public WWTile(int x, int y, WWTileName.WWZoomLevel zoomLevel, WWSource wwSource) {
        this(new WWTileName(x, y, zoomLevel, wwSource), wwSource);
    }

    public WWTile(WWTileName tileName, WWSource wwSource) {
        super(WWTile.getExtentFromTileName(tileName), tileName);
        this.tileName = tileName;
        this.wwSource = wwSource;
    }

    public WWTileName getTileName() {
        return this.tileName;
    }

    public static ReferencedEnvelope getExtentFromTileName(WWTileName tileName) {
        ReferencedEnvelope extent = new ReferencedEnvelope(WWTile.tile2lon(tileName.getX(), tileName), WWTile.tile2lon(tileName.getX() + 1, tileName), WWTile.tile2lat(tileName.getY(), tileName), WWTile.tile2lat(tileName.getY() + 1, tileName), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        return extent;
    }

    public static double tile2lat(int row, WWTileName tileName) {
        return WWSource.WORLD_BOUNDS.getMinY() + (double)row * tileName.getHeightInWorldUnits();
    }

    public static double tile2lon(int col, WWTileName tileName) {
        return WWSource.WORLD_BOUNDS.getMinX() + (double)col * tileName.getWidthInWorldUnits();
    }

    @Override
    public WWTile getLowerNeighbour() {
        return new WWTile(this.tileName.getLowerNeighbour(), this.wwSource);
    }

    @Override
    public WWTile getRightNeighbour() {
        return new WWTile(this.tileName.getRightNeighbour(), this.wwSource);
    }

    @Override
    protected void setConnectionParams(HttpURLConnection connection) {
        connection.setRequestProperty("User-Agent", "World Wind v1.4.0.0 (Microsoft Windows NT 5.1.2600.0, en-US)");
    }

    public static class WWTileFactory
    extends WMTTile.WMTTileFactory {
        @Override
        public WWTile getTileFromCoordinate(double lat, double lon, WMTTile.WMTZoomLevel zoomLevel, WMTSource wmtSource) {
            WWSource wwSource = (WWSource)wmtSource;
            lat = WMTTile.WMTTileFactory.normalizeDegreeValue(lat, 90);
            lon = WMTTile.WMTTileFactory.normalizeDegreeValue(lon, 180);
            lat = WMTTile.WMTTileFactory.moveInRange(lat, wwSource.getBounds().getMinY(), wwSource.getBounds().getMaxY());
            lon = WMTTile.WMTTileFactory.moveInRange(lon, wwSource.getBounds().getMinX(), wwSource.getBounds().getMaxX());
            WWTileName.WWZoomLevel wwZoomLevel = (WWTileName.WWZoomLevel)zoomLevel;
            int row = WMTTileName.arithmeticMod((int)Math.ceil(Math.abs((lat - WWSource.WORLD_BOUNDS.getMinY()) / wwZoomLevel.getHeightInWorldUnits())) - 1, zoomLevel.getMaxTilePerColNumber());
            int col = WMTTileName.arithmeticMod((int)Math.abs((lon - WWSource.WORLD_BOUNDS.getMinX()) / wwZoomLevel.getWidthInWorldUnits()), zoomLevel.getMaxTilePerRowNumber());
            WMTPlugin.debug("[WWTile.getTileFromCoordinate] " + zoomLevel.getZoomLevel() + "/" + col + "/" + row + " lon: " + lon + " lat: " + lat, "net.refractions.udig.catalog.wmt/debug/ww");
            return new WWTile(col, row, wwZoomLevel, (WWSource)wmtSource);
        }

        @Override
        public WMTTile.WMTZoomLevel getZoomLevel(int zoomLevel, WMTSource wmtSource) {
            WWSource wwSource = (WWSource)wmtSource;
            return wwSource.getZoomLevel(zoomLevel);
        }
    }

    public static class WWTileName
    extends WMTTileName {
        private WWZoomLevel zoomLevel;
        private WWSource wwSource;

        public WWTileName(int x, int y, WWZoomLevel zoomLevel, WWSource source) {
            super(zoomLevel, x, y, source);
            this.zoomLevel = zoomLevel;
            this.wwSource = source;
        }

        @Override
        public URL getTileUrl() {
            try {
                String tileUrl = this.zoomLevel.getTileUrl(this);
                return new URL(null, tileUrl, CorePlugin.RELAXED_HANDLER);
            }
            catch (Exception e) {
                WMTPlugin.log("[WWTile] Could not create the url for tile (Zoom: " + this.zoomLevel.getZoomLevel() + ", X: " + this.getX() + ", " + this.getY(), e);
                return null;
            }
        }

        public WWTileName getRightNeighbour() {
            return new WWTileName(WMTTileName.arithmeticMod(this.getX() + 1, this.zoomLevel.getMaxTilePerRowNumber()), this.getY(), this.zoomLevel, this.wwSource);
        }

        public WWTileName getLowerNeighbour() {
            return new WWTileName(this.getX(), WMTTileName.arithmeticMod(this.getY() - 1, this.zoomLevel.getMaxTilePerColNumber()), this.zoomLevel, this.wwSource);
        }

        public double getWidthInWorldUnits() {
            return this.zoomLevel.getWidthInWorldUnits();
        }

        public double getHeightInWorldUnits() {
            return this.zoomLevel.getHeightInWorldUnits();
        }

        public WWSource getWwSource() {
            return this.wwSource;
        }

        public String toString() {
            return String.valueOf(this.zoomLevel.getZoomLevel()) + "/" + this.getX() + "/" + this.getY();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WWTileName)) {
                return false;
            }
            WWTileName other = (WWTileName)obj;
            return this.getX() == other.getX() && this.getY() == other.getY() && this.zoomLevel.equals(other.zoomLevel);
        }

        public static class WWZoomLevel
        extends WMTTile.WMTZoomLevel
        implements Comparable<WWZoomLevel> {
            private ReferencedEnvelope boundsOfFirstTile;
            private double scale;
            private ImageAccessor imageAccessor;

            public WWZoomLevel(int zoomLevel, ReferencedEnvelope boundsOfFirstTile, double scale, ImageAccessor imageAccessor) {
                super(zoomLevel);
                this.boundsOfFirstTile = boundsOfFirstTile;
                this.imageAccessor = imageAccessor;
                this.scale = scale;
            }

            public String getTileUrl(WWTileName tileName) {
                return this.imageAccessor.getTileUrl(tileName);
            }

            @Override
            public int calculateMaxTilePerColNumber(int zoomLevel) {
                if (this.boundsOfFirstTile == null) {
                    return 0;
                }
                return (int)Math.ceil(WWSource.WORLD_BOUNDS.getHeight() / this.boundsOfFirstTile.getHeight());
            }

            @Override
            public int calculateMaxTilePerRowNumber(int zoomLevel) {
                if (this.boundsOfFirstTile == null) {
                    return 0;
                }
                return (int)Math.ceil(WWSource.WORLD_BOUNDS.getWidth() / this.boundsOfFirstTile.getWidth());
            }

            public double getScale() {
                return this.scale;
            }

            public double getWidthInWorldUnits() {
                return this.boundsOfFirstTile.getWidth();
            }

            public double getHeightInWorldUnits() {
                return this.boundsOfFirstTile.getHeight();
            }

            @Override
            public int compareTo(WWZoomLevel other) {
                return Double.compare(this.scale, other.scale);
            }
        }
    }
}

