/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.tile;

import java.io.File;
import net.refractions.udig.catalog.internal.wmt.tile.WMTTile;
import net.refractions.udig.catalog.wmsc.server.Tile;
import net.refractions.udig.catalog.wmsc.server.TileImageReadWriter;

public class WMTTileImageReadWriter
extends TileImageReadWriter {
    private String baseDir;

    public WMTTileImageReadWriter(String baseDir) {
        super(null, baseDir);
        this.baseDir = WMTTileImageReadWriter.pathCombine(baseDir, "wmt-tile-cache");
    }

    public String getTileDirectoryPath(Tile tile) {
        if (tile instanceof WMTTile) {
            return this.getTileDirectoryPath((WMTTile)tile);
        }
        return super.getTileDirectoryPath(tile);
    }

    public String getTileDirectoryPath(WMTTile tile) {
        return WMTTileImageReadWriter.pathCombine(this.baseDir, tile.getReleatedSourceId());
    }

    public String getTileFileName(Tile tile, String filetype) {
        return WMTTileImageReadWriter.pathCombine(this.getTileDirectoryPath(tile), String.valueOf(tile.getPosition()) + "." + filetype);
    }

    public static String pathCombine(String baseDir, String subDir) {
        File base = new File(baseDir);
        File sub = new File(base, subDir);
        return sub.getPath();
    }
}

