/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.tile;

import com.vividsolutions.jts.geom.Coordinate;
import java.net.MalformedURLException;
import java.net.URL;
import net.refractions.udig.catalog.internal.wmt.WMTPlugin;
import net.refractions.udig.catalog.internal.wmt.tile.WMTTile;
import net.refractions.udig.catalog.internal.wmt.tile.WMTTileName;
import net.refractions.udig.catalog.internal.wmt.wmtsource.OSMSource;
import net.refractions.udig.catalog.internal.wmt.wmtsource.WMTSource;
import net.refractions.udig.core.internal.CorePlugin;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class OSMTile
extends WMTTile {
    private OSMTileName tileName;
    private OSMSource osmSource;

    public OSMTile(int x, int y, OSMTileName.OSMZoomLevel zoomLevel, OSMSource osmSource) {
        this(new OSMTileName(x, y, zoomLevel, osmSource), osmSource);
    }

    public OSMTile(OSMTileName tileName, OSMSource osmSource) {
        super(OSMTile.getExtentFromTileName(tileName), tileName);
        this.tileName = tileName;
        this.osmSource = osmSource;
    }

    @Override
    public OSMTile getRightNeighbour() {
        return new OSMTile(this.tileName.getRightNeighbour(), this.osmSource);
    }

    @Override
    public OSMTile getLowerNeighbour() {
        return new OSMTile(this.tileName.getLowerNeighbour(), this.osmSource);
    }

    public Coordinate getCenter() {
        return new Coordinate(OSMTile.tile2lon((double)this.tileName.getX() + 0.5, this.tileName.zoomLevel.getZoomLevel()), OSMTile.tile2lat((double)this.tileName.getY() + 0.5, this.tileName.zoomLevel.getZoomLevel()));
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OSMTile)) {
            return false;
        }
        OSMTile other = (OSMTile)obj;
        return this.tileName.equals(other.tileName);
    }

    public static ReferencedEnvelope getExtentFromTileName(OSMTileName tileName) {
        ReferencedEnvelope extent = new ReferencedEnvelope(OSMTile.tile2lon(tileName.getX(), tileName.zoomLevel.getZoomLevel()), OSMTile.tile2lon(tileName.getX() + 1, tileName.zoomLevel.getZoomLevel()), OSMTile.tile2lat(tileName.getY(), tileName.zoomLevel.getZoomLevel()), OSMTile.tile2lat(tileName.getY() + 1, tileName.zoomLevel.getZoomLevel()), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        return extent;
    }

    private static double tile2lon(double x, int z) {
        return x / Math.pow(2.0, z) * 360.0 - 180.0;
    }

    private static double tile2lat(double y, int z) {
        double n = Math.PI - Math.PI * 2 * y / Math.pow(2.0, z);
        return 57.29577951308232 * Math.atan(0.5 * (Math.exp(n) - Math.exp(-n)));
    }

    public static class OSMTileFactory
    extends WMTTile.WMTTileFactory {
        @Override
        public OSMTile getTileFromCoordinate(double lat, double lon, WMTTile.WMTZoomLevel zoomLevel, WMTSource wmtSource) {
            lat = WMTTile.WMTTileFactory.normalizeDegreeValue(lat, 90);
            lon = WMTTile.WMTTileFactory.normalizeDegreeValue(lon, 180);
            lat = WMTTile.WMTTileFactory.moveInRange(lat, -85.0511, 85.0511);
            int xTile = (int)Math.floor((lon + 180.0) / 360.0 * (double)(1 << zoomLevel.getZoomLevel()));
            int yTile = (int)Math.floor((1.0 - Math.log(Math.tan(lat * Math.PI / 180.0) + 1.0 / Math.cos(lat * Math.PI / 180.0)) / Math.PI) / 2.0 * (double)(1 << zoomLevel.getZoomLevel()));
            WMTPlugin.debug("[OSMTile.getTileFromCoordinate] " + zoomLevel.getZoomLevel() + "/" + xTile + "/" + yTile + " lon: " + lon + " lat: " + lat, "net.refractions.udig.catalog.wmt/debug/osm");
            return new OSMTile(xTile, yTile, (OSMTileName.OSMZoomLevel)zoomLevel, (OSMSource)wmtSource);
        }

        @Override
        public WMTTile.WMTZoomLevel getZoomLevel(int zoomLevel, WMTSource wmtSource) {
            return new OSMTileName.OSMZoomLevel(zoomLevel);
        }
    }

    public static class OSMTileName
    extends WMTTileName {
        private OSMZoomLevel zoomLevel;
        private OSMSource osmSource;

        public OSMTileName(int x, int y, OSMZoomLevel zoomLevel, OSMSource source) {
            super(zoomLevel, x, y, source);
            this.zoomLevel = zoomLevel;
            this.osmSource = source;
        }

        @Override
        public URL getTileUrl() {
            try {
                return new URL(null, this.osmSource.getTileUrl(this.zoomLevel.getZoomLevel(), this.getX(), this.getY()), CorePlugin.RELAXED_HANDLER);
            }
            catch (MalformedURLException e) {
                WMTPlugin.log("[OSMTile] Could not create the url for tile (Zoom: " + this.zoomLevel.getZoomLevel() + ", X: " + this.getX() + ", " + this.getY(), e);
                return null;
            }
        }

        public OSMTileName getRightNeighbour() {
            return new OSMTileName(WMTTileName.arithmeticMod(this.getX() + 1, this.zoomLevel.getMaxTilePerRowNumber()), this.getY(), this.zoomLevel, this.osmSource);
        }

        public OSMTileName getLowerNeighbour() {
            return new OSMTileName(this.getX(), WMTTileName.arithmeticMod(this.getY() + 1, this.zoomLevel.getMaxTilePerColNumber()), this.zoomLevel, this.osmSource);
        }

        public String toString() {
            return String.valueOf(this.zoomLevel.getZoomLevel()) + "/" + this.getX() + "/" + this.getY();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OSMTileName)) {
                return false;
            }
            OSMTileName other = (OSMTileName)obj;
            return this.getX() == other.getX() && this.getY() == other.getY() && this.zoomLevel.equals(other.zoomLevel);
        }

        public static class OSMZoomLevel
        extends WMTTile.WMTZoomLevel {
            public OSMZoomLevel(int zoomLevel) {
                super(zoomLevel);
            }

            @Override
            public int calculateMaxTilePerColNumber(int zoomLevel) {
                return 1 << zoomLevel;
            }

            @Override
            public int calculateMaxTilePerRowNumber(int zoomLevel) {
                return this.calculateMaxTilePerColNumber(zoomLevel);
            }
        }
    }
}

