/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.tile;

import eu.udig.mapquest.apiwrapper.MQAPIWrapper;
import java.net.URL;
import net.refractions.udig.catalog.internal.wmt.WMTPlugin;
import net.refractions.udig.catalog.internal.wmt.tile.WMTTile;
import net.refractions.udig.catalog.internal.wmt.tile.WMTTileName;
import net.refractions.udig.catalog.internal.wmt.wmtsource.MQSource;
import net.refractions.udig.catalog.internal.wmt.wmtsource.WMTSource;
import net.refractions.udig.core.internal.CorePlugin;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MQTile
extends WMTTile {
    private MQTileName tileName;
    private MQSource mqSource;

    public MQTile(int x, int y, MQTileName.MQZoomLevel zoomLevel, MQSource mqSource) {
        this(new MQTileName(x, y, zoomLevel, mqSource), mqSource);
    }

    public MQTile(MQTileName tileName, MQSource mqSource) {
        super(MQTile.getExtentFromTileName(tileName), tileName);
        this.tileName = tileName;
        this.mqSource = mqSource;
    }

    public static ReferencedEnvelope getExtentFromTileName(MQTileName tileName) {
        int scale = (int)MQSource.scaleList[tileName.zoomLevel.getZoomLevel()];
        ReferencedEnvelope extent = new ReferencedEnvelope(MQTile.tile2lon(tileName.getX(), scale), MQTile.tile2lon(tileName.getX() + 1, scale), MQTile.tile2lat(tileName.getY() + 1, scale), MQTile.tile2lat(tileName.getY(), scale), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        return extent;
    }

    public static double tile2lat(double row, int scale) {
        return MQTile.pixel2lat(320.0 * row, scale);
    }

    public static double tile2lon(double col, int scale) {
        return MQTile.pixel2lon(512.0 * col, scale);
    }

    public static double pixel2lat(double y, int scale) {
        return y / (3.15552459661917E8 / (double)scale) - 90.0;
    }

    public static double pixel2lon(double x, int scale) {
        return x / (2.5034459790989706E8 / (double)scale) - 180.0;
    }

    @Override
    public MQTile getLowerNeighbour() {
        return new MQTile(this.tileName.getLowerNeighbour(), this.mqSource);
    }

    @Override
    public MQTile getRightNeighbour() {
        return new MQTile(this.tileName.getRightNeighbour(), this.mqSource);
    }

    public static class MQTileFactory
    extends WMTTile.WMTTileFactory {
        @Override
        public MQTile getTileFromCoordinate(double lat, double lon, WMTTile.WMTZoomLevel zoomLevel, WMTSource wmtSource) {
            lat = WMTTile.WMTTileFactory.normalizeDegreeValue(lat, 90);
            lon = WMTTile.WMTTileFactory.normalizeDegreeValue(lon, 180);
            double y = (lat + 90.0) * (3.15552459661917E8 / MQSource.scaleList[zoomLevel.getZoomLevel()]);
            int row = (int)(y / 320.0);
            double x = (lon + 180.0) * (2.5034459790989706E8 / MQSource.scaleList[zoomLevel.getZoomLevel()]);
            int col = (int)(x / 512.0);
            WMTPlugin.debug("[MQTile.getTileFromCoordinate] " + zoomLevel.getZoomLevel() + "/" + col + "/" + row + " lon: " + lon + " lat: " + lat, "net.refractions.udig.catalog.wmt/debug/mq");
            return new MQTile(col, row, (MQTileName.MQZoomLevel)zoomLevel, (MQSource)wmtSource);
        }

        @Override
        public WMTTile.WMTZoomLevel getZoomLevel(int zoomLevel, WMTSource wmtSource) {
            return new MQTileName.MQZoomLevel(zoomLevel);
        }
    }

    public static class MQTileName
    extends WMTTileName {
        private MQZoomLevel zoomLevel;
        private MQSource mqSource;

        public MQTileName(int x, int y, MQZoomLevel zoomLevel, MQSource source) {
            super(zoomLevel, x, y, source);
            this.zoomLevel = zoomLevel;
            this.mqSource = source;
        }

        @Override
        public URL getTileUrl() {
            try {
                int scale = (int)MQSource.scaleList[this.zoomLevel.getZoomLevel()];
                double lon = this.getCenterLon(scale);
                double lat = this.getCenterLat(scale);
                MQAPIWrapper apiWrapper = this.mqSource.getApiWrapper();
                String mapImageUrl = apiWrapper.getUrl(scale, lon, lat, 512, 320);
                return new URL(null, mapImageUrl, CorePlugin.RELAXED_HANDLER);
            }
            catch (Exception e) {
                WMTPlugin.log("[MQTile] Could not create the url for tile (Zoom: " + this.zoomLevel.getZoomLevel() + ", X: " + this.getX() + ", " + this.getY(), e);
                return null;
            }
        }

        public double getCenterLon(int scale) {
            return MQTile.tile2lon((double)this.getX() + 0.5, scale);
        }

        public double getCenterLat(int scale) {
            return MQTile.tile2lat((double)this.getY() + 0.5, scale);
        }

        public MQTileName getRightNeighbour() {
            return new MQTileName(WMTTileName.arithmeticMod(this.getX() + 1, this.zoomLevel.getMaxTilePerRowNumber()), this.getY(), this.zoomLevel, this.mqSource);
        }

        public MQTileName getLowerNeighbour() {
            return new MQTileName(this.getX(), WMTTileName.arithmeticMod(this.getY() - 1, this.zoomLevel.getMaxTilePerColNumber()), this.zoomLevel, this.mqSource);
        }

        public String toString() {
            return String.valueOf(this.zoomLevel.getZoomLevel()) + "/" + this.getX() + "/" + this.getY();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MQTileName)) {
                return false;
            }
            MQTileName other = (MQTileName)obj;
            return this.getX() == other.getX() && this.getY() == other.getY() && this.zoomLevel.equals(other.zoomLevel);
        }

        public static class MQZoomLevel
        extends WMTTile.WMTZoomLevel {
            public static final int[] maxTileNumbers = new int[]{2, 6, 18, 50, 117, 251, 542, 1136, 2347, 4889, 9779, 19558, 37450, 70409, 117349, 176024};

            public MQZoomLevel(int zoomLevel) {
                super(zoomLevel);
            }

            @Override
            public int calculateMaxTilePerColNumber(int zoomLevel) {
                return maxTileNumbers[zoomLevel];
            }

            @Override
            public int calculateMaxTilePerRowNumber(int zoomLevel) {
                return this.calculateMaxTilePerColNumber(zoomLevel);
            }
        }
    }
}

