/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt;

import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.ServiceExtension;
import net.refractions.udig.catalog.internal.wmt.WMTPlugin;
import net.refractions.udig.catalog.internal.wmt.WMTService;
import net.refractions.udig.catalog.internal.wmt.wmtsource.WMTSource;

public class WMTServiceExtension
implements ServiceExtension {
    public static final String KEY = "net.refractions.udig.catalog.internal.wmt.url";

    public WMTService createService(URL id, Map<String, Serializable> params) {
        if (params == null) {
            return null;
        }
        if (params.containsKey(KEY)) {
            WMTPlugin.trace("[WMTService.createService] " + params.get(KEY), null);
            return new WMTService(params);
        }
        return null;
    }

    public WMTService createService(Map<String, Serializable> params) {
        if (params != null && params.containsKey(KEY)) {
            return this.createService((URL)params.get(KEY), (Map)params);
        }
        return null;
    }

    public WMTService createService(Class<? extends WMTSource> sourceClass) {
        URL url = WMTSource.getRelatedServiceUrl(sourceClass);
        IService service = this.createService((URL)null, (Map)this.createParams(url));
        return service;
    }

    public Map<String, Serializable> createParams(URL url) {
        if (url != null && url.toExternalForm().startsWith(WMTService.ID)) {
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            map.put(KEY, url);
            return map;
        }
        return null;
    }
}

